/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.plugin;

import java.util.Collections;
import java.util.Set;
import org.jboss.galleon.util.CollectionUtils;

public class PluginOption {
    private final String name;
    private final boolean required;
    private final boolean acceptsValue;
    private final boolean persistent;
    private final String defaultValue;
    private final Set<String> valueSet;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private PluginOption(String name) {
        this.name = name;
        this.required = false;
        this.acceptsValue = false;
        this.persistent = true;
        this.defaultValue = null;
        this.valueSet = Collections.emptySet();
    }

    private PluginOption(Builder builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.acceptsValue = builder.acceptsValue;
        this.persistent = builder.persistent;
        this.defaultValue = builder.defaultValue;
        this.valueSet = builder.valueSet;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAcceptsValue() {
        return this.acceptsValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Set<String> getValueSet() {
        return this.valueSet;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acceptsValue ? 1231 : 1237);
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.persistent ? 1231 : 1237);
        result = 31 * result + (this.required ? 1231 : 1237);
        result = 31 * result + (this.valueSet == null ? 0 : this.valueSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginOption other = (PluginOption)obj;
        if (this.acceptsValue != other.acceptsValue) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.persistent != other.persistent) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        return !(this.valueSet == null ? other.valueSet != null : !this.valueSet.equals(other.valueSet));
    }

    public static class Builder {
        private final String name;
        private boolean required;
        private boolean acceptsValue = true;
        private boolean persistent = true;
        private String defaultValue;
        private Set<String> valueSet = Collections.emptySet();

        private Builder(String name) {
            this.name = name;
        }

        public Builder setRequired() {
            this.required = true;
            return this;
        }

        public Builder hasNoValue() {
            this.acceptsValue = false;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder addToValueSet(String value) {
            this.valueSet = CollectionUtils.add(this.valueSet, value);
            return this;
        }

        public Builder setPersistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public PluginOption build() {
            return new PluginOption(this);
        }
    }
}

