/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.state.FeaturePack;

public class FeaturePackRuntime
extends FeaturePackLayout
implements FeaturePack<PackageRuntime> {
    private final Map<String, PackageRuntime> packages;
    private final Map<String, ResolvedFeatureSpec> featureSpecs;

    FeaturePackRuntime(FeaturePackRuntimeBuilder builder) throws ProvisioningException {
        super(builder.producer.getLocation().getFPID(), builder.getDir(), builder.getType());
        this.spec = builder.getSpec();
        this.featureSpecs = builder.featureSpecs;
        LinkedHashMap<String, PackageRuntime> tmpPackages = new LinkedHashMap<String, PackageRuntime>();
        for (String pkgName : builder.pkgOrder) {
            PackageRuntime.Builder pkgRtBuilder = builder.pkgBuilders.get(pkgName);
            tmpPackages.put(pkgName, pkgRtBuilder.build(this));
        }
        this.packages = Collections.unmodifiableMap(tmpPackages);
    }

    @Override
    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    @Override
    public boolean containsPackage(String name) {
        return this.packages.containsKey(name);
    }

    @Override
    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    @Override
    public Collection<PackageRuntime> getPackages() {
        return this.packages.values();
    }

    @Override
    public PackageRuntime getPackage(String name) {
        return this.packages.get(name);
    }

    public Set<String> getFeatureSpecNames() {
        return this.featureSpecs.keySet();
    }

    public Collection<ResolvedFeatureSpec> getFeatureSpecs() {
        return this.featureSpecs.values();
    }

    public FeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        if (this.featureSpecs.containsKey(name)) {
            return this.featureSpecs.get((Object)name).xmlSpec;
        }
        return this.loadFeatureSpec(name);
    }

    public ResolvedFeatureSpec getResolvedFeatureSpec(String name) throws ProvisioningDescriptionException {
        return this.featureSpecs.get(name);
    }
}

