/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cache;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.ZipUtils;

public class FeaturePackCacheManager
implements Closeable {
    private final Path home;
    private final OverwritePolicy overwritePolicy;

    public FeaturePackCacheManager() {
        this(null, null);
    }

    public FeaturePackCacheManager(Path home) {
        this(home, null);
    }

    public FeaturePackCacheManager(Path home, OverwritePolicy overwritePolicy) {
        this.home = home == null ? IoUtils.createRandomTmpDir() : home;
        this.overwritePolicy = overwritePolicy == null ? new DefaultOverwritePolicy() : overwritePolicy;
    }

    public Path put(UniverseResolver universeResolver, FeaturePackLocation fpl) throws ProvisioningException {
        Path fpDir = LayoutUtils.getFeaturePackDir(this.home, fpl.getFPID(), false);
        if (Files.exists(fpDir, new LinkOption[0])) {
            if (!this.overwritePolicy.hasExpired(fpDir, fpl.getFPID())) {
                return fpDir;
            }
            IoUtils.recursiveDelete(fpDir);
        }
        this.unpack(fpDir, universeResolver.resolve(fpl));
        this.overwritePolicy.cached(fpl.getFPID());
        return fpDir;
    }

    public Path put(Path featurePack, FeaturePackLocation.FPID fpid) throws ProvisioningException {
        Path fpDir = LayoutUtils.getFeaturePackDir(this.home, fpid, false);
        if (Files.exists(fpDir, new LinkOption[0])) {
            IoUtils.recursiveDelete(fpDir);
        }
        this.unpack(fpDir, featurePack);
        this.overwritePolicy.cached(fpid);
        return fpDir;
    }

    public void remove(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        IoUtils.recursiveDelete(LayoutUtils.getFeaturePackDir(this.home, fpid, false));
    }

    @Override
    public void close() {
        IoUtils.recursiveDelete(this.home);
    }

    public Path getHome() {
        return this.home;
    }

    private void unpack(Path fpDir, Path artifactPath) throws ProvisioningException {
        try {
            Files.createDirectories(fpDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.mkdirs(fpDir), e);
        }
        try {
            ZipUtils.unzip(artifactPath, fpDir);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to unzip " + artifactPath + " to " + fpDir, e);
        }
    }

    private static class DefaultOverwritePolicy
    implements OverwritePolicy {
        private DefaultOverwritePolicy() {
        }

        @Override
        public boolean hasExpired(Path fpDir, FeaturePackLocation.FPID fpid) {
            return false;
        }

        @Override
        public void cached(FeaturePackLocation.FPID fpid) {
        }
    }

    public static interface OverwritePolicy {
        public boolean hasExpired(Path var1, FeaturePackLocation.FPID var2);

        public void cached(FeaturePackLocation.FPID var1);
    }
}

