/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.Arrays;
import java.util.List;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;

public class BooleanCompleter
extends AbstractCompleter {
    private static final List<String> VALUES = Arrays.asList("false", "true");

    @Override
    protected List<String> getItems(PmCompleterInvocation completerInvocation) {
        return VALUES;
    }

    public static Boolean validateValue(String value) throws CommandExecutionException {
        if (value != null) {
            if (!VALUES.contains(value)) {
                throw new CommandExecutionException(CliErrors.invalidBoolean(value));
            }
            return Boolean.parseBoolean(value);
        }
        return null;
    }
}

