/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.state.ConfigProvisioning;
import org.jboss.galleon.cli.model.state.FeaturePackProvisioning;
import org.jboss.galleon.cli.model.state.Provisioning;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class State {
    private ProvisioningConfig config;
    private FeatureContainer container;
    private String path;
    private ProvisioningConfig.Builder builder;
    private final FeaturePackProvisioning fpProvisioning = new FeaturePackProvisioning();
    private final Provisioning provisioning = new Provisioning();
    private final ConfigProvisioning configProvisioning = new ConfigProvisioning();
    private final Deque<Action> stack = new ArrayDeque<Action>();
    private ProvisioningRuntime runtime;
    private String name;

    public State(PmSession pmSession) throws ProvisioningException, IOException {
        this.init(pmSession);
    }

    public void close() {
        this.runtime.close();
    }

    public State(PmSession pmSession, Path installation) throws ProvisioningException, IOException {
        ProvisioningConfig conf;
        if (Files.isRegularFile(installation, new LinkOption[0])) {
            conf = ProvisioningXmlParser.parse(installation);
        } else {
            PathsUtils.assertInstallationDir(installation);
            conf = ProvisioningXmlParser.parse(PathsUtils.getProvisioningXml(installation));
        }
        HashSet<FeaturePackLocation.FPID> dependencies = new HashSet<FeaturePackLocation.FPID>();
        for (FeaturePackConfig cf : conf.getFeaturePackDeps()) {
            dependencies.add(cf.getLocation().getFPID());
        }
        this.builder = conf.getBuilder();
        this.config = this.buildNewConfig(pmSession);
        this.path = "/";
        this.name = installation.getFileName().toString();
    }

    public String getName() {
        return this.name;
    }

    public ProvisioningRuntime getRuntime() {
        return this.runtime;
    }

    private void init(PmSession pmSession) throws ProvisioningException, IOException {
        this.builder = ProvisioningConfig.builder();
        this.config = this.builder.build();
        this.runtime = ProvisioningRuntimeBuilder.newInstance(pmSession.getMessageWriter(false)).initLayout(pmSession.getLayoutFactory(), this.config).build();
        this.container = FeatureContainers.fromProvisioningRuntime(pmSession, this.runtime);
        this.container.setEdit(true);
        this.path = "/";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean hasActions() {
        return !this.stack.isEmpty();
    }

    public ProvisioningConfig getConfig() {
        return this.config;
    }

    public FeatureContainer getContainer() {
        return this.container;
    }

    public void addDependency(PmSession pmSession, String name, FeaturePackLocation fpl, boolean inheritConfigs, boolean inheritPackages) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.addDependency(pmSession, name, fpl, inheritConfigs, inheritPackages);
        this.config = this.pushState(action, pmSession);
    }

    public void removeDependency(PmSession pmSession, FeaturePackLocation fpl) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeDependency(fpl);
        this.config = this.pushState(action, pmSession);
    }

    public void includeConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.includeConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeIncludedConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeIncludedConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void excludeConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.excludeConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeExcludedConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeExcludedConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void resetConfiguration(PmSession pmSession, ConfigInfo configuration) throws ProvisioningException, IOException {
        ConfigId id = new ConfigId(configuration.getModel(), configuration.getName());
        Action action = this.configProvisioning.resetConfiguration(id);
        this.config = this.pushState(action, pmSession);
    }

    public void includePackage(PmSession pmSession, String pkg, FeaturePackConfig cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.includePackage(pkg, cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeIncludedPackage(PmSession pmSession, Map<FeaturePackConfig, String> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeIncludedPackage(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void excludePackage(PmSession pmSession, String pkg, FeaturePackConfig cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.excludePackage(pkg, cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeExcludedPackage(PmSession pmSession, Map<FeaturePackConfig, String> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeExcludedPackage(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void addFeature(PmSession pmSession, FeatureSpecInfo spec, ConfigInfo configuration, Map<String, String> options) throws ProvisioningException, IOException {
        ConfigId id = new ConfigId(configuration.getModel(), configuration.getName());
        Action action = this.configProvisioning.addFeature(id, spec, options);
        this.config = this.pushState(action, pmSession);
    }

    public void removeFeature(PmSession pmSession, ConfigInfo ci, FeatureInfo fi) throws ProvisioningException, IOException {
        ConfigId id = new ConfigId(ci.getModel(), ci.getName());
        Action action = this.configProvisioning.removeFeature(id, fi);
        this.config = this.pushState(action, pmSession);
    }

    public void addUniverse(PmSession pmSession, String name, String factory, String location) throws ProvisioningException, IOException {
        Action action = this.provisioning.addUniverse(name, factory, location);
        this.config = this.pushState(action, pmSession);
    }

    public void removeUniverse(PmSession pmSession, String name) throws ProvisioningException, IOException {
        Action action = this.provisioning.removeUniverse(name);
        this.config = this.pushState(action, pmSession);
    }

    public void export(Path file) throws Exception {
        ProvisioningXmlWriter.getInstance().write(this.config, file);
    }

    public void pop(PmSession pmSession) throws IOException, ProvisioningException {
        Action action = this.stack.peek();
        if (action != null) {
            this.config = this.popState(action, pmSession);
        }
    }

    private ProvisioningConfig pushState(Action action, PmSession pmSession) throws IOException, ProvisioningException {
        action.doAction(this.config, this.builder);
        try {
            ProvisioningConfig newConfig = this.buildNewConfig(pmSession);
            this.stack.push(action);
            return newConfig;
        }
        catch (Exception ex) {
            try {
                action.undoAction(this.builder);
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private ProvisioningConfig popState(Action action, PmSession pmSession) throws IOException, ProvisioningException {
        action.undoAction(this.builder);
        try {
            ProvisioningConfig newConfig = this.buildNewConfig(pmSession);
            this.stack.remove();
            return newConfig;
        }
        catch (IOException | ProvisioningException ex) {
            action.doAction(this.config, this.builder);
            throw ex;
        }
    }

    private ProvisioningConfig buildNewConfig(PmSession pmSession) throws ProvisioningException, IOException {
        ProvisioningConfig tmp = this.builder.build();
        if (this.runtime != null) {
            this.runtime.close();
        }
        this.runtime = ProvisioningRuntimeBuilder.newInstance(pmSession.getMessageWriter(false)).initLayout(pmSession.getLayoutFactory(), tmp).build();
        HashSet<FeaturePackLocation.FPID> dependencies = new HashSet<FeaturePackLocation.FPID>();
        for (FeaturePackRuntime rt : this.runtime.getFeaturePacks()) {
            dependencies.add(rt.getFPID());
        }
        FeatureContainer tmpContainer = FeatureContainers.fromProvisioningRuntime(pmSession, this.runtime);
        HashMap<String, FeatureContainer> tmpDeps = new HashMap<String, FeatureContainer>();
        if (this.container != null) {
            tmpDeps.putAll(this.container.getFullDependencies());
        }
        this.buildDependencies(pmSession, dependencies, tmpDeps);
        this.container = tmpContainer;
        this.container.setEdit(true);
        this.container.setFullDependencies(tmpDeps);
        return tmp;
    }

    private void buildDependencies(PmSession session, Set<FeaturePackLocation.FPID> dependencies, Map<String, FeatureContainer> deps) throws ProvisioningException, IOException {
        for (FeaturePackLocation.FPID fpid : dependencies) {
            String orig = Identity.buildOrigin(fpid.getProducer());
            if (deps.containsKey(orig)) continue;
            deps.put(orig, FeatureContainers.fromFeaturePackId(session, fpid, null));
        }
        Iterator<FeatureContainer> it = deps.values().iterator();
        while (it.hasNext()) {
            FeatureContainer fc = it.next();
            if (dependencies.contains(fc.getFPID())) continue;
            it.remove();
        }
    }

    static interface Action {
        public void doAction(ProvisioningConfig var1, ProvisioningConfig.Builder var2) throws ProvisioningException;

        public void undoAction(ProvisioningConfig.Builder var1) throws ProvisioningException;
    }
}

