/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.StateHistoryUtils;

public class PathsUtils {
    public static void assertInstallationDir(Path path) throws ProvisioningException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new ProvisioningException(Errors.notADir(path));
        }
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                Iterator<Path> i = stream.iterator();
                if (!i.hasNext()) {
                    return;
                }
                while (i.hasNext()) {
                    if (!i.next().getFileName().toString().equals(".galleon")) continue;
                    return;
                }
                try {
                    throw new ProvisioningException(Errors.homeDirNotUsable(path));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory(path));
        }
    }

    public static Path getProvisionedStateDir(Path home) {
        return home.resolve(".galleon");
    }

    public static Path getProvisioningXml(Path home) {
        return PathsUtils.getProvisionedStateDir(home).resolve("provisioning.xml");
    }

    public static Path getProvisionedStateXml(Path home) {
        return PathsUtils.getProvisionedStateDir(home).resolve("provisioned.xml");
    }

    public static Path getStateHistoryDir(Path home) {
        return PathsUtils.getProvisionedStateDir(home).resolve("history");
    }

    public static Path getStateHistoryFile(Path home) {
        return PathsUtils.getStateHistoryDir(home).resolve("list");
    }

    public static String toForwardSlashSeparator(String path) {
        if (File.separatorChar == '/') {
            return path;
        }
        return path.replace(File.separatorChar, '/');
    }

    public static void replaceDist(Path stagedDir, Path home, boolean asUndo, MessageWriter log) throws ProvisioningException {
        log.verbose("Moving the provisioned installation from the staged directory to %s", home);
        if (Files.exists(home, new LinkOption[0])) {
            if (asUndo) {
                StateHistoryUtils.removeLastUndoConfig(home, stagedDir, log);
            } else {
                StateHistoryUtils.addNewUndoConfig(home, stagedDir, log);
            }
            IoUtils.recursiveDelete(home);
        }
        try {
            IoUtils.copy(stagedDir, home);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(stagedDir, home));
        }
    }
}

