/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Option;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public abstract class AbstractProvisioningCommand
extends PmSessionCommand
implements CommandWithInstallationDirectory {
    public static final String DIR_OPTION_NAME = "dir";
    public static final String VERBOSE_OPTION_NAME = "verbose";
    @Option(name="dir", required=false, description="Installation directory", activator=DirActivator.class)
    protected File targetDirArg;

    protected ProvisioningManager getManager(PmSession session, boolean verbose) throws ProvisioningException {
        Path install = this.getInstallationDirectory(session.getAeshContext());
        if (!Files.exists(install, new LinkOption[0])) {
            throw new ProvisioningException(Errors.homeDirNotUsable(install));
        }
        return session.newProvisioningManager(install, verbose);
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        return this.targetDirArg == null ? PmSession.getWorkDir(context) : this.targetDirArg.toPath();
    }

    public FeatureContainer getFeatureContainer(PmSession session, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException, CommandExecutionException, IOException {
        FeatureContainer container;
        ProvisioningManager manager = this.getManager(session, false);
        if (manager.getProvisionedState() == null) {
            throw new CommandExecutionException("Specified directory doesn't contain an installation");
        }
        if (layout == null) {
            ProvisioningConfig config = manager.getProvisioningConfig();
            try (ProvisioningRuntime runtime = manager.getRuntime(config);){
                container = FeatureContainers.fromProvisioningRuntime(session, runtime);
            }
        }
        try (ProvisioningRuntime runtime = manager.getRuntime(layout);){
            container = FeatureContainers.fromProvisioningRuntime(session, runtime);
        }
        return container;
    }

    protected ProvisioningConfig getProvisioningConfig(PmSession session) throws ProvisioningException, CommandExecutionException {
        ProvisioningManager manager = this.getManager(session, false);
        if (manager.getProvisionedState() == null) {
            throw new CommandExecutionException("Specified directory doesn't contain an installation");
        }
        return manager.getProvisioningConfig();
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    public static class DirActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            return this.getPmSession().getContainer() == null;
        }
    }
}

