/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.maingrp.LayersConfigBuilder;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class InstallCommand
extends AbstractPluginsCommand {
    public static final String FILE_OPTION_NAME = "file";
    public static final String LAYERS_OPTION_NAME = "layers";
    public static final String CONFIG_OPTION_NAME = "config";
    public static final String MODEL_OPTION_NAME = "model";

    public InstallCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, FeaturePackLocation loc) throws CommandExecutionException {
        try {
            String filePath = (String)this.getValue(FILE_OPTION_NAME);
            ProvisioningManager manager = this.getManager(session);
            String layers = (String)this.getValue(LAYERS_OPTION_NAME);
            if (filePath != null) {
                Path p = Util.resolvePath(session.getConfiguration().getAeshContext(), filePath);
                loc = session.getPmSession().getLayoutFactory().addLocal(p, true);
            }
            if (layers == null) {
                manager.install(loc, options);
            } else {
                if (!options.containsKey("optional-packages")) {
                    options.put("optional-packages", "passive");
                }
                manager.provision(new LayersConfigBuilder(this.pmSession, layers.split(","), (String)this.getValue(MODEL_OPTION_NAME), (String)this.getValue(CONFIG_OPTION_NAME), loc).build(), options);
            }
            if (!loc.hasBuild()) {
                loc = this.getManager(session).getProvisioningConfig().getFeaturePackDep(loc.getProducer()).getLocation();
            }
            session.println("Feature pack installed.");
            StateInfoUtil.printFeaturePack(session, session.getPmSession().getExposedLocation(manager.getInstallationHome(), loc));
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.installFailed(), ex);
        }
    }

    @Override
    protected Set<ProvisioningOption> getPluginOptions(FeaturePackLocation loc) throws ProvisioningException {
        try {
            String file = (String)this.getValue(FILE_OPTION_NAME);
            if (file == null) {
                file = this.getOptionValue(FILE_OPTION_NAME);
            }
            if (file == null) {
                return this.pmSession.getResolver().get(loc.toString(), PluginResolver.newResolver(this.pmSession, loc)).getInstall();
            }
            return this.pmSession.getResolver().get(file, PluginResolver.newResolver(this.pmSession, loc)).getInstall();
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new ProvisioningException(ex);
        }
        catch (ExecutionException ex) {
            throw new ProvisioningException(ex.getCause());
        }
    }

    @Override
    protected String getName() {
        return "install";
    }

    @Override
    protected String getDescription() {
        return "Installs specified feature pack";
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption dir = ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Installation directory").completer(FileOptionCompleter.class).build();
        options.add(dir);
        ProcessedOption file = ProcessedOptionBuilder.builder().name(FILE_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).activator(new FileOptionActivator()).description("Path to feature pack zip file").completer(FileOptionCompleter.class).build();
        options.add(file);
        ProcessedOption layers = ProcessedOptionBuilder.builder().name(LAYERS_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Comma seperated list of layers").build();
        options.add(layers);
        ProcessedOption model = ProcessedOptionBuilder.builder().name(MODEL_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("The layers model").build();
        options.add(model);
        ProcessedOption config = ProcessedOptionBuilder.builder().name(CONFIG_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("The newly created configuration name.").build();
        options.add(config);
        return options;
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        String filePath = (String)this.getValue(FILE_OPTION_NAME);
        if (filePath == null && (filePath = this.getOptionValue(FILE_OPTION_NAME)) == null) {
            return super.getId(session);
        }
        Path path = Util.resolvePath(session.getAeshContext(), filePath);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return FeaturePackDescriber.readSpec(path).getFPID().toString();
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session, CliErrors.retrieveFeaturePackID(), ex);
        }
    }

    String getModel(PmSession session) throws CommandExecutionException {
        String model = (String)this.getValue(MODEL_OPTION_NAME);
        if (model == null) {
            model = this.getOptionValue(MODEL_OPTION_NAME);
        }
        return model;
    }

    @Override
    protected OptionActivator getArgumentActivator() {
        return new ArgOptionActivator();
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String filePath = (String)this.getValue(FILE_OPTION_NAME);
        if (filePath == null) {
            super.doValidateOptions(invoc);
            return;
        }
        String arg = (String)this.getValue("");
        if (arg != null) {
            throw new CommandExecutionException("Only one of file or Feature-pack location is allowed.");
        }
        Path p = Util.resolvePath(invoc.getConfiguration().getAeshContext(), filePath);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new CommandExecutionException(p + " doesn't exist.");
        }
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        String targetDirArg = (String)this.getValue("dir");
        if (targetDirArg == null) {
            targetDirArg = this.getOptionValue("dir");
        }
        if (targetDirArg != null) {
            return true;
        }
        Path workDir = PmSession.getWorkDir(pmSession.getAeshContext());
        return Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0]) || workDir.toFile().list().length == 0;
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        String targetDirArg = (String)this.getValue("dir");
        Path workDir = PmSession.getWorkDir(context);
        return targetDirArg == null ? workDir : Util.resolvePath(context, targetDirArg);
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    private class FileOptionActivator
    implements OptionActivator {
        private FileOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.argument();
            return opt == null || opt.value() == null;
        }
    }

    private class ArgOptionActivator
    implements OptionActivator {
        private ArgOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(InstallCommand.FILE_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class LayersCompleter
    extends AbstractCommaSeparatedCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            InstallCommand cmd = (InstallCommand)completerInvocation.getCommand();
            try {
                String model = cmd.getModel(completerInvocation.getPmSession());
                String fpid = cmd.getId(completerInvocation.getPmSession());
                if (fpid != null) {
                    FeaturePackLocation loc = FeaturePackLocation.fromString(fpid);
                    ArrayList<String> ret = new ArrayList<String>();
                    String buffer = completerInvocation.getGivenCompleteValue();
                    HashSet<String> excluded = new HashSet<String>();
                    if (buffer != null) {
                        String[] arr;
                        for (String a : arr = buffer.split(",")) {
                            if (a.isEmpty()) continue;
                            excluded.add(a.trim());
                        }
                    }
                    ret.addAll(LayersConfigBuilder.getLayerNames(completerInvocation.getPmSession(), model, loc, excluded));
                    return ret;
                }
            }
            catch (Exception ex) {
                CliLogging.error(ex.toString());
            }
            return null;
        }
    }
}

