/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Iterator;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeatureGroupBuilderSupport;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.util.StringUtils;

public class FeatureGroup
extends FeatureGroupSupport {
    public static Builder builder() {
        return new Builder(null, true);
    }

    public static Builder builder(boolean inheritFeatures) {
        return new Builder(null, inheritFeatures);
    }

    public static Builder builder(String featureGroupName) {
        return FeatureGroup.builder(featureGroupName, true);
    }

    public static Builder builder(String featureGroupName, boolean inheritFeatures) {
        return new Builder(featureGroupName, inheritFeatures);
    }

    public static FeatureGroup forGroup(String featureGroupName) {
        return new FeatureGroup(null, featureGroupName);
    }

    public static FeatureGroup forGroup(String origin, String featureGroupName) {
        return new FeatureGroup(origin, featureGroupName);
    }

    public FeatureGroup(String origin, String name) {
        super(origin, name);
    }

    protected FeatureGroup(FeatureGroupBuilderSupport<?> builder) throws ProvisioningDescriptionException {
        super(builder);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (this.name != null) {
            buf.append(this.name);
        }
        if (this.origin != null) {
            buf.append(" origin=").append(this.origin);
        }
        if (!this.inheritFeatures) {
            buf.append(" inherit-features=false");
        }
        if (!this.includedSpecs.isEmpty()) {
            buf.append(" includedSpecs=");
            StringUtils.append(buf, this.includedSpecs);
        }
        if (!this.excludedSpecs.isEmpty()) {
            buf.append(" exlcudedSpecs=");
            StringUtils.append(buf, this.excludedSpecs);
        }
        if (!this.includedFeatures.isEmpty()) {
            buf.append(" includedFeatures=[");
            Iterator i = this.includedFeatures.entrySet().iterator();
            Map.Entry entry = i.next();
            buf.append(entry.getKey());
            if (entry.getValue() != null) {
                buf.append("->").append(entry.getValue());
            }
            while (i.hasNext()) {
                entry = i.next();
                buf.append(';').append(entry.getKey());
                if (entry.getValue() == null) continue;
                buf.append("->").append(entry.getValue());
            }
            buf.append(']');
        }
        if (!this.excludedFeatures.isEmpty()) {
            buf.append(" exlcudedFeatures=");
            StringUtils.append(buf, this.excludedFeatures.keySet());
        }
        if (!this.items.isEmpty()) {
            buf.append(" items=");
            StringUtils.append(buf, this.items);
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeatureGroupBuilderSupport<Builder> {
        protected Builder() {
        }

        protected Builder(String featureGroupName) {
            super(featureGroupName);
        }

        protected Builder(String featureGroupName, boolean inheritFeatures) {
            super(featureGroupName);
            this.inheritFeatures = inheritFeatures;
        }

        public FeatureGroup build() throws ProvisioningDescriptionException {
            return new FeatureGroup(this);
        }
    }
}

