/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.FeaturePackLayoutTransformer;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.FeaturePackUpdatePlan;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.layout.ProvisioningPlan;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.ProvisioningPlugin;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;

public class ProvisioningLayout<F extends FeaturePackLayout>
implements AutoCloseable {
    public static final String PATCHED = "patched";
    public static final String STAGED = "staged";
    public static final String TMP = "tmp";
    private final ProvisioningLayoutFactory layoutFactory;
    private final FeaturePackLayoutFactory<F> fpFactory;
    private final Handle handle;
    private ProvisioningConfig config;
    private Map<String, String> options = Collections.emptyMap();
    private Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation> resolvedVersions;
    private Set<FeaturePackLocation.ProducerSpec> transitiveDeps;
    private Map<FeaturePackLocation.ProducerSpec, Set<FeaturePackLocation.FPID>> conflicts = Collections.emptyMap();
    private Map<FeaturePackLocation.ProducerSpec, F> featurePacks = new HashMap<FeaturePackLocation.ProducerSpec, F>();
    private List<F> ordered = new ArrayList<F>();
    private Map<FeaturePackLocation.FPID, F> allPatches = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, List<F>> fpPatches = Collections.emptyMap();
    private ProgressTracker<FeaturePackLocation.ProducerSpec> updatesTracker;
    private ProgressTracker<FeaturePackLocation.FPID> buildTracker;

    ProvisioningLayout(ProvisioningLayoutFactory layoutFactory, ProvisioningConfig config, FeaturePackLayoutFactory<F> fpFactory, boolean initPluginOptions) throws ProvisioningException {
        this.layoutFactory = layoutFactory;
        this.fpFactory = fpFactory;
        this.config = config;
        this.handle = layoutFactory.createHandle();
        if (config.hasFeaturePackDeps()) {
            try {
                this.build(false, true);
                if (initPluginOptions) {
                    this.initPluginOptions(Collections.emptyMap(), false);
                }
            }
            catch (Throwable t) {
                this.handle.close();
                throw t;
            }
        }
    }

    ProvisioningLayout(ProvisioningLayoutFactory layoutFactory, ProvisioningConfig config, FeaturePackLayoutFactory<F> fpFactory, Map<String, String> extraOptions) throws ProvisioningException {
        this.layoutFactory = layoutFactory;
        this.fpFactory = fpFactory;
        this.config = config;
        this.handle = layoutFactory.createHandle();
        if (config.hasFeaturePackDeps()) {
            try {
                this.build(false, true);
                this.initPluginOptions(extraOptions, false);
            }
            catch (Throwable t) {
                this.handle.close();
                throw t;
            }
        }
    }

    <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, final FeaturePackLayoutFactory<F> fpFactory) throws ProvisioningException {
        this(other, fpFactory, new FeaturePackLayoutTransformer<F, O>(){

            @Override
            public F transform(O other) throws ProvisioningException {
                return fpFactory.newFeaturePack(((FeaturePackLayout)other).getFPID().getLocation(), ((FeaturePackLayout)other).getSpec(), ((FeaturePackLayout)other).getDir(), ((FeaturePackLayout)other).getType());
            }
        });
    }

    <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, final FeaturePackLayoutTransformer<F, O> transformer) throws ProvisioningException {
        this(other, new FeaturePackLayoutFactory<F>(){
            final FeaturePackLayoutFactory<O> fpFactory;
            {
                this.fpFactory = ProvisioningLayout.this.fpFactory;
            }

            @Override
            public F newFeaturePack(FeaturePackLocation fpl, FeaturePackSpec spec, Path dir, int type) throws ProvisioningException {
                return transformer.transform(this.fpFactory.newFeaturePack(fpl, spec, dir, type));
            }
        }, transformer);
    }

    private <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, FeaturePackLayoutFactory<F> fpFactory, FeaturePackLayoutTransformer<F, O> transformer) throws ProvisioningException {
        this.layoutFactory = other.layoutFactory;
        this.fpFactory = fpFactory;
        this.config = other.config;
        this.options = CollectionUtils.clone(other.options);
        for (FeaturePackLayout featurePackLayout : other.ordered) {
            F fp = transformer.transform(featurePackLayout);
            this.featurePacks.put(((FeaturePackLayout)fp).getFPID().getProducer(), fp);
            this.ordered.add(fp);
        }
        if (!other.fpPatches.isEmpty()) {
            this.fpPatches = new HashMap<FeaturePackLocation.FPID, List<F>>(other.fpPatches.size());
            for (Map.Entry entry : other.fpPatches.entrySet()) {
                List patches = (List)entry.getValue();
                ArrayList<F> convertedPatches = new ArrayList<F>(patches.size());
                for (FeaturePackLayout o : patches) {
                    convertedPatches.add(transformer.transform(o));
                }
                this.fpPatches.put((FeaturePackLocation.FPID)entry.getKey(), (List<F>)convertedPatches);
            }
        }
        this.handle = other.handle;
        this.handle.incrementRefs();
    }

    public ProvisioningLayoutFactory getFactory() {
        return this.layoutFactory;
    }

    public FeaturePackLayoutFactory<F> getFeaturePackFactory() {
        return this.fpFactory;
    }

    public <O extends FeaturePackLayout> ProvisioningLayout<O> transform(FeaturePackLayoutFactory<O> fpFactory) throws ProvisioningException {
        return new ProvisioningLayout<O>(this, fpFactory);
    }

    public <O extends FeaturePackLayout> ProvisioningLayout<O> transform(FeaturePackLayoutTransformer<O, F> transformer) throws ProvisioningException {
        return new ProvisioningLayout<O>(this, transformer);
    }

    public void apply(ProvisioningPlan plan) throws ProvisioningException {
        this.apply(plan, Collections.emptyMap());
    }

    public void apply(ProvisioningPlan plan, Map<String, String> pluginOptions) throws ProvisioningException {
        if (plan.isEmpty()) {
            return;
        }
        ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder(this.config);
        if (plan.hasUpdates()) {
            FeaturePackConfig.Builder fpBuilder;
            FeaturePackUpdatePlan fpPlan;
            FeaturePackLocation.ProducerSpec producer;
            Map<FeaturePackLocation.ProducerSpec, FeaturePackUpdatePlan> updates = plan.getUpdateMap();
            HashSet<FeaturePackLocation.ProducerSpec> processed = new HashSet<FeaturePackLocation.ProducerSpec>(updates.size());
            for (FeaturePackConfig featurePackConfig : this.config.getFeaturePackDeps()) {
                producer = featurePackConfig.getLocation().getProducer();
                fpPlan = updates.get(producer);
                if (fpPlan == null || fpPlan.isEmpty()) continue;
                if (!fpPlan.getInstalledLocation().equals(featurePackConfig.getLocation())) {
                    throw new ProvisioningException("Location in the update plan " + fpPlan.getInstalledLocation() + " does not match the installed location " + featurePackConfig.getLocation());
                }
                fpBuilder = FeaturePackConfig.builder(fpPlan.getNewLocation()).init(featurePackConfig);
                if (fpPlan.hasNewPatches()) {
                    for (FeaturePackLocation.FPID patchId : fpPlan.getNewPatches()) {
                        fpBuilder.addPatch(patchId);
                    }
                }
                configBuilder.updateFeaturePackDep(fpBuilder.build());
                processed.add(producer);
            }
            for (FeaturePackConfig featurePackConfig : this.config.getTransitiveDeps()) {
                producer = featurePackConfig.getLocation().getProducer();
                fpPlan = updates.get(producer);
                if (fpPlan == null || fpPlan.isEmpty()) continue;
                if (featurePackConfig.getLocation().getBuild() != null && !fpPlan.getInstalledLocation().equals(featurePackConfig.getLocation())) {
                    throw new ProvisioningException("Update plan build " + fpPlan.getInstalledLocation() + " does not match the installed build " + featurePackConfig.getLocation());
                }
                fpBuilder = FeaturePackConfig.transitiveBuilder(fpPlan.getNewLocation()).init(featurePackConfig);
                if (fpPlan.hasNewPatches()) {
                    for (FeaturePackLocation.FPID patchId : fpPlan.getNewPatches()) {
                        fpBuilder.addPatch(patchId);
                    }
                }
                configBuilder.updateFeaturePackDep(fpBuilder.build());
                processed.add(producer);
            }
            if (processed.size() < updates.size()) {
                for (Map.Entry entry : updates.entrySet()) {
                    if (processed.contains(entry.getKey())) continue;
                    FeaturePackUpdatePlan update = (FeaturePackUpdatePlan)entry.getValue();
                    FeaturePackConfig.Builder fpBuilder2 = FeaturePackConfig.transitiveBuilder(update.getNewLocation());
                    if (update.hasNewPatches()) {
                        for (FeaturePackLocation.FPID patchId : update.getNewPatches()) {
                            fpBuilder2.addPatch(patchId);
                        }
                    }
                    configBuilder.addFeaturePackDep(fpBuilder2.build());
                }
            }
        }
        if (plan.hasInstall()) {
            for (FeaturePackConfig fpConfig : plan.getInstall()) {
                this.install(fpConfig, configBuilder);
            }
        }
        if (plan.hasUninstall()) {
            for (FeaturePackLocation.ProducerSpec producer : plan.getUninstall()) {
                this.uninstall(producer.getLocation().getFPID(), configBuilder);
            }
        }
        this.rebuild(configBuilder.build(), true);
        this.initPluginOptions(pluginOptions, plan.hasUninstall());
    }

    public void install(FeaturePackLocation fpl) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl));
    }

    public void install(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.install(fpConfig, Collections.emptyMap());
    }

    public void install(FeaturePackConfig fpConfig, Map<String, String> pluginOptions) throws ProvisioningException {
        this.rebuild(this.install(fpConfig, ProvisioningConfig.builder(this.config)).build(), false);
        this.initPluginOptions(pluginOptions, false);
    }

    private ProvisioningConfig.Builder install(FeaturePackConfig fpConfig, ProvisioningConfig.Builder configBuilder) throws ProvisioningException {
        FeaturePackSpec fpSpec;
        FeaturePackLocation fpl = fpConfig.getLocation();
        FeaturePackLocation.FPID fpid = fpl.getFPID();
        if (this.allPatches.containsKey(fpid)) {
            throw new ProvisioningException(Errors.patchAlreadyApplied(fpid));
        }
        if (!fpl.hasBuild()) {
            fpl = this.layoutFactory.getUniverseResolver().resolveLatestBuild(fpl);
        }
        if ((fpSpec = ((FeaturePackLayout)this.layoutFactory.resolveFeaturePack(fpl, 0, this.fpFactory)).getSpec()).isPatch()) {
            FeaturePackLayout patchTarget = (FeaturePackLayout)this.featurePacks.get(fpSpec.getPatchFor().getProducer());
            if (patchTarget == null || !patchTarget.getFPID().equals(fpSpec.getPatchFor())) {
                throw new ProvisioningException(Errors.patchNotApplicable(fpid, fpSpec.getPatchFor()));
            }
            FeaturePackConfig installedFpConfig = this.config.getFeaturePackDep(fpSpec.getPatchFor().getProducer());
            if (installedFpConfig == null) {
                installedFpConfig = this.config.getTransitiveDep(fpSpec.getPatchFor().getProducer());
            }
            if (installedFpConfig == null) {
                return (ProvisioningConfig.Builder)configBuilder.addFeaturePackDep(FeaturePackConfig.transitiveBuilder(patchTarget.getFPID().getLocation()).addPatch(fpid).build());
            }
            return (ProvisioningConfig.Builder)configBuilder.updateFeaturePackDep(FeaturePackConfig.builder(installedFpConfig.getLocation()).init(installedFpConfig).addPatch(fpid).build());
        }
        FeaturePackLayout installedFp = (FeaturePackLayout)this.featurePacks.get(fpid.getProducer());
        if (installedFp != null) {
            if (installedFp.isTransitiveDep() == fpConfig.isTransitive()) {
                return (ProvisioningConfig.Builder)configBuilder.updateFeaturePackDep(fpConfig);
            }
            if (installedFp.isTransitiveDep()) {
                if (this.config.hasTransitiveDep(fpid.getProducer())) {
                    configBuilder.removeTransitiveDep(fpid);
                }
                return (ProvisioningConfig.Builder)configBuilder.addFeaturePackDep(this.getIndexForDepToInstall(configBuilder, fpid.getProducer()), fpConfig);
            }
            configBuilder.removeFeaturePackDep(fpid.getLocation());
        }
        return (ProvisioningConfig.Builder)configBuilder.addFeaturePackDep(fpConfig);
    }

    private int getIndexForDepToInstall(ProvisioningConfig.Builder configBuilder, FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        int index = Integer.MAX_VALUE;
        HashSet<FeaturePackLocation.ProducerSpec> visitedFps = new HashSet<FeaturePackLocation.ProducerSpec>(this.featurePacks.size());
        visitedFps.add(producer);
        for (FeaturePackLayout f : this.featurePacks.values()) {
            if (f.isTransitiveDep() || !this.dependsOn(f, producer, visitedFps)) continue;
            index = Math.min(index, configBuilder.getFeaturePackDepIndex(f.getFPID().getLocation()));
        }
        return index;
    }

    private boolean dependsOn(F f, FeaturePackLocation.ProducerSpec dep, Set<FeaturePackLocation.ProducerSpec> visitedFps) throws ProvisioningException {
        FeaturePackSpec spec = ((FeaturePackLayout)f).getSpec();
        if (!spec.hasFeaturePackDeps()) {
            return false;
        }
        if (spec.hasFeaturePackDep(dep) || spec.hasTransitiveDep(dep)) {
            return true;
        }
        for (FeaturePackConfig fpConfig : spec.getFeaturePackDeps()) {
            FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
            if (!visitedFps.add(producer)) continue;
            if (this.dependsOn((FeaturePackLayout)this.featurePacks.get(producer), dep, visitedFps)) {
                return true;
            }
            visitedFps.remove(producer);
        }
        return false;
    }

    public void uninstall(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        this.uninstall(fpid, Collections.emptyMap());
    }

    public void uninstall(FeaturePackLocation.FPID fpid, Map<String, String> pluginOptions) throws ProvisioningException {
        this.rebuild(this.uninstall(fpid, ProvisioningConfig.builder(this.config)).build(), true);
        this.initPluginOptions(pluginOptions, true);
    }

    private ProvisioningConfig.Builder uninstall(FeaturePackLocation.FPID fpid, ProvisioningConfig.Builder configBuilder) throws ProvisioningException {
        if (this.allPatches.containsKey(fpid)) {
            FeaturePackLayout patchFp = (FeaturePackLayout)this.allPatches.get(fpid);
            FeaturePackLocation.ProducerSpec patchTarget = patchFp.getSpec().getPatchFor().getProducer();
            FeaturePackConfig targetConfig = this.config.getFeaturePackDep(patchTarget);
            if (targetConfig == null && (targetConfig = this.config.getTransitiveDep(patchTarget)) == null) {
                throw new ProvisioningException("Target feature-pack for patch " + fpid + " could not be found");
            }
            return (ProvisioningConfig.Builder)configBuilder.updateFeaturePackDep(FeaturePackConfig.builder(targetConfig).removePatch(fpid).build());
        }
        FeaturePackLayout installedFp = (FeaturePackLayout)this.featurePacks.get(fpid.getProducer());
        if (installedFp == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        if (fpid.getBuild() != null && !installedFp.getFPID().getBuild().equals(fpid.getBuild())) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        FeaturePackConfig fpConfig = this.config.getFeaturePackDep(fpid.getProducer());
        if (fpConfig == null) {
            throw new ProvisioningException(Errors.unsatisfiedFeaturePackDep(fpid.getProducer()));
        }
        configBuilder.removeFeaturePackDep(fpid.getLocation());
        if (!configBuilder.hasFeaturePackDeps()) {
            configBuilder.clearFeaturePackDeps();
        }
        return configBuilder;
    }

    public ProvisioningPlan getUpdates(boolean includeTransitive) throws ProvisioningException {
        return this.getUpdatesInternal(includeTransitive ? this.featurePacks.keySet() : this.config.getProducers());
    }

    public ProvisioningPlan getUpdates(FeaturePackLocation.ProducerSpec ... producers) throws ProvisioningException {
        if (producers.length == 0) {
            return this.getUpdates(false);
        }
        return this.getUpdatesInternal(Arrays.asList(producers));
    }

    private ProvisioningPlan getUpdatesInternal(Collection<FeaturePackLocation.ProducerSpec> producers) throws ProvisioningException {
        ProvisioningPlan plan = ProvisioningPlan.builder();
        this.updatesTracker = this.getUpdatesTracker();
        this.updatesTracker.starting(producers.size());
        for (FeaturePackLocation.ProducerSpec producer : producers) {
            this.updatesTracker.processing(producer);
            FeaturePackUpdatePlan fpPlan = this.getFeaturePackUpdate(producer);
            if (!fpPlan.isEmpty()) {
                plan.update(fpPlan);
            }
            this.updatesTracker.processed(producer);
        }
        this.updatesTracker.complete();
        return plan;
    }

    public FeaturePackUpdatePlan getFeaturePackUpdate(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        Set<FeaturePackLocation.FPID> patchIds;
        FeaturePackLayout f = (FeaturePackLayout)this.featurePacks.get(producer);
        if (f == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(producer.getLocation().getFPID()));
        }
        FeaturePackLocation fpl = f.getFPID().getLocation();
        Universe<?> universe = this.layoutFactory.getUniverseResolver().getUniverse(fpl.getUniverse());
        Object channel = universe.getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName());
        List<F> patches = this.fpPatches.get(fpl.getFPID());
        if (patches == null || patches.isEmpty()) {
            patchIds = Collections.emptySet();
        } else if (patches.size() == 1) {
            patchIds = Collections.singleton(((FeaturePackLayout)patches.get(0)).getFPID());
        } else {
            HashSet<FeaturePackLocation.FPID> tmp = new HashSet<FeaturePackLocation.FPID>(patches.size());
            for (FeaturePackLayout p : patches) {
                tmp.add(p.getFPID());
            }
            patchIds = CollectionUtils.unmodifiable(tmp);
        }
        return channel.getUpdatePlan(FeaturePackUpdatePlan.request(fpl, patchIds, f.isTransitiveDep()));
    }

    public ProvisioningConfig getConfig() {
        return this.config;
    }

    public boolean hasFeaturePacks() {
        return !this.featurePacks.isEmpty();
    }

    public boolean hasFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.featurePacks.containsKey(producer);
    }

    public F getFeaturePack(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        FeaturePackLayout p = (FeaturePackLayout)this.featurePacks.get(producer);
        if (p == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(producer.getLocation().getFPID()));
        }
        return (F)p;
    }

    public List<F> getOrderedFeaturePacks() {
        return this.ordered;
    }

    public List<F> getPatches(FeaturePackLocation.FPID fpid) {
        List<F> patches = this.fpPatches.get(fpid);
        return patches == null ? Collections.emptyList() : patches;
    }

    public boolean hasPlugins() {
        return this.handle.pluginsDir != null;
    }

    public Path getPluginsDir() {
        return this.handle.pluginsDir;
    }

    public boolean hasResources() {
        return this.handle.resourcesDir != null;
    }

    public Path getResources() {
        return this.handle.resourcesDir;
    }

    public Path getResource(String ... path) throws ProvisioningException {
        return this.handle.getResource(path);
    }

    public Path getTmpPath(String ... path) {
        return this.handle.getTmpPath(path);
    }

    public ClassLoader getPluginsClassLoader() throws ProvisioningException {
        return this.handle.getPluginsClassLoader();
    }

    public <T extends ProvisioningPlugin> void visitPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
        this.handle.visitPlugins(visitor, clazz);
    }

    public Path newStagedDir() throws ProvisioningException {
        return this.handle.newStagedDir();
    }

    public boolean hasPatches() {
        return !this.allPatches.isEmpty();
    }

    private void rebuild(ProvisioningConfig config, boolean cleanupTransitive) throws ProvisioningException {
        boolean trackProgress = this.featurePacks.isEmpty();
        this.featurePacks.clear();
        this.ordered.clear();
        this.allPatches = Collections.emptyMap();
        this.fpPatches = Collections.emptyMap();
        this.config = config;
        this.handle.reset();
        this.build(cleanupTransitive, trackProgress);
    }

    private void build(boolean cleanupTransitive, boolean trackProgress) throws ProvisioningException {
        try {
            this.doBuild(cleanupTransitive, trackProgress);
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            this.handle.close();
            throw e;
        }
    }

    private void doBuild(boolean cleanupTransitive, boolean trackProgress) throws ProvisioningException {
        this.buildTracker = this.getBuildTracker(trackProgress);
        this.buildTracker.starting(-1L);
        HashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> depBranch = new HashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID>();
        this.layout(this.config, depBranch, 0);
        if (!this.conflicts.isEmpty()) {
            throw new ProvisioningDescriptionException(Errors.fpVersionCheckFailed(this.conflicts.values()));
        }
        if (this.transitiveDeps != null) {
            ProvisioningConfig.Builder newConfig = null;
            Object notUsedTransitive = Collections.emptyList();
            for (FeaturePackLocation.ProducerSpec producer : this.transitiveDeps) {
                if (this.featurePacks.containsKey(producer)) continue;
                if (cleanupTransitive && this.config.hasTransitiveDep(producer)) {
                    if (newConfig == null) {
                        newConfig = ProvisioningConfig.builder(this.config);
                    }
                    newConfig.removeTransitiveDep(producer.getLocation().getFPID());
                    continue;
                }
                notUsedTransitive = CollectionUtils.add(notUsedTransitive, producer);
            }
            if (!notUsedTransitive.isEmpty()) {
                throw new ProvisioningDescriptionException(Errors.transitiveDependencyNotFound(notUsedTransitive.toArray(new FeaturePackLocation.ProducerSpec[notUsedTransitive.size()])));
            }
            if (newConfig != null) {
                this.config = newConfig.build();
            }
            this.transitiveDeps = null;
        }
        if (this.resolvedVersions != null) {
            ProvisioningConfig.Builder builder = ProvisioningConfig.builder(this.config);
            for (FeaturePackConfig fpConfig : this.config.getFeaturePackDeps()) {
                FeaturePackLocation.ProducerSpec producer;
                producer = fpConfig.getLocation().getProducer();
                FeaturePackLocation resolvedFpl = this.resolvedVersions.remove(producer);
                if (resolvedFpl == null) continue;
                builder.updateFeaturePackDep(this.config.originOf(producer), FeaturePackConfig.builder(resolvedFpl).init(fpConfig).build());
            }
            if (!this.resolvedVersions.isEmpty()) {
                for (FeaturePackLocation fpl : this.resolvedVersions.values()) {
                    builder.addTransitiveDep(fpl);
                }
            }
            this.config = builder.build();
            this.resolvedVersions = null;
        }
        if (!this.fpPatches.isEmpty()) {
            for (FeaturePackLayout f : this.ordered) {
                List<F> patches = this.fpPatches.get(f.getFPID());
                if (patches == null) {
                    Path fpPlugins;
                    Path fpResources = f.getDir().resolve("resources");
                    if (Files.exists(fpResources, new LinkOption[0])) {
                        this.patchDir(this.getResources(), fpResources);
                    }
                    if (!Files.exists(fpPlugins = f.getDir().resolve("plugins"), new LinkOption[0])) continue;
                    this.patchDir(this.getPluginsDir(), fpPlugins);
                    continue;
                }
                Path fpDir = LayoutUtils.getFeaturePackDir(this.handle.getPatchedDir(), f.getFPID(), false);
                try {
                    Files.createDirectories(fpDir, new FileAttribute[0]);
                    IoUtils.copy(f.getDir(), fpDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException("Failed to patch feature-pack dir for " + f.getFPID(), e);
                }
                f.dir = fpDir;
                for (FeaturePackLayout patch : patches) {
                    Path patchDir = patch.getDir();
                    Path patchContent = patchDir.resolve("packages");
                    if (Files.exists(patchContent, new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("packages"), patchContent);
                    }
                    if (Files.exists(patchContent = patchDir.resolve("features"), new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("features"), patchContent);
                    }
                    if (Files.exists(patchContent = patchDir.resolve("feature_groups"), new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("feature_groups"), patchContent);
                    }
                    if (Files.exists(patchContent = patchDir.resolve("plugins"), new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("plugins"), patchContent);
                        this.patchDir(this.getPluginsDir(), patchContent);
                    }
                    if (!Files.exists(patchContent = patchDir.resolve("resources"), new LinkOption[0])) continue;
                    this.patchDir(fpDir.resolve("resources"), patchContent);
                    this.patchDir(this.getResources(), patchContent);
                }
            }
        }
        this.buildTracker.complete();
    }

    private void patchDir(Path fpDir, Path patchDir) throws ProvisioningException {
        try {
            IoUtils.copy(patchDir, fpDir);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(patchDir, fpDir), e);
        }
    }

    private void layout(FeaturePackDepsConfig config, Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> branch, int type) throws ProvisioningException {
        if (!config.hasFeaturePackDeps()) {
            return;
        }
        List<Object> added = Collections.emptyList();
        if (config.hasTransitiveDeps()) {
            if (this.transitiveDeps == null) {
                this.transitiveDeps = new HashSet<FeaturePackLocation.ProducerSpec>();
            }
            for (FeaturePackConfig transitiveConfig : config.getTransitiveDeps()) {
                FeaturePackLocation fpl = transitiveConfig.getLocation();
                this.transitiveDeps.add(fpl.getProducer());
                if (transitiveConfig.hasPatches()) {
                    this.addPatches(transitiveConfig);
                }
                if (branch.containsKey(fpl.getProducer()) || fpl.getBuild() == null) continue;
                branch.put(fpl.getProducer(), fpl.getFPID());
                added = CollectionUtils.add(added, fpl.getProducer());
            }
        }
        Collection<FeaturePackConfig> fpDeps = config.getFeaturePackDeps();
        ArrayList<FeaturePackLayout> queue = new ArrayList<FeaturePackLayout>(fpDeps.size());
        for (FeaturePackConfig fpConfig : fpDeps) {
            FeaturePackLayout fp;
            FeaturePackLocation.FPID branchId;
            FeaturePackLocation fpl = fpConfig.getLocation();
            if (fpConfig.hasPatches()) {
                this.addPatches(fpConfig);
            }
            if ((branchId = branch.get(fpl.getProducer())) == null) {
                if (fpl.getBuild() == null) {
                    fpl = this.layoutFactory.getUniverseResolver().resolveLatestBuild(fpl);
                    if (this.resolvedVersions == null) {
                        this.resolvedVersions = new LinkedHashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation>();
                    }
                    this.resolvedVersions.put(fpl.getProducer(), fpl);
                }
            } else if (!branchId.getBuild().equals(fpl.getBuild())) {
                fpl = fpl.replaceBuild(branchId.getBuild());
            }
            if ((fp = (FeaturePackLayout)this.featurePacks.get(fpl.getProducer())) != null) {
                if (branchId != null || fpl.getBuild().equals(fp.getFPID().getBuild())) continue;
                Set<FeaturePackLocation.FPID> versions = this.conflicts.get(fp.getFPID().getProducer());
                if (versions != null) {
                    versions.add(fpl.getFPID());
                    continue;
                }
                versions = new LinkedHashSet<FeaturePackLocation.FPID>();
                versions.add(fp.getFPID());
                versions.add(fpl.getFPID());
                this.conflicts = CollectionUtils.putLinked(this.conflicts, fpl.getProducer(), versions);
                continue;
            }
            this.buildTracker.processing(fpl.getFPID());
            fp = this.layoutFactory.resolveFeaturePack(fpl, type, this.fpFactory);
            this.buildTracker.processed(fpl.getFPID());
            this.featurePacks.put(fpl.getProducer(), fp);
            queue.add(fp);
            if (branchId != null) continue;
            branch.put(fpl.getProducer(), fpl.getFPID());
            added = CollectionUtils.add(added, fpl.getProducer());
        }
        if (!queue.isEmpty()) {
            for (FeaturePackLayout p : queue) {
                this.layout(p.getSpec(), branch, 1);
                this.handle.copyResources(p.getDir());
                this.ordered.add(p);
            }
        }
        if (!added.isEmpty()) {
            for (FeaturePackLocation.ProducerSpec producer : added) {
                branch.remove(producer);
            }
        }
    }

    private void addPatches(FeaturePackConfig fpConfig) throws ProvisioningException {
        for (FeaturePackLocation.FPID patchId : fpConfig.getPatches()) {
            if (this.allPatches.containsKey(patchId)) continue;
            this.loadPatch(patchId);
        }
    }

    private void loadPatch(FeaturePackLocation.FPID patchId) throws ProvisioningException {
        FeaturePackLocation.FPID patchFor;
        List<F> patchList;
        F patchFp = this.layoutFactory.resolveFeaturePack(patchId.getLocation(), 2, this.fpFactory);
        FeaturePackSpec spec = ((FeaturePackLayout)patchFp).getSpec();
        if (!spec.isPatch()) {
            throw new ProvisioningDescriptionException(patchId + " is not a patch but listed as one");
        }
        this.allPatches = CollectionUtils.put(this.allPatches, patchId, patchFp);
        if (spec.hasFeaturePackDeps()) {
            for (FeaturePackConfig patchDep : spec.getFeaturePackDeps()) {
                FeaturePackLocation.FPID patchDepId = patchDep.getLocation().getFPID();
                if (this.allPatches.containsKey(patchDepId)) continue;
                this.loadPatch(patchDepId);
            }
        }
        if ((patchList = this.fpPatches.get(patchFor = spec.getPatchFor())) == null) {
            this.fpPatches = CollectionUtils.put(this.fpPatches, patchFor, Collections.singletonList(patchFp));
        } else if (patchList.size() == 1) {
            ArrayList<F> tmp = new ArrayList<F>(2);
            tmp.add(patchList.get(0));
            tmp.add(patchFp);
            this.fpPatches = CollectionUtils.put(this.fpPatches, patchFor, tmp);
        } else {
            patchList.add(patchFp);
        }
    }

    private ProgressTracker<FeaturePackLocation.ProducerSpec> getUpdatesTracker() {
        return this.updatesTracker == null ? (this.updatesTracker = this.layoutFactory.getProgressTracker("UPDATES")) : this.updatesTracker;
    }

    private ProgressTracker<FeaturePackLocation.FPID> getBuildTracker(boolean trackProgress) {
        if (!trackProgress) {
            return ProvisioningLayoutFactory.getNoOpProgressTracker();
        }
        return this.buildTracker == null ? (this.buildTracker = this.layoutFactory.getProgressTracker("LAYOUT_BUILD")) : this.buildTracker;
    }

    public boolean isOptionSet(String name) {
        return this.options.containsKey(name);
    }

    public String getOptionValue(String name) {
        return this.options.get(name);
    }

    public String getOptionValue(String name, String defValue) {
        String setValue = this.options.get(name);
        return setValue == null ? defValue : setValue;
    }

    public String getOptionValue(ProvisioningOption option) throws ProvisioningException {
        String setValue = this.options.get(option.getName());
        if (setValue == null) {
            if (option.isRequired() && !this.options.containsKey(option.getName()) && option.getDefaultValue() == null) {
                throw new ProvisioningException(Errors.pluginOptionRequired(option.getName()));
            }
            return option.getDefaultValue();
        }
        if (!option.getValueSet().isEmpty() && !option.getValueSet().contains(setValue)) {
            throw new ProvisioningException(Errors.pluginOptionIllegalValue(option.getName(), setValue, option.getValueSet()));
        }
        return setValue;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    private void initPluginOptions(final Map<String, String> extraOptions, boolean cleanupConfigOptions) throws ProvisioningException {
        String optionName;
        List<ProvisioningOption> overridenOptions;
        Map<String, ProvisioningOption> recognizedOptions;
        this.options = this.config.getPluginOptions();
        if (!extraOptions.isEmpty()) {
            this.options = CollectionUtils.putAll(CollectionUtils.clone(this.options), extraOptions);
        }
        if (this.options.isEmpty()) {
            recognizedOptions = Collections.emptyMap();
            overridenOptions = Collections.emptyList();
        } else {
            int size = this.options.size();
            recognizedOptions = new HashMap(size);
            overridenOptions = new ArrayList<ProvisioningOption>(size);
        }
        this.processOptions(ProvisioningOption.getStandardList(), extraOptions, recognizedOptions, overridenOptions);
        this.handle.visitPlugins(new FeaturePackPluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                ProvisioningLayout.this.processOptions(plugin.getOptions().values(), extraOptions, recognizedOptions, overridenOptions);
            }
        }, InstallPlugin.class);
        ProvisioningConfig.Builder configBuilder = null;
        if (recognizedOptions.size() != this.options.size()) {
            HashSet<String> nonRecognized = new HashSet<String>(this.options.keySet());
            nonRecognized.removeAll(recognizedOptions.keySet());
            if (cleanupConfigOptions) {
                Iterator i = nonRecognized.iterator();
                while (i.hasNext()) {
                    optionName = (String)i.next();
                    if (!this.config.hasPluginOption(optionName)) continue;
                    if (configBuilder == null) {
                        configBuilder = ProvisioningConfig.builder(this.config);
                    }
                    configBuilder.removeOption(optionName);
                    i.remove();
                }
            }
            if (!nonRecognized.isEmpty()) {
                throw new ProvisioningException(Errors.pluginOptionsNotRecognized(nonRecognized));
            }
        }
        if (!overridenOptions.isEmpty()) {
            if (configBuilder == null) {
                configBuilder = ProvisioningConfig.builder(this.config);
            }
            for (ProvisioningOption option : overridenOptions) {
                optionName = option.getName();
                if (!extraOptions.containsKey(optionName)) continue;
                String value = extraOptions.get(optionName);
                if (option.isPersistent()) {
                    configBuilder.addOption(optionName, value);
                    continue;
                }
                if (value == null) {
                    if (this.config.getPluginOption(optionName) == null) continue;
                    configBuilder.removeOption(optionName);
                    continue;
                }
                if (value.equals(this.config.getPluginOption(optionName))) continue;
                configBuilder.removeOption(optionName);
            }
            this.config = configBuilder.build();
        } else if (configBuilder != null) {
            this.config = configBuilder.build();
        }
        this.options = CollectionUtils.unmodifiable(this.options);
    }

    private void processOptions(Iterable<? extends ProvisioningOption> pluginOptions, Map<String, String> extraOptions, Map<String, ProvisioningOption> recognizedOptions, List<ProvisioningOption> overridenOptions) throws ProvisioningException {
        for (ProvisioningOption provisioningOption : pluginOptions) {
            String optionName = provisioningOption.getName();
            if (!this.options.containsKey(optionName)) {
                if (!provisioningOption.isRequired()) continue;
                throw new ProvisioningException(Errors.pluginOptionRequired(optionName));
            }
            ProvisioningOption existing = recognizedOptions.put(optionName, provisioningOption);
            if (existing != null && existing.isPersistent() && !provisioningOption.isPersistent()) {
                recognizedOptions.put(existing.getName(), existing);
                continue;
            }
            if (!provisioningOption.isPersistent() && (!extraOptions.containsKey(optionName) || !this.config.hasPluginOption(optionName))) continue;
            overridenOptions.add(provisioningOption);
        }
    }

    @Override
    public void close() {
        this.handle.close();
    }

    public static class Handle
    implements Closeable {
        private final ProvisioningLayoutFactory layoutFactory;
        private Path workDir;
        private ClassLoader pluginsCl;
        private boolean closePluginsCl;
        private Map<String, List<ProvisioningPlugin>> loadedPlugins = Collections.emptyMap();
        private Path patchedDir;
        private Path pluginsDir;
        private Path resourcesDir;
        private Path tmpDir;
        private int refs;

        Handle(ProvisioningLayoutFactory layoutFactory) {
            this.layoutFactory = layoutFactory;
            this.refs = 1;
        }

        protected void reset() {
            if (this.closePluginsCl) {
                try {
                    ((URLClassLoader)this.pluginsCl).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.closePluginsCl = false;
            }
            this.pluginsCl = null;
            this.loadedPlugins = Collections.emptyMap();
            if (this.workDir != null) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.workDir);){
                    for (Path p : stream) {
                        IoUtils.recursiveDelete(p);
                    }
                }
                catch (IOException e) {
                    IoUtils.recursiveDelete(this.workDir);
                    this.workDir = null;
                }
                this.patchedDir = null;
                this.resourcesDir = null;
                this.pluginsDir = null;
                this.tmpDir = null;
            }
        }

        protected void incrementRefs() {
            ++this.refs;
        }

        private void copyResources(Path fpDir) throws ProvisioningException {
            Path fpPlugins;
            Path fpResources = fpDir.resolve("resources");
            if (Files.exists(fpResources, new LinkOption[0])) {
                this.resourcesDir = this.getWorkDir().resolve("resources");
                try {
                    IoUtils.copy(fpResources, this.resourcesDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(fpResources, this.resourcesDir), e);
                }
            }
            if (Files.exists(fpPlugins = fpDir.resolve("plugins"), new LinkOption[0])) {
                if (this.pluginsDir == null) {
                    this.pluginsDir = this.getWorkDir().resolve("plugins");
                }
                try {
                    IoUtils.copy(fpPlugins, this.pluginsDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(fpPlugins, this.pluginsDir), e);
                }
            }
        }

        protected Path newStagedDir() throws ProvisioningException {
            Path stagedDir;
            block18: {
                stagedDir = this.getWorkDir().resolve(ProvisioningLayout.STAGED);
                if (Files.exists(stagedDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(stagedDir);){
                        for (Path p : stream) {
                            IoUtils.recursiveDelete(p);
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.readDirectory(stagedDir), e);
                    }
                }
                try {
                    Files.createDirectories(stagedDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.mkdirs(stagedDir), e);
                }
            }
            return stagedDir;
        }

        protected Path getResource(String ... path) throws ProvisioningException {
            if (this.resourcesDir == null) {
                throw new ProvisioningException("Configuration does not include resources");
            }
            if (path.length == 0) {
                throw new IllegalArgumentException("Resource path is null");
            }
            if (path.length == 1) {
                return this.resourcesDir.resolve(path[0]);
            }
            Path p = this.resourcesDir;
            for (String name : path) {
                p = p.resolve(name);
            }
            return p;
        }

        protected Path getTmpPath(String ... path) {
            if (path.length == 0) {
                return this.getTmpDir();
            }
            if (path.length == 1) {
                return this.getTmpDir().resolve(path[0]);
            }
            Path p = this.getTmpDir();
            for (String name : path) {
                p = p.resolve(name);
            }
            return p;
        }

        protected ClassLoader getPluginsClassLoader() throws ProvisioningException {
            if (this.pluginsCl != null) {
                return this.pluginsCl;
            }
            this.pluginsCl = Thread.currentThread().getContextClassLoader();
            if (this.pluginsDir != null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                try (Stream<Path> stream = Files.list(this.pluginsDir);){
                    Iterator i = stream.iterator();
                    while (i.hasNext()) {
                        urls.add(((Path)i.next()).toUri().toURL());
                    }
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.readDirectory(this.pluginsDir), e);
                }
                if (!urls.isEmpty()) {
                    this.closePluginsCl = true;
                    this.pluginsCl = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.pluginsCl);
                }
            }
            return this.pluginsCl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T extends ProvisioningPlugin> void visitPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
            List<ProvisioningPlugin> plugins = this.loadedPlugins.get(clazz.getName());
            if (plugins == null) {
                ClassLoader pluginsCl = this.getPluginsClassLoader();
                Iterator<T> pluginIterator = ServiceLoader.load(clazz, pluginsCl).iterator();
                plugins = Collections.emptyList();
                if (pluginIterator.hasNext()) {
                    Thread thread = Thread.currentThread();
                    ClassLoader ocl = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(pluginsCl);
                        ProvisioningPlugin plugin = (ProvisioningPlugin)pluginIterator.next();
                        plugins = CollectionUtils.add(plugins, plugin);
                        visitor.visitPlugin(plugin);
                        while (pluginIterator.hasNext()) {
                            plugin = (ProvisioningPlugin)pluginIterator.next();
                            plugins = CollectionUtils.add(plugins, plugin);
                            visitor.visitPlugin(plugin);
                        }
                    }
                    finally {
                        thread.setContextClassLoader(ocl);
                    }
                }
                this.loadedPlugins = CollectionUtils.put(this.loadedPlugins, clazz.getName(), plugins);
                return;
            }
            if (plugins.isEmpty()) {
                return;
            }
            Thread thread = Thread.currentThread();
            ClassLoader ocl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getPluginsClassLoader());
            try {
                for (ProvisioningPlugin plugin : plugins) {
                    if (!clazz.isAssignableFrom(plugin.getClass())) continue;
                    visitor.visitPlugin(plugin);
                }
            }
            finally {
                thread.setContextClassLoader(ocl);
            }
        }

        private Path getPatchedDir() {
            return this.patchedDir == null ? (this.patchedDir = this.getWorkDir().resolve(ProvisioningLayout.PATCHED)) : this.patchedDir;
        }

        private Path getTmpDir() {
            return this.tmpDir == null ? (this.tmpDir = this.getWorkDir().resolve(ProvisioningLayout.TMP)) : this.tmpDir;
        }

        private Path getWorkDir() {
            return this.workDir == null ? (this.workDir = this.layoutFactory.newConfigLayoutDir()) : this.workDir;
        }

        public boolean isClosed() {
            return this.refs == 0;
        }

        @Override
        public void close() {
            if (this.refs == 0 || --this.refs > 0) {
                return;
            }
            this.reset();
            if (this.workDir != null) {
                IoUtils.recursiveDelete(this.workDir);
            }
            this.layoutFactory.handleClosed();
        }
    }
}

