/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cache.FeaturePackCacheManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.progresstracking.DefaultProgressTracker;
import org.jboss.galleon.progresstracking.NoOpProgressCallback;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFeaturePackInstaller;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.xml.FeaturePackXmlParser;

public class ProvisioningLayoutFactory
implements Closeable {
    private static ProgressTracker<?> NO_OP_PROGRESS_TRACKER;
    public static final String TRACK_LAYOUT_BUILD = "LAYOUT_BUILD";
    public static final String TRACK_UPDATES = "UPDATES";
    public static final String TRACK_PACKAGES = "PACKAGES";
    public static final String TRACK_CONFIGS = "CONFIGS";
    private final UniverseResolver universeResolver;
    private AtomicInteger openHandles = new AtomicInteger();
    private Map<String, UniverseFeaturePackInstaller> universeInstallers;
    private Map<String, ProgressTracker<?>> progressTrackers = new HashMap();
    private final FeaturePackCacheManager cacheManager;

    public static ProvisioningLayoutFactory getInstance() throws ProvisioningException {
        return ProvisioningLayoutFactory.getInstance(UniverseResolver.builder().build());
    }

    public static ProvisioningLayoutFactory getInstance(UniverseResolver universeResolver) {
        return new ProvisioningLayoutFactory(universeResolver);
    }

    public static ProvisioningLayoutFactory getInstance(Path home, UniverseResolver universeResolver) {
        return ProvisioningLayoutFactory.getInstance(universeResolver, new FeaturePackCacheManager(home));
    }

    public static ProvisioningLayoutFactory getInstance(UniverseResolver universeResolver, FeaturePackCacheManager cacheManager) {
        return new ProvisioningLayoutFactory(universeResolver, cacheManager);
    }

    public static <T> ProgressTracker<T> getNoOpProgressTracker() {
        return NO_OP_PROGRESS_TRACKER == null ? (NO_OP_PROGRESS_TRACKER = new DefaultProgressTracker(new NoOpProgressCallback())) : NO_OP_PROGRESS_TRACKER;
    }

    private ProvisioningLayoutFactory(UniverseResolver universeResolver) {
        this(universeResolver, null);
    }

    private ProvisioningLayoutFactory(UniverseResolver universeResolver, FeaturePackCacheManager cacheManager) {
        this.universeResolver = universeResolver;
        this.cacheManager = cacheManager == null ? new FeaturePackCacheManager() : cacheManager;
    }

    public Path getHome() {
        return this.cacheManager.getHome();
    }

    public void setProgressCallback(String id, ProgressCallback<?> callback) {
        if (callback == null) {
            this.progressTrackers.remove(id);
        } else {
            this.progressTrackers.put(id, new DefaultProgressTracker(callback));
        }
    }

    public void setProgressTracker(String id, ProgressTracker<?> tracker) {
        if (tracker == null) {
            this.progressTrackers.remove(id);
        } else {
            this.progressTrackers.put(id, tracker);
        }
    }

    public <T> ProgressTracker<T> getProgressTracker(String id) {
        ProgressTracker<?> callback = this.progressTrackers.get(id);
        return callback == null ? ProvisioningLayoutFactory.getNoOpProgressTracker() : callback;
    }

    public boolean hasProgressCallback(String id) {
        return this.progressTrackers.containsKey(id);
    }

    public UniverseResolver getUniverseResolver() {
        return this.universeResolver;
    }

    public synchronized FeaturePackLocation addLocal(Path featurePack, boolean installInUniverse) throws ProvisioningException {
        Universe<?> universe;
        UniverseFeaturePackInstaller fpInstaller;
        FeaturePackLocation.FPID fpid = FeaturePackDescriber.readSpec(featurePack).getFPID();
        this.cacheManager.put(featurePack, fpid);
        if (!installInUniverse) {
            return fpid.getLocation();
        }
        if (this.universeInstallers == null) {
            this.universeInstallers = UniverseFeaturePackInstaller.load();
        }
        if ((fpInstaller = this.universeInstallers.get((universe = this.universeResolver.getUniverse(fpid.getUniverse())).getFactoryId())) == null) {
            throw new ProvisioningException(Errors.featurePackInstallerNotFound(universe.getFactoryId(), this.universeInstallers.keySet()));
        }
        fpInstaller.install(universe, fpid, featurePack);
        return fpid.getLocation();
    }

    public ProvisioningLayout<FeaturePackLayout> newConfigLayout(Path featurePack, boolean installInUniverse) throws ProvisioningException {
        return this.newConfigLayout(((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(this.addLocal(featurePack, installInUniverse))).build());
    }

    public ProvisioningLayout<FeaturePackLayout> newConfigLayout(ProvisioningConfig config) throws ProvisioningException {
        return this.newConfigLayout(config, new FeaturePackLayoutFactory<FeaturePackLayout>(){

            @Override
            public FeaturePackLayout newFeaturePack(FeaturePackLocation fpl, final FeaturePackSpec fpSpec, Path dir, int type) {
                return new FeaturePackLayout(fpl.getFPID(), dir, type){

                    @Override
                    public FeaturePackSpec getSpec() {
                        return fpSpec;
                    }
                };
            }
        }, false);
    }

    public <F extends FeaturePackLayout> ProvisioningLayout<F> newConfigLayout(ProvisioningConfig config, FeaturePackLayoutFactory<F> factory, boolean initOptions) throws ProvisioningException {
        return new ProvisioningLayout<F>(this, config, factory, initOptions);
    }

    public <F extends FeaturePackLayout> ProvisioningLayout<F> newConfigLayout(ProvisioningConfig config, FeaturePackLayoutFactory<F> factory, Map<String, String> pluginOptions) throws ProvisioningException {
        return new ProvisioningLayout<F>(this, config, factory, pluginOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <F extends FeaturePackLayout> F resolveFeaturePack(FeaturePackLocation location, int type, FeaturePackLayoutFactory<F> factory) throws ProvisioningException {
        Path fpDir = this.resolveFeaturePackDir(location);
        Path fpXml = fpDir.resolve("feature-pack.xml");
        if (!Files.exists(fpXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(fpXml));
        }
        try (BufferedReader reader = Files.newBufferedReader(fpXml);){
            F f = factory.newFeaturePack(location, FeaturePackXmlParser.getInstance().parse(reader), fpDir, type);
            return f;
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(fpXml), e);
        }
    }

    private synchronized Path resolveFeaturePackDir(FeaturePackLocation fpl) throws ProvisioningException {
        return this.cacheManager.put(this.universeResolver, fpl);
    }

    ProvisioningLayout.Handle createHandle() {
        ProvisioningLayout.Handle handle = new ProvisioningLayout.Handle(this);
        this.openHandles.incrementAndGet();
        return handle;
    }

    void handleClosed() {
        this.openHandles.decrementAndGet();
    }

    Path newConfigLayoutDir() {
        return IoUtils.createRandomDir(this.cacheManager.getHome());
    }

    @Override
    public void close() {
        this.cacheManager.close();
        this.checkOpenLayouts();
    }

    public void checkOpenLayouts() {
        if (this.openHandles.get() != 0) {
            throw new IllegalStateException("Remaining open handles: " + this.openHandles.get());
        }
    }
}

