/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.util.CollectionUtils;

public abstract class PackageDepsSpecBuilder<T extends PackageDepsSpecBuilder<T>> {
    protected Map<String, PackageDependencySpec> localPkgDeps = Collections.emptyMap();
    protected Map<String, Map<String, PackageDependencySpec>> externalPkgDeps = Collections.emptyMap();
    protected int requiredDeps;

    public T addPackageDep(String packageName) {
        return this.addPackageDep(packageName, false);
    }

    public T addPackageDep(String packageName, boolean optional) {
        return this.addPackageDep(optional ? PackageDependencySpec.optional(packageName) : PackageDependencySpec.required(packageName));
    }

    public T addPackageDep(String packageName, int type) throws ProvisioningDescriptionException {
        return this.addPackageDep(PackageDependencySpec.newInstance(packageName, type));
    }

    public T addPackageDep(PackageDependencySpec dep) {
        this.localPkgDeps = CollectionUtils.putLinked(this.localPkgDeps, dep.getName(), dep);
        if (!dep.isOptional()) {
            ++this.requiredDeps;
        }
        return (T)this;
    }

    public T addPackageDep(String origin, String packageName) {
        return this.addPackageDep(origin, packageName, false);
    }

    public T addPackageDep(String origin, String packageName, boolean optional) {
        return this.addPackageDep(origin, optional ? PackageDependencySpec.optional(packageName) : PackageDependencySpec.required(packageName));
    }

    public T addPackageDep(String origin, String packageName, int type) throws ProvisioningDescriptionException {
        return this.addPackageDep(origin, PackageDependencySpec.newInstance(packageName, type));
    }

    public T addPackageDep(String origin, PackageDependencySpec dep) {
        Map<String, PackageDependencySpec> deps;
        if (origin == null) {
            return this.addPackageDep(dep);
        }
        if (!dep.isOptional()) {
            ++this.requiredDeps;
        }
        if ((deps = this.externalPkgDeps.get(origin)) == null) {
            this.externalPkgDeps = CollectionUtils.put(this.externalPkgDeps, origin, Collections.singletonMap(dep.getName(), dep));
            return (T)this;
        }
        if (deps.size() == 1) {
            if (deps.containsKey(dep.getName())) {
                deps = Collections.singletonMap(origin, dep);
            } else {
                Map.Entry<String, PackageDependencySpec> first = deps.entrySet().iterator().next();
                deps = new HashMap<String, PackageDependencySpec>(2);
                deps.put(first.getKey(), first.getValue());
                deps.put(dep.getName(), dep);
            }
            if (this.externalPkgDeps.size() == 1) {
                this.externalPkgDeps = Collections.singletonMap(origin, deps);
            } else {
                this.externalPkgDeps.put(origin, deps);
            }
            return (T)this;
        }
        deps.put(dep.getName(), dep);
        return (T)this;
    }

    public boolean hasPackageDeps() {
        return this.localPkgDeps != null || !this.externalPkgDeps.isEmpty();
    }

    protected List<PackageDependencySpec> buildLocalPackageDeps() {
        return PackageDepsSpecBuilder.getValueList(this.localPkgDeps);
    }

    protected Map<String, List<PackageDependencySpec>> buildExternalPackageDeps() {
        if (this.externalPkgDeps.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.externalPkgDeps.size() == 1) {
            Map.Entry<String, Map<String, PackageDependencySpec>> first = this.externalPkgDeps.entrySet().iterator().next();
            return Collections.singletonMap(first.getKey(), PackageDepsSpecBuilder.getValueList(first.getValue()));
        }
        HashMap<String, List<PackageDependencySpec>> tmp = new HashMap<String, List<PackageDependencySpec>>(this.externalPkgDeps.size());
        for (Map.Entry<String, Map<String, PackageDependencySpec>> externalEntry : this.externalPkgDeps.entrySet()) {
            tmp.put(externalEntry.getKey(), PackageDepsSpecBuilder.getValueList(externalEntry.getValue()));
        }
        return CollectionUtils.unmodifiable(tmp);
    }

    private static List<PackageDependencySpec> getValueList(Map<String, PackageDependencySpec> localPkgDeps) {
        List<PackageDependencySpec> list;
        if (localPkgDeps.isEmpty()) {
            list = Collections.emptyList();
        } else if (localPkgDeps.size() == 1) {
            list = Collections.singletonList(localPkgDeps.entrySet().iterator().next().getValue());
        } else {
            ArrayList<PackageDependencySpec> tmp = new ArrayList<PackageDependencySpec>(localPkgDeps.size());
            for (Map.Entry<String, PackageDependencySpec> entry : localPkgDeps.entrySet()) {
                tmp.add(entry.getValue());
            }
            list = Collections.unmodifiableList(tmp);
        }
        return list;
    }
}

