/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class InstalledProducerCompleter
extends AbstractCommaSeparatedCompleter {
    @Override
    protected List<String> getItems(PmCompleterInvocation completerInvocation) {
        List<FeaturePackLocation> locations = InstalledProducerCompleter.getInstallationLocations(completerInvocation, true, false);
        CommandWithInstallationDirectory cmd = (CommandWithInstallationDirectory)((Object)completerInvocation.getCommand());
        ArrayList<String> items = new ArrayList<String>();
        String trimed = completerInvocation.getGivenCompleteValue().trim();
        List<String> lst = trimed.isEmpty() ? Collections.emptyList() : Arrays.asList(completerInvocation.getGivenCompleteValue().split(",+"));
        boolean ended = trimed.endsWith(",");
        int lastIndex = ended ? lst.size() : Math.max(0, lst.size() - 1);
        ArrayList<FeaturePackLocation> specified = new ArrayList<FeaturePackLocation>();
        try {
            for (String s : lst) {
                specified.add(completerInvocation.getPmSession().getResolvedLocation(cmd.getInstallationDirectory(completerInvocation.getAeshContext()), s));
            }
            for (FeaturePackLocation loc : locations) {
                boolean found = false;
                for (int i = 0; i < lastIndex; ++i) {
                    FeaturePackLocation s = (FeaturePackLocation)specified.get(i);
                    if (!s.getProducer().equals(loc.getProducer())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                items.add(completerInvocation.getPmSession().getExposedLocation(cmd.getInstallationDirectory(completerInvocation.getAeshContext()), loc).getProducer().toString());
            }
        }
        catch (Exception ex) {
            CliLogging.completionException(ex);
            return Collections.emptyList();
        }
        return items;
    }

    public static List<FeaturePackLocation> getInstallationLocations(PmCompleterInvocation completerInvocation, boolean transitive, boolean patches) {
        CommandWithInstallationDirectory cmd = (CommandWithInstallationDirectory)((Object)completerInvocation.getCommand());
        Path currentDir = cmd.getInstallationDirectory(completerInvocation.getAeshContext());
        ArrayList<FeaturePackLocation> items = new ArrayList<FeaturePackLocation>();
        try {
            PathsUtils.assertInstallationDir(currentDir);
            ProvisioningManager mgr = completerInvocation.getPmSession().newProvisioningManager(currentDir, false);
            try (ProvisioningLayout<FeaturePackLayout> layout = mgr.getLayoutFactory().newConfigLayout(mgr.getProvisioningConfig());){
                for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                    if (fp.isDirectDep() || fp.isTransitiveDep() && transitive) {
                        items.add(fp.getFPID().getLocation());
                    }
                    if (!patches) continue;
                    List<FeaturePackLayout> appliedPatches = layout.getPatches(fp.getFPID());
                    for (FeaturePackLayout patch : appliedPatches) {
                        items.add(patch.getFPID().getLocation());
                    }
                }
            }
        }
        catch (Exception ex) {
            CliLogging.completionException(ex);
        }
        return items;
    }
}

