/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.installation;

import java.io.File;
import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.StateAddUniverseCommand;

@CommandDefinition(name="add-universe", description="Add a universe to the current installation. Called without a universe name, set the default universe of this installation")
public class AddUniverseCommand
extends StateAddUniverseCommand {
    @Option(name="dir", required=false, description="Installation directory")
    protected File targetDirArg;

    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        try {
            commandInvocation.getPmSession().getUniverse().addUniverse(this.targetDirArg == null ? null : this.targetDirArg.toPath(), this.name, this.factory, this.location);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.addUniverseFailed(), ex);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return null;
    }
}

