/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Option;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.InstalledProducerCompleter;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.cli.cmd.maingrp.AbstractProvisioningCommand;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackUpdatePlan;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningPlan;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

@CommandDefinition(name="check-updates", description="Get available updates for a full installation or an identified feature pack")
public class CheckUpdatesCommand
extends AbstractProvisioningCommand {
    public static final String UP_TO_DATE = "Up to date. No available updates nor patches.";
    public static final String UPDATES_AVAILABLE = "Some updates and/or patches are available.";
    public static final String FP_OPTION_NAME = "feature-packs";
    private static final String NONE = "none";
    static final String ALL_DEPENDENCIES_OPTION_NAME = "include-all-dependencies";
    @Option(name="include-all-dependencies", hasValue=false, required=false, description="Include dependencies when checking for updates. Doesn't apply when specifying feature-packs", activator=AllDepsOptionActivator.class)
    boolean includeAll;
    @Option(name="feature-packs", hasValue=true, required=false, completer=InstalledProducerCompleter.class, description="The feature pack producers to check update for", activator=FPOptionActivator.class)
    String fp;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            ProvisioningManager mgr = this.getManager(session.getPmSession(), false);
            Updates updates = CheckUpdatesCommand.getUpdatesTable(mgr, session, this.includeAll, this.fp);
            if (updates.plan.isEmpty()) {
                session.println(UP_TO_DATE);
            } else {
                session.println(UPDATES_AVAILABLE);
                session.println(updates.t.build());
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.checkForUpdatesFailed(), ex);
        }
    }

    static Updates getUpdatesTable(ProvisioningManager mgr, PmCommandInvocation session, boolean includeAll, String fp) throws ProvisioningException, CommandExecutionException {
        ProvisioningPlan plan;
        if (!Files.exists(PathsUtils.getProvisioningXml(mgr.getInstallationHome()), new LinkOption[0])) {
            throw new CommandExecutionException(Errors.homeDirNotUsable(mgr.getInstallationHome()));
        }
        if (includeAll && fp != null) {
            throw new CommandExecutionException(CliErrors.onlyOneOptionOf(FP_OPTION_NAME, ALL_DEPENDENCIES_OPTION_NAME));
        }
        if (fp == null) {
            plan = mgr.getUpdates(includeAll);
        } else {
            String[] split = fp.split(",+");
            ArrayList<FeaturePackLocation.ProducerSpec> resolved = new ArrayList<FeaturePackLocation.ProducerSpec>();
            ArrayList locs = new ArrayList();
            for (String producer : split) {
                FeaturePackLocation loc = session.getPmSession().getResolvedLocation(mgr.getInstallationHome(), producer);
                if (loc.hasBuild()) {
                    locs.add(loc);
                    continue;
                }
                resolved.add(loc.getProducer());
            }
            if (!resolved.isEmpty()) {
                FeaturePackLocation.ProducerSpec[] arr = new FeaturePackLocation.ProducerSpec[resolved.size()];
                plan = mgr.getUpdates(resolved.toArray(arr));
            } else {
                plan = ProvisioningPlan.builder();
            }
            if (!locs.isEmpty()) {
                CheckUpdatesCommand.addCustomUpdates(plan, locs, mgr);
            }
        }
        Updates updates = new Updates();
        updates.plan = plan;
        if (plan.isEmpty()) {
            return updates;
        }
        boolean hasPatches = false;
        for (FeaturePackUpdatePlan p : plan.getUpdates()) {
            if (!p.hasNewPatches()) continue;
            hasPatches = true;
            break;
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Product");
        headers.add("Current Build");
        headers.add("Update");
        if (hasPatches) {
            headers.add("Patches");
        }
        if (includeAll) {
            headers.add("Dependency");
        }
        headers.add("Update Channel");
        updates.t = new Table(headers);
        for (FeaturePackUpdatePlan p : plan.getUpdates()) {
            FeaturePackLocation loc = p.getInstalledLocation();
            String update = p.hasNewLocation() ? p.getNewLocation().getBuild() : NONE;
            Table.Cell patches = null;
            if (hasPatches) {
                patches = new Table.Cell(new String[0]);
                if (p.hasNewPatches()) {
                    for (FeaturePackLocation.FPID id : p.getNewPatches()) {
                        patches.addLine(id.getBuild());
                    }
                } else {
                    patches.addLine(NONE);
                }
            }
            ArrayList<Table.Cell> line = new ArrayList<Table.Cell>();
            line.add(new Table.Cell(loc.getProducerName()));
            line.add(new Table.Cell(loc.getBuild()));
            line.add(new Table.Cell(update));
            if (hasPatches) {
                line.add(patches);
            }
            if (includeAll) {
                line.add(new Table.Cell(p.isTransitive() ? "Y" : "N"));
            }
            FeaturePackLocation newLocation = session.getPmSession().getExposedLocation(mgr.getInstallationHome(), p.getNewLocation());
            line.add(new Table.Cell(StateInfoUtil.formatChannel(newLocation)));
            updates.t.addCellsLine(line);
        }
        updates.t.sort(Table.SortType.ASCENDANT);
        return updates;
    }

    private static void addCustomUpdates(ProvisioningPlan plan, List<FeaturePackLocation> custom, ProvisioningManager mgr) throws ProvisioningException {
        try (ProvisioningLayout<FeaturePackLayout> layout = mgr.getLayoutFactory().newConfigLayout(mgr.getProvisioningConfig());){
            for (FeaturePackLocation loc : custom) {
                FeaturePackLayout fpl = layout.getFeaturePack(loc.getProducer());
                FeaturePackLocation current = fpl.getFPID().getLocation();
                FeaturePackUpdatePlan fpPlan = FeaturePackUpdatePlan.request(current, fpl.isTransitiveDep()).setNewLocation(loc).buildPlan();
                if (!fpPlan.hasNewLocation()) continue;
                plan.update(fpPlan);
            }
        }
    }

    static class Updates {
        Table t;
        ProvisioningPlan plan;

        Updates() {
        }
    }

    public static class AllDepsOptionActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand pc) {
            ParsedOption opt = pc.findLongOptionNoActivatorCheck(CheckUpdatesCommand.FP_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class FPOptionActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand pc) {
            ParsedOption opt = pc.findLongOptionNoActivatorCheck(CheckUpdatesCommand.ALL_DEPENDENCIES_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }
}

