/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.InstalledFPLCompleter;
import org.jboss.galleon.cli.cmd.plugin.AbstractProvisionWithPlugins;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;

public class UninstallCommand
extends AbstractProvisionWithPlugins {
    public UninstallCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("").hasValue(true).description("Feature pack to remove").type(String.class).optionType(OptionType.ARGUMENT).completer(InstalledFPLCompleter.class).build());
        return options;
    }

    @Override
    protected void doRunCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        try {
            this.getManager(session).uninstall(this.getFPID(session.getPmSession()), options);
        }
        catch (ProvisioningException e) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.uninstallFailed(), e);
        }
    }

    private FeaturePackLocation.FPID getFPID(PmSession session) throws CommandExecutionException {
        String fpid = this.getFPID();
        if (fpid == null) {
            throw new CommandExecutionException("No feature-pack provided");
        }
        try {
            return session.getResolvedLocation(this.getInstallationDirectory(session.getAeshContext()), fpid).getFPID();
        }
        catch (Exception e) {
            throw new CommandExecutionException(session, CliErrors.resolveLocationFailed(), e);
        }
    }

    @Override
    protected String getName() {
        return "uninstall";
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        if (this.getFPID() == null) {
            return false;
        }
        return super.canComplete(pmSession);
    }

    @Override
    protected String getDescription() {
        return "Un-install a feature pack from an installation.";
    }

    /*
     * Loose catch block
     */
    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state) throws Exception {
        String fpid = this.getFPID();
        Path dir = this.getAbsolutePath(this.getUninstallDir(), this.pmSession.getAeshContext());
        ProvisioningConfig config = ProvisioningXmlParser.parse(PathsUtils.getProvisioningXml(dir));
        if (config != null) {
            this.pmSession.unregisterTrackers();
            try {
                try (ProvisioningLayout<FeaturePackLayout> layout = this.pmSession.getLayoutFactory().newConfigLayout(config);){
                    layout.uninstall(this.pmSession.getResolvedLocation(this.getInstallationDirectory(this.pmSession.getAeshContext()), fpid).getFPID());
                    Set<ProvisioningOption> opts = PluginResolver.newResolver(this.pmSession, layout).resolve().getInstall();
                    ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
                    for (ProvisioningOption opt : opts) {
                        AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(opt.getName(), opt.isRequired());
                        options.add(dynOption);
                    }
                    ArrayList<AbstractDynamicCommand.DynamicOption> arrayList = options;
                    return arrayList;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.pmSession.registerTrackers();
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
    }

    private String getFPID() {
        String fpid = (String)this.getValue("");
        if (fpid == null) {
            fpid = this.getArgumentValue();
        }
        return fpid;
    }

    private String getUninstallDir() {
        String targetDirArg = (String)this.getValue("dir");
        if (targetDirArg == null) {
            targetDirArg = this.getOptionValue("dir");
        }
        return targetDirArg;
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }
}

