/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.util.PathsUtils;

public abstract class AbstractProvisionWithPlugins
extends AbstractDynamicCommand
implements CommandWithInstallationDirectory {
    protected AbstractProvisionWithPlugins(PmSession pmSession) {
        super(pmSession, true);
    }

    protected abstract List<ProcessedOption> getOtherOptions() throws OptionParserException;

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Installation directory").completer(FileOptionCompleter.class).build());
        options.add(ProcessedOptionBuilder.builder().name("verbose").hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected boolean isVerbose() {
        return this.contains("verbose");
    }

    private String getDir() {
        return (String)this.getValue("dir");
    }

    protected ProvisioningManager getManager(PmCommandInvocation session) throws ProvisioningException {
        return session.getPmSession().newProvisioningManager(this.getInstallationDirectory(session.getConfiguration().getAeshContext()), this.isVerbose());
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        return this.getDir() == null ? PmSession.getWorkDir(context) : this.getAbsolutePath(this.getDir(), context);
    }

    protected Path getAbsolutePath(String path, AeshContext context) {
        return path == null ? PmSession.getWorkDir(context) : Util.resolvePath(context, path);
    }

    protected abstract void doRunCommand(PmCommandInvocation var1, Map<String, String> var2) throws CommandExecutionException;

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        if (this.isVerbose()) {
            session.getPmSession().enableMavenTrace(true);
        }
        try {
            this.doRunCommand(session, options);
        }
        finally {
            session.getPmSession().enableMavenTrace(false);
        }
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        String targetDirArg = (String)this.getValue("dir");
        if (targetDirArg == null) {
            targetDirArg = this.getOptionValue("dir");
        }
        if (targetDirArg != null) {
            return true;
        }
        Path workDir = PmSession.getWorkDir(pmSession.getAeshContext());
        return Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0]);
    }
}

