/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.function.Function;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.InfoTypeCompleter;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;

@CommandDefinition(name="get-info", description="Display information on provisioning state")
public class StateGetInfoCommand
extends PmSessionCommand {
    @Option(completer=InfoTypeCompleter.class, description="Type of information to display (all, configs, dependencies, layers, options, patches)")
    private String type;

    @Override
    protected void runCommand(final PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            ProvisioningConfig config = invoc.getPmSession().getContainer().getProvisioningConfig();
            Function<ProvisioningLayout<FeaturePackLayout>, FeatureContainer> supplier = new Function<ProvisioningLayout<FeaturePackLayout>, FeatureContainer>(){

                @Override
                public FeatureContainer apply(ProvisioningLayout<FeaturePackLayout> layout) {
                    return invoc.getPmSession().getState().getContainer();
                }
            };
            StateInfoUtil.displayInfo(invoc, null, config, this.type, supplier);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.infoFailed(), ex);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

