/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FsDiff {
    private final FsEntry original;
    private final FsEntry other;
    private Map<String, FsEntry> added = Collections.emptyMap();
    private Map<String, FsEntry> removed = Collections.emptyMap();
    private Map<String, FsEntry[]> modified = Collections.emptyMap();

    public static FsDiff diff(FsEntry original, FsEntry other) throws ProvisioningException {
        return new FsDiff(original, other);
    }

    private FsDiff(FsEntry original, FsEntry other) throws ProvisioningException {
        this.original = original;
        this.other = other;
        this.doDiff(original, other);
    }

    private void doDiff(FsEntry originalEntry, FsEntry otherEntry) throws ProvisioningException {
        if (originalEntry.isDir() != otherEntry.isDir()) {
            this.removed = CollectionUtils.put(this.removed, originalEntry.getRelativePath(), originalEntry);
            this.added = CollectionUtils.put(this.added, otherEntry.getRelativePath(), otherEntry);
            return;
        }
        if (originalEntry.dir) {
            if (originalEntry.hasChildren()) {
                Map<String, FsEntry> otherChildren = otherEntry.cloneChildren();
                for (FsEntry originalChild : originalEntry.getChildren()) {
                    FsEntry otherChild = otherChildren.remove(originalChild.getName());
                    if (otherChild == null) {
                        this.removed = CollectionUtils.put(this.removed, originalChild.getRelativePath(), originalChild);
                        continue;
                    }
                    this.doDiff(originalChild, otherChild);
                }
                if (!otherChildren.isEmpty()) {
                    for (FsEntry otherChild : otherChildren.values()) {
                        this.added = CollectionUtils.put(this.added, otherChild.getRelativePath(), otherChild);
                    }
                }
            } else if (otherEntry.hasChildren()) {
                for (FsEntry otherChild : otherEntry.getChildren()) {
                    this.added = CollectionUtils.put(this.added, otherChild.getRelativePath(), otherChild);
                }
            }
            return;
        }
        if (!Arrays.equals(originalEntry.getHash(), otherEntry.getHash())) {
            this.modified = CollectionUtils.put(this.modified, originalEntry.getRelativePath(), new FsEntry[]{originalEntry, otherEntry});
        }
    }

    public FsEntry getOriginalRoot() {
        return this.original;
    }

    public FsEntry getOtherRoot() {
        return this.other;
    }

    public boolean isEmpty() {
        return this.modified.isEmpty() && this.added.isEmpty() && this.removed.isEmpty();
    }

    public boolean hasAddedEntries() {
        return !this.added.isEmpty();
    }

    public Collection<FsEntry> getAddedEntries() {
        return this.added.values();
    }

    public Set<String> getAddedPaths() {
        return this.added.keySet();
    }

    public FsEntry getAddedEntry(String relativePath) {
        return this.added.get(relativePath);
    }

    public boolean hasRemovedEntries() {
        return !this.removed.isEmpty();
    }

    public Collection<FsEntry> getRemovedEntries() {
        return this.removed.values();
    }

    public Set<String> getRemovedPaths() {
        return this.removed.keySet();
    }

    public boolean hasModifiedEntries() {
        return !this.modified.isEmpty();
    }

    public Collection<FsEntry[]> getModifiedEntries() {
        return this.modified.values();
    }

    public Set<String> getModifiedPaths() {
        return this.modified.keySet();
    }

    public FsEntry[] getModifiedEntry(String relativePath) {
        return this.modified.get(relativePath);
    }

    public void suppress(String relativePath) throws ProvisioningException {
        FsEntry[] fsEntries = this.modified.get(relativePath);
        if (fsEntries != null) {
            fsEntries[0].suppress();
            fsEntries[1].suppress();
            return;
        }
        FsEntry fsEntry = this.added.get(relativePath);
        if (fsEntry == null && (fsEntry = this.removed.get(relativePath)) == null) {
            throw new ProvisioningException("Failed to locate " + relativePath + " in the diff");
        }
        fsEntry.suppress();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        ArrayList<String> names = null;
        if (!this.added.isEmpty()) {
            buf.append("added: ");
            names = new ArrayList<String>(this.added.keySet());
            Collections.sort(names);
            StringUtils.append(buf, names);
        }
        if (!this.removed.isEmpty()) {
            if (buf.length() > 1) {
                buf.append("; ");
            }
            buf.append("removed: ");
            if (names == null) {
                names = new ArrayList(this.removed.size());
            } else {
                names.clear();
            }
            names.addAll(this.removed.keySet());
            Collections.sort(names);
            StringUtils.append(buf, names);
        }
        if (!this.modified.isEmpty()) {
            if (buf.length() > 1) {
                buf.append("; ");
            }
            buf.append("modified: ");
            if (names == null) {
                names = new ArrayList(this.modified.size());
            } else {
                names.clear();
            }
            names.addAll(this.modified.keySet());
            Collections.sort(names);
            StringUtils.append(buf, names);
        }
        return buf.append(']').toString();
    }
}

