/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class ProvisioningDiffProvider {
    private ProvisioningLayout<?> layout;
    private ProvisioningConfig provisioningConfig;
    private ProvisionedState provisionedState;
    private FsDiff fsDiff;
    private MessageWriter log;
    private Map<FeaturePackLocation.FPID, FeaturePackConfig.Builder> updatedDirectFps = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, FeaturePackConfig.Builder> updatedTransitiveFps = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, FeaturePackConfig.Builder> addedTransitiveFps = Collections.emptyMap();
    private Map<ConfigId, ConfigModel> updatedConfigs = Collections.emptyMap();
    private Map<ConfigId, ConfigModel> addedConfigs = Collections.emptyMap();
    private Set<ConfigId> removedConfigs = Collections.emptySet();
    private ProvisioningConfig mergedConfig;

    public static ProvisioningDiffProvider newInstance(ProvisioningLayout<?> layout, ProvisionedState provisionedState, FsDiff diff, MessageWriter log) {
        ProvisioningDiffProvider diffProvider = new ProvisioningDiffProvider();
        diffProvider.layout = layout;
        diffProvider.provisioningConfig = layout.getConfig();
        diffProvider.provisionedState = provisionedState;
        diffProvider.fsDiff = diff;
        diffProvider.log = log;
        return diffProvider;
    }

    private ProvisioningDiffProvider() {
    }

    public MessageWriter getMessageWriter() {
        return this.log;
    }

    public ProvisioningLayout<?> getProvisioningLayout() {
        return this.layout;
    }

    public ProvisioningConfig getOriginalConfig() {
        return this.provisioningConfig;
    }

    public ProvisionedState getProvisionedState() {
        return this.provisionedState;
    }

    public FsDiff getFsDiff() {
        return this.fsDiff;
    }

    public void excludePackage(FeaturePackLocation.FPID fpid, String name, String ... relativePaths) throws ProvisioningException {
        this.getFpcBuilder(fpid).excludePackage(name);
        this.suppressPaths(relativePaths);
    }

    public void includePackage(FeaturePackLocation.FPID fpid, String name, String ... relativePaths) throws ProvisioningException {
        this.getFpcBuilder(fpid).includePackage(name);
        this.suppressPaths(relativePaths);
    }

    public void updateConfig(ConfigModel config, String ... relativePaths) throws ProvisioningException {
        this.updatedConfigs = CollectionUtils.put(this.updatedConfigs, config.getId(), config);
        this.suppressPaths(relativePaths);
    }

    public void addConfig(ConfigModel config, String ... relativePaths) throws ProvisioningException {
        this.addedConfigs = CollectionUtils.putLinked(this.addedConfigs, config.getId(), config);
        this.suppressPaths(relativePaths);
    }

    public void removeConfig(ConfigId configId, String ... relativePaths) throws ProvisioningException {
        this.removedConfigs = CollectionUtils.add(this.removedConfigs, configId);
        this.suppressPaths(relativePaths);
    }

    public boolean hasConfigChanges() {
        return !this.updatedDirectFps.isEmpty() || !this.updatedTransitiveFps.isEmpty() || !this.addedTransitiveFps.isEmpty() || !this.updatedConfigs.isEmpty() || !this.addedConfigs.isEmpty() || !this.removedConfigs.isEmpty();
    }

    public ProvisioningConfig getMergedConfig() throws ProvisioningException {
        FeaturePackConfig.Builder fpcBuilder;
        if (this.mergedConfig != null) {
            return this.mergedConfig;
        }
        if (!this.hasConfigChanges()) {
            this.mergedConfig = this.provisioningConfig;
            return this.provisioningConfig;
        }
        ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
        configBuilder.initUniverses(this.provisioningConfig);
        if (this.provisioningConfig.hasPluginOptions()) {
            configBuilder.addOptions(this.provisioningConfig.getPluginOptions());
        }
        for (FeaturePackConfig fp : this.provisioningConfig.getFeaturePackDeps()) {
            fpcBuilder = this.updatedDirectFps.get(fp.getLocation().getFPID());
            if (fpcBuilder == null) {
                configBuilder.addFeaturePackDep(this.provisioningConfig.originOf(fp.getLocation().getProducer()), fp);
                continue;
            }
            configBuilder.addFeaturePackDep(this.provisioningConfig.originOf(fp.getLocation().getProducer()), fpcBuilder.build());
        }
        for (FeaturePackConfig fp : this.provisioningConfig.getTransitiveDeps()) {
            fpcBuilder = this.updatedTransitiveFps.get(fp.getLocation().getFPID());
            if (fpcBuilder == null) {
                configBuilder.addFeaturePackDep(this.provisioningConfig.originOf(fp.getLocation().getProducer()), fp);
                continue;
            }
            configBuilder.addFeaturePackDep(this.provisioningConfig.originOf(fp.getLocation().getProducer()), fpcBuilder.build());
        }
        for (FeaturePackConfig.Builder fpcBuilder2 : this.addedTransitiveFps.values()) {
            configBuilder.addFeaturePackDep(fpcBuilder2.build());
        }
        for (ConfigModel originalConfig : this.provisioningConfig.getDefinedConfigs()) {
            ConfigModel config = this.updatedConfigs.get(originalConfig.getId());
            if (config != null) {
                configBuilder.addConfig(config);
                continue;
            }
            if (this.removedConfigs.contains(originalConfig.getId())) continue;
            configBuilder.addConfig(originalConfig);
        }
        if (!this.addedConfigs.isEmpty()) {
            for (ConfigModel config : this.addedConfigs.values()) {
                configBuilder.addConfig(config);
            }
        }
        this.mergedConfig = configBuilder.build();
        return this.mergedConfig;
    }

    private void suppressPaths(String ... relativePaths) throws ProvisioningException {
        for (String relativePath : relativePaths) {
            this.fsDiff.suppress(relativePath);
        }
    }

    private FeaturePackConfig.Builder getFpcBuilder(FeaturePackLocation.FPID fpid) {
        FeaturePackConfig.Builder fpcBuilder = this.updatedDirectFps.get(fpid);
        if (fpcBuilder != null) {
            return fpcBuilder;
        }
        fpcBuilder = this.updatedTransitiveFps.get(fpid);
        if (fpcBuilder != null) {
            return fpcBuilder;
        }
        fpcBuilder = this.addedTransitiveFps.get(fpid);
        if (fpcBuilder != null) {
            return fpcBuilder;
        }
        FeaturePackConfig fpc = this.provisioningConfig.getFeaturePackDep(fpid.getProducer());
        if (fpc != null) {
            fpcBuilder = FeaturePackConfig.builder(fpc);
            this.updatedDirectFps = CollectionUtils.put(this.updatedDirectFps, fpid, fpcBuilder);
            return fpcBuilder;
        }
        fpc = this.provisioningConfig.getTransitiveDep(fpid.getProducer());
        if (fpc != null) {
            fpcBuilder = FeaturePackConfig.builder(fpc);
            this.updatedTransitiveFps = CollectionUtils.put(this.updatedTransitiveFps, fpid, fpcBuilder);
            return fpcBuilder;
        }
        fpcBuilder = FeaturePackConfig.transitiveBuilder(fpid.getLocation());
        this.addedTransitiveFps = CollectionUtils.putLinked(this.addedTransitiveFps, fpid, fpcBuilder);
        return fpcBuilder;
    }
}

