/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedStateXmlParser30;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedConfigXmlWriter
extends BaseXmlWriter<ProvisionedConfig> {
    private static final ProvisionedConfigXmlWriter INSTANCE = new ProvisionedConfigXmlWriter();

    public static ProvisionedConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedConfigXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ProvisionedConfig config) throws XMLStreamException {
        ElementNode propE;
        ElementNode propsE;
        ElementNode configE = ProvisionedConfigXmlWriter.addElement(null, ProvisionedStateXmlParser30.Element.CONFIG);
        if (config.getName() != null) {
            ProvisionedConfigXmlWriter.addAttribute(configE, ProvisionedStateXmlParser30.Attribute.NAME, config.getName());
        }
        if (config.getModel() != null) {
            ProvisionedConfigXmlWriter.addAttribute(configE, ProvisionedStateXmlParser30.Attribute.MODEL, config.getModel());
        }
        if (config.hasProperties()) {
            propsE = ProvisionedConfigXmlWriter.addElement(configE, ProvisionedStateXmlParser30.Element.PROPS);
            for (Map.Entry entry : config.getProperties().entrySet()) {
                propE = ProvisionedConfigXmlWriter.addElement(propsE, ProvisionedStateXmlParser30.Element.PROP);
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedStateXmlParser30.Attribute.NAME, (String)entry.getKey());
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedStateXmlParser30.Attribute.VALUE, (String)entry.getValue());
            }
        }
        if (config.hasLayers()) {
            propsE = ProvisionedConfigXmlWriter.addElement(configE, ProvisionedStateXmlParser30.Element.LAYERS);
            for (ConfigId configId : config.getLayers()) {
                propE = ProvisionedConfigXmlWriter.addElement(propsE, ProvisionedStateXmlParser30.Element.LAYER);
                if (configId.getModel() != null) {
                    ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedStateXmlParser30.Attribute.MODEL, configId.getModel());
                }
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedStateXmlParser30.Attribute.NAME, configId.getName());
            }
        }
        if (config.hasFeatures()) {
            try {
                config.handle(new XmlConfigHandler(configE));
            }
            catch (ProvisioningException e) {
                throw new XMLStreamException("Failed to marshal ProvisionedConfig", e);
            }
        }
        return configE;
    }

    private static class XmlConfigHandler
    implements ProvisionedConfigHandler {
        private final ElementNode parent;
        private ElementNode fpElement;
        private ElementNode specElement;

        XmlConfigHandler(ElementNode parent) {
            this.parent = parent;
        }

        @Override
        public void nextFeaturePack(FeaturePackLocation.FPID fpid) {
            this.fpElement = BaseXmlWriter.addElement(this.parent, ProvisionedStateXmlParser30.Element.FEATURE_PACK);
            BaseXmlWriter.addAttribute(this.fpElement, ProvisionedStateXmlParser30.Attribute.LOCATION, fpid.toString());
        }

        @Override
        public void nextSpec(ResolvedFeatureSpec spec) {
            this.specElement = BaseXmlWriter.addElement(this.fpElement, ProvisionedStateXmlParser30.Element.SPEC);
            BaseXmlWriter.addAttribute(this.specElement, ProvisionedStateXmlParser30.Attribute.NAME, spec.getId().getName());
        }

        @Override
        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            ElementNode featureE = BaseXmlWriter.addElement(this.specElement, ProvisionedStateXmlParser30.Element.FEATURE);
            if (feature.hasId()) {
                BaseXmlWriter.addAttribute(featureE, ProvisionedStateXmlParser30.Attribute.ID, feature.getId().toString());
            }
            if (feature.hasParams()) {
                for (String param : feature.getParamNames()) {
                    ElementNode paramE = BaseXmlWriter.addElement(featureE, ProvisionedStateXmlParser30.Element.PARAM);
                    BaseXmlWriter.addAttribute(paramE, ProvisionedStateXmlParser30.Attribute.NAME, param);
                    BaseXmlWriter.addAttribute(paramE, ProvisionedStateXmlParser30.Attribute.VALUE, feature.getConfigParam(param));
                }
            }
        }
    }
}

