/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.Objects;
import org.aesh.command.Command;
import org.jboss.galleon.cli.HelpDescriptions;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.PmGroupCommand;

public class CommandDomain
implements Comparable<CommandDomain> {
    public static final CommandDomain PROVISIONING = new CommandDomain(0, "Commands to achieve main provisioning use cases");
    public static final CommandDomain INSTALLATION = new CommandDomain(10, "Commands to manage existing installations");
    public static final CommandDomain FEATURE_PACK = new CommandDomain(20, "Commands to manage feature packs");
    public static final CommandDomain CONFIGURATION = new CommandDomain(30, "Commands to configure CLI tool");
    public static final CommandDomain STATE_MODE = new CommandDomain(40, HelpDescriptions.DOMAIN_EDIT_MODE);
    public static final CommandDomain EDITING = new CommandDomain(50, "Commands to edit the current provisioning state. Only available in edit mode");
    public static final CommandDomain OTHERS = new CommandDomain(60, "Other commands");
    private final String description;
    private final Integer ordinal;

    private CommandDomain(int ordinal, String description) {
        this.ordinal = ordinal;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static CommandDomain getDomain(Command command) {
        if (command instanceof AbstractDynamicCommand) {
            AbstractDynamicCommand dyn = (AbstractDynamicCommand)command;
            return dyn.getDomain();
        }
        if (command instanceof PmSessionCommand) {
            PmSessionCommand pm = (PmSessionCommand)command;
            return pm.getDomain();
        }
        if (command instanceof PmGroupCommand) {
            PmGroupCommand grp = (PmGroupCommand)command;
            return grp.getDomain();
        }
        return OTHERS;
    }

    @Override
    public int compareTo(CommandDomain o) {
        return this.ordinal.compareTo(o.ordinal);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CommandDomain)) {
            return false;
        }
        CommandDomain cd = (CommandDomain)other;
        return this.ordinal.equals(cd.ordinal);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.ordinal);
        return hash;
    }
}

