/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Map<String, String> options;
    private final Builder builder;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.options = CollectionUtils.unmodifiable(builder.options);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Deprecated
    public boolean hasPluginOptions() {
        return !this.options.isEmpty();
    }

    @Deprecated
    public Map<String, String> getPluginOptions() {
        return this.options;
    }

    @Deprecated
    public boolean hasPluginOption(String name) {
        return this.options.containsKey(name);
    }

    @Deprecated
    public String getPluginOption(String name) {
        return this.options.get(name);
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public String getOption(String name) {
        return this.options.get(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningConfig other = (ProvisioningConfig)obj;
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        if (this.defaultUniverse != null) {
            buf.append("default-universe=").append(this.defaultUniverse);
        }
        if (!this.universeSpecs.isEmpty()) {
            if (this.defaultUniverse != null) {
                buf.append(' ');
            }
            buf.append("universes=[");
            StringUtils.append(buf, this.universeSpecs.entrySet());
            buf.append("] ");
        }
        if (!this.options.isEmpty()) {
            buf.append("options=");
            StringUtils.append(buf, this.options.entrySet());
        }
        if (!this.transitiveDeps.isEmpty()) {
            buf.append("transitive=");
            StringUtils.append(buf, this.transitiveDeps.values());
            buf.append(' ');
        }
        StringUtils.append(buf, this.fpDeps.values());
        this.append(buf);
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Map<String, String> options = Collections.emptyMap();

        private Builder() {
        }

        private Builder(ProvisioningConfig original) throws ProvisioningDescriptionException {
            if (original == null) {
                return;
            }
            if (original.hasPluginOptions()) {
                this.addOptions(original.getPluginOptions());
            }
            for (FeaturePackConfig fp : original.getFeaturePackDeps()) {
                this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
            }
            if (original.hasTransitiveDeps()) {
                for (FeaturePackConfig fp : original.getTransitiveDeps()) {
                    this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
                }
            }
            this.initUniverses(original);
            this.initConfigs(original);
        }

        public Builder addOption(String name, String value) {
            this.options = CollectionUtils.put(this.options, name, value);
            return this;
        }

        public Builder removeOption(String name) {
            this.options = CollectionUtils.remove(this.options, name);
            return this;
        }

        public Builder clearOptions() {
            this.options = Collections.emptyMap();
            return this;
        }

        public Builder addOptions(Map<String, String> options) {
            this.options = CollectionUtils.putAll(this.options, options);
            return this;
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

