/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;

public class LayoutUtils {
    public static Path getFeaturePackDir(Path fpLayoutDir, FeaturePackLocation.FPID fpid) throws ProvisioningDescriptionException {
        return LayoutUtils.getFeaturePackDir(fpLayoutDir, fpid, true);
    }

    public static Path getFeaturePackDir(Path fpLayoutDir, FeaturePackLocation.FPID fpid, boolean existing) throws ProvisioningDescriptionException {
        FeaturePackLocation fps = fpid.getLocation();
        UniverseSpec universe = fps.getUniverse();
        Path fpPath = fpLayoutDir.resolve(universe.getFactory());
        if (universe.getLocation() != null) {
            fpPath = fpPath.resolve(LayoutUtils.ensureValidFileName(universe.getLocation()));
        }
        fpPath = fpPath.resolve(LayoutUtils.ensureValidFileName(fps.getProducerName())).resolve(fps.getChannelName()).resolve(LayoutUtils.ensureValidFileName(fpid.getBuild()));
        if (existing && !Files.exists(fpPath, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(fpPath));
        }
        return fpPath;
    }

    public static String ensureValidFileName(String value) {
        return value.replaceAll("[:\\(\\)\\[\\]\\,]", "_");
    }

    public static Path getPackageDir(Path fpDir, String packageName) throws ProvisioningDescriptionException {
        return LayoutUtils.getPackageDir(fpDir, packageName, true);
    }

    public static Path getPackageDir(Path fpDir, String packageName, boolean existing) throws ProvisioningDescriptionException {
        Path dir = fpDir.resolve("packages").resolve(packageName);
        if (existing && !Files.exists(dir, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(dir));
        }
        return dir;
    }

    public static Path getPackageContentDir(Path fpDir, String packageName) {
        return fpDir.resolve("packages").resolve(packageName).resolve("content");
    }

    public static Path getLayerSpecXml(Path fpDir, String model, String name, boolean existing) throws ProvisioningDescriptionException {
        Path p = fpDir.resolve("layers");
        if (model != null) {
            p = p.resolve(model);
        }
        p = p.resolve(name).resolve("layer-spec.xml");
        if (existing && !Files.exists(p, new LinkOption[0])) {
            throw new ProvisioningDescriptionException("Failed to locate XML file describing configuration layer " + name + " at " + p);
        }
        return p;
    }

    public static Path getConfigXml(Path fpDir, ConfigId configId, boolean existing) throws ProvisioningDescriptionException {
        Path p;
        String model = configId.getModel();
        String name = configId.getName();
        if (name == null) {
            if (model == null) {
                throw new ProvisioningDescriptionException("Anonymous configs are included in feature-pack.xml");
            }
            p = fpDir.resolve("configs").resolve(model).resolve("model.xml");
        } else {
            p = model == null ? fpDir.resolve("configs").resolve(name).resolve("config.xml") : fpDir.resolve("configs").resolve(model).resolve(name).resolve("config.xml");
        }
        if (existing && !Files.exists(p, new LinkOption[0])) {
            throw new ProvisioningDescriptionException("Failed to locate XML file describing configuration " + configId + " at " + p);
        }
        return p;
    }

    public static Path getHashesDir(Path home) {
        return home.resolve(".galleon").resolve("hashes");
    }
}

