/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.utils.Config;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cache.FeaturePackCacheManager;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CliMavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.ToolModes;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.resolver.ResourceResolver;
import org.jboss.galleon.cli.tracking.ProgressTrackers;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;

public class PmSession
implements CompleterInvocationProvider<PmCompleterInvocation>,
CommandActivatorProvider,
OptionActivatorProvider<OptionActivator> {
    private static final String EDIT_MODE_PROMPT = "!edit!";
    private PrintStream out;
    private PrintStream err;
    private final Configuration config;
    private State state;
    private String currentPath;
    private final CliMavenArtifactRepositoryManager maven;
    private final MavenListener mavenListener;
    private final UniverseManager universe;
    private final ResourceResolver resolver;
    private final ProvisioningLayoutFactory layoutFactory;
    private AeshContext ctx;
    private boolean rethrow = false;
    private boolean enableTrackers = true;
    private final CliOverwritePolicy policy = new CliOverwritePolicy();
    private final boolean interactive;
    private final FeaturePackCacheManager cacheManager;
    private ToolModes toolModes;
    private String promptRoot;
    private Path previousDir;
    private boolean commandRunning;

    public PmSession(Configuration config) throws Exception {
        this(config, true);
    }

    public PmSession(Configuration config, UniverseSpec builtin) throws Exception {
        this(config, true, builtin);
    }

    public PmSession(Configuration config, boolean interactive) throws Exception {
        this(config, interactive, null);
    }

    public PmSession(Configuration config, boolean interactive, UniverseSpec builtin) throws Exception {
        this.config = config;
        this.mavenListener = new MavenListener();
        this.maven = new CliMavenArtifactRepositoryManager(config.getMavenConfig(), this.mavenListener);
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(this.maven)).build();
        this.universe = new UniverseManager(this, config, this.maven, universeResolver, builtin);
        this.interactive = interactive;
        this.cacheManager = new FeaturePackCacheManager(config.getLayoutCache(), this.policy);
        this.layoutFactory = interactive ? ProvisioningLayoutFactory.getInstance(universeResolver, this.cacheManager) : ProvisioningLayoutFactory.getInstance(universeResolver);
        this.resolver = new ResourceResolver(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    void setModes(ToolModes toolModes) {
        this.toolModes = toolModes;
    }

    ToolModes getToolModes() {
        return this.toolModes;
    }

    public void clearLayoutCache() throws IOException {
        this.config.clearLayoutCache();
    }

    public void cleanupLayoutCache() {
        try {
            if (!Files.exists(this.cacheManager.getHome(), new LinkOption[0])) {
                return;
            }
            Properties props = this.config.getLayoutCacheContent();
            long now = System.currentTimeMillis();
            HashSet<String> toRemove = new HashSet<String>();
            final HashSet<Path> fpPaths = new HashSet<Path>();
            for (String k : props.stringPropertyNames()) {
                Iterator<Path> it;
                String time = props.getProperty(k);
                long lastUsage = Long.decode(time);
                Path p = LayoutUtils.getFeaturePackDir(this.config.getLayoutCache(), FeaturePackLocation.fromString(k).getFPID());
                if (!Files.exists(p, new LinkOption[0])) {
                    toRemove.add(k);
                } else if (now - lastUsage > 2592000000L) {
                    toRemove.add(k);
                    try {
                        this.cacheManager.remove(FeaturePackLocation.fromString(k).getFPID());
                    }
                    catch (ProvisioningException ex) {
                        CliLogging.exception(ex);
                    }
                }
                if (!(it = this.cacheManager.getHome().relativize(p).iterator()).hasNext()) continue;
                fpPaths.add(it.next());
            }
            if (!toRemove.isEmpty()) {
                for (String k : toRemove) {
                    props.remove(k);
                }
                this.config.storeLayoutCacheContent(props);
            }
            Files.list(this.cacheManager.getHome()).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path t) {
                    if (!fpPaths.contains(t.getFileName())) {
                        IoUtils.recursiveDelete(t);
                    }
                }
            });
        }
        catch (IOException | ProvisioningDescriptionException ex) {
            CliLogging.exception(ex);
        }
    }

    public void enableTrackers(boolean enable) {
        this.enableTrackers = enable;
    }

    public boolean isTrackersEnabled() {
        return this.enableTrackers;
    }

    public void registerTrackers() {
        if (this.enableTrackers && this.commandRunning) {
            ProgressTrackers.registerTrackers(this);
        }
    }

    public void unregisterTrackers() {
        ProgressTrackers.unregisterTrackers(this);
    }

    public void throwException() {
        this.rethrow = true;
    }

    public boolean isExceptionRethrown() {
        return this.rethrow;
    }

    public void close() {
        try {
            if (this.state != null) {
                this.state.close();
            }
        }
        finally {
            try {
                this.universe.close();
            }
            finally {
                if (this.interactive) {
                    this.layoutFactory.checkOpenLayouts();
                } else {
                    this.layoutFactory.close();
                }
            }
        }
    }

    MavenRepoManager getMavenRepoManager() {
        return this.maven;
    }

    void setAeshContext(AeshContext ctx) {
        this.ctx = ctx;
    }

    public AeshContext getAeshContext() {
        return this.ctx;
    }

    public ProvisioningManager newProvisioningManager(Path installation, boolean verbose) throws ProvisioningException {
        ProvisioningManager.Builder builder = ProvisioningManager.builder();
        builder.setLayoutFactory(this.getLayoutFactory());
        if (installation != null) {
            builder.setInstallationHome(installation);
        }
        builder.setMessageWriter(this.getMessageWriter(verbose));
        return builder.build();
    }

    public MessageWriter getMessageWriter(boolean verbose) {
        if (this.enableTrackers && verbose) {
            this.unregisterTrackers();
        }
        return new DefaultMessageWriter(this.out, this.err, verbose);
    }

    public ProvisioningLayoutFactory getLayoutFactory() {
        return this.layoutFactory;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public UniverseManager getUniverse() {
        return this.universe;
    }

    public FeaturePackLocation getResolvedLocation(Path installation, String location) throws ProvisioningException {
        if (location.endsWith("/") || location.endsWith("#")) {
            location = location.substring(0, location.length() - 1);
        }
        if (!location.contains("@") && !location.contains(":")) {
            location = new FeaturePackLocation(this.universe.getDefaultUniverseSpec(installation), location, null, null, null).toString();
        }
        FeaturePackLocation loc = FeaturePackLocation.fromString(location);
        return this.getResolvedLocation(installation, loc);
    }

    public void commandStart(PmCommandInvocation session) {
        if (this.interactive) {
            this.policy.commandStart();
        }
        this.commandRunning = true;
        this.maven.commandStart();
        ProgressTrackers.commandStart(session);
        this.registerTrackers();
    }

    public void commandEnd(PmCommandInvocation session) {
        if (this.interactive) {
            this.policy.commandEnd();
        }
        this.maven.commandEnd();
        ProgressTrackers.commandEnd(session);
        this.unregisterTrackers();
        this.commandRunning = false;
    }

    public void setState(State state) {
        if (state == null) {
            if (this.state != null) {
                this.state.close();
            }
            this.setCurrentPath(null);
            this.toolModes.setMode(ToolModes.Mode.NOMINAL);
            this.promptRoot = null;
        } else {
            this.toolModes.setMode(ToolModes.Mode.EDIT);
            this.promptRoot = EDIT_MODE_PROMPT + (state.getName() == null ? "" : state.getName() + "!");
        }
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public FeatureContainer getContainer() {
        if (this.state != null) {
            return this.state.getContainer();
        }
        return null;
    }

    public String getCurrentPath() {
        if (this.state != null) {
            return this.state.getPath();
        }
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        if (this.state != null) {
            this.state.setPath(currentPath);
        }
        this.currentPath = currentPath;
    }

    public Path getPreviousDirectory() {
        return this.previousDir;
    }

    public void setCurrentDirectory(Path path) throws IOException {
        FileResource res = new FileResource(path);
        List<Resource> files = res.resolve(this.ctx.getCurrentWorkingDirectory());
        if (!files.get(0).isDirectory()) {
            throw new IOException(CliErrors.unknownDirectory(path.getFileName().toString()));
        }
        this.previousDir = Paths.get(this.ctx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
        this.ctx.setCurrentWorkingDirectory(files.get(0));
    }

    public void println(String txt) {
        this.out.print(txt + Config.getLineSeparator());
    }

    public void print(String txt) {
        this.out.print(txt);
    }

    public Configuration getPmConfiguration() {
        return this.config;
    }

    public Prompt buildPrompt() {
        ToolModes.Mode mode = this.toolModes.getActiveMode();
        Prompt prompt = null;
        switch (mode) {
            case NOMINAL: {
                prompt = this.buildPrompt(this.ctx.getCurrentWorkingDirectory().getName());
                break;
            }
            case EDIT: {
                prompt = this.buildPrompt("");
            }
        }
        return prompt;
    }

    public Prompt buildPrompt(String name) {
        return new Prompt('[' + (this.promptRoot == null ? "" : this.promptRoot) + name + "]$ ");
    }

    public static Path getWorkDir(AeshContext aeshCtx) {
        return Paths.get(aeshCtx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    void setErr(PrintStream err) {
        this.err = err;
    }

    PrintStream getErr() {
        return this.err;
    }

    @Override
    public PmCompleterInvocation enhanceCompleterInvocation(CompleterInvocation completerInvocation) {
        return new PmCompleterInvocation(completerInvocation, this);
    }

    public CommandActivator enhanceCommandActivator(CommandActivator ca) {
        if (ca instanceof PmCommandActivator) {
            ((PmCommandActivator)ca).setPmSession(this);
        }
        return ca;
    }

    @Override
    public OptionActivator enhanceOptionActivator(OptionActivator oa) {
        if (oa instanceof PmOptionActivator) {
            ((PmOptionActivator)oa).setPmSession(this);
        }
        return oa;
    }

    public void downloadFp(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        this.universe.resolve(this.getResolvedLocation(null, fpid.getLocation()));
    }

    private FeaturePackLocation getResolvedLocation(Path installation, FeaturePackLocation fplocation) throws ProvisioningException {
        UniverseSpec spec = fplocation.getUniverse();
        if (spec != null) {
            if (spec.getLocation() == null && (spec = this.universe.getUniverseSpec(installation, spec.getFactory())) == null) {
                throw new ProvisioningException("Unknown universe for " + fplocation);
            }
        } else {
            spec = this.universe.getDefaultUniverseSpec(installation);
        }
        return new FeaturePackLocation(spec, fplocation.getProducerName(), fplocation.getChannelName(), fplocation.getFrequency(), fplocation.getBuild());
    }

    public FeaturePackLocation getExposedLocation(Path installation, FeaturePackLocation fplocation) {
        UniverseSpec spec = fplocation.getUniverse();
        boolean rewrite = false;
        String name = this.getUniverse().getUniverseName(installation, spec);
        if (name != null) {
            rewrite = true;
            spec = new UniverseSpec(name, null);
        } else if (this.getUniverse().getDefaultUniverseSpec(installation).equals(spec)) {
            rewrite = true;
            spec = null;
        }
        if (rewrite) {
            fplocation = new FeaturePackLocation(spec, fplocation.getProducerName(), fplocation.getChannelName(), fplocation.getFrequency(), fplocation.getBuild());
        }
        return fplocation;
    }

    public void enableMavenTrace(boolean b) {
        this.mavenListener.setActive(b);
    }

    private class MavenListener
    implements RepositoryListener {
        private static final String MAVEN = "[MAVEN] ";
        private boolean active;

        private MavenListener() {
        }

        void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void artifactDownloaded(RepositoryEvent re) {
            if (this.active && re != null) {
                String artifact = re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension();
                if (re.getException() == null) {
                    PmSession.this.println("[MAVEN] downloaded " + artifact + " from " + re.getRepository().getId());
                } else if (re.getException() instanceof ArtifactNotFoundException) {
                    PmSession.this.println("[MAVEN] artifact " + artifact + " not found in " + re.getRepository().getId());
                } else {
                    PmSession.this.println(MAVEN + re.getException().getLocalizedMessage() + " while downloading artifact " + artifact);
                }
            }
        }

        @Override
        public void artifactDownloading(RepositoryEvent re) {
            if (this.active && re != null) {
                PmSession.this.println("[MAVEN] attempting to download " + re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension() + (re.getRepository() != null ? " from " + re.getRepository().getId() : ""));
            }
        }

        @Override
        public void artifactDescriptorInvalid(RepositoryEvent re) {
        }

        @Override
        public void artifactDescriptorMissing(RepositoryEvent re) {
        }

        @Override
        public void metadataInvalid(RepositoryEvent re) {
        }

        @Override
        public void artifactResolving(RepositoryEvent re) {
        }

        @Override
        public void artifactResolved(RepositoryEvent re) {
        }

        @Override
        public void metadataResolving(RepositoryEvent re) {
        }

        @Override
        public void metadataResolved(RepositoryEvent re) {
        }

        @Override
        public void metadataDownloading(RepositoryEvent re) {
        }

        @Override
        public void metadataDownloaded(RepositoryEvent re) {
        }

        @Override
        public void artifactInstalling(RepositoryEvent re) {
        }

        @Override
        public void artifactInstalled(RepositoryEvent re) {
        }

        @Override
        public void metadataInstalling(RepositoryEvent re) {
        }

        @Override
        public void metadataInstalled(RepositoryEvent re) {
        }

        @Override
        public void artifactDeploying(RepositoryEvent re) {
        }

        @Override
        public void artifactDeployed(RepositoryEvent re) {
        }

        @Override
        public void metadataDeploying(RepositoryEvent re) {
        }

        @Override
        public void metadataDeployed(RepositoryEvent re) {
        }
    }

    private class CliOverwritePolicy
    implements FeaturePackCacheManager.OverwritePolicy {
        private final Set<FeaturePackLocation.FPID> seen = new HashSet<FeaturePackLocation.FPID>();

        private CliOverwritePolicy() {
        }

        void commandStart() {
            this.seen.clear();
        }

        void commandEnd() {
            if (this.seen.isEmpty()) {
                return;
            }
            try {
                Properties props = PmSession.this.config.getLayoutCacheContent();
                long time = System.currentTimeMillis();
                for (FeaturePackLocation.FPID id : this.seen) {
                    props.setProperty(id.toString(), "" + time);
                }
                PmSession.this.config.storeLayoutCacheContent(props);
            }
            catch (IOException ex) {
                CliLogging.exception(ex);
            }
        }

        @Override
        public boolean hasExpired(Path fpDir, FeaturePackLocation.FPID fpid) {
            try {
                boolean devBuild = PmSession.this.universe.getUniverse(fpid.getUniverse()).getProducer(fpid.getProducer().getName()).getChannel(fpid.getChannel().getName()).isDevBuild(fpid);
                return devBuild && !this.seen.contains(fpid);
            }
            catch (ProvisioningException ex) {
                CliLogging.exception(ex);
                return true;
            }
        }

        @Override
        public void cached(FeaturePackLocation.FPID fpid) {
            this.seen.add(fpid);
        }
    }
}

