/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.parser.AeshCommandLineParser;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapProcessedCommandBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.parser.ParsedLine;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.model.state.State;

public abstract class AbstractDynamicCommand
extends MapCommand<PmCommandInvocation> {
    public static final String ARGUMENT_NAME = "";
    private final Map<String, String> renamedOptions = new HashMap<String, String>();
    protected final PmSession pmSession;
    private final Set<String> staticOptions = new HashSet<String>();
    private MapProcessedCommandBuilder.MapProcessedCommand cmd;
    private final boolean onlyAtCompletion;
    private final boolean checkForRequired;
    private final boolean optimizeRetrieval;

    public AbstractDynamicCommand(PmSession pmSession, boolean optimizeRetrieval) {
        this.pmSession = pmSession;
        this.onlyAtCompletion = optimizeRetrieval;
        this.checkForRequired = !optimizeRetrieval;
        this.optimizeRetrieval = optimizeRetrieval;
    }

    protected abstract String getName();

    protected abstract String getDescription();

    protected abstract List<DynamicOption> getDynamicOptions(State var1) throws Exception;

    protected abstract void runCommand(PmCommandInvocation var1, Map<String, String> var2) throws CommandExecutionException;

    protected abstract List<ProcessedOption> getStaticOptions() throws OptionParserException;

    protected abstract PmCommandActivator getActivator();

    public abstract CommandDomain getDomain();

    public CommandContainer createCommand() throws CommandLineParserException {
        this.cmd = this.buildCommand();
        AeshCommandContainer container = new AeshCommandContainer(new AeshCommandLineParser<MapCommand>(this.cmd));
        return container;
    }

    @Override
    public final boolean checkForRequiredOptions(ParsedLine pl) {
        return this.checkForRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(PmCommandInvocation session) throws CommandException {
        try {
            session.getPmSession().commandStart(session);
            this.validateOptions(session);
            Map<String, String> options = this.getOptions();
            this.runCommand(session, options);
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        catch (Throwable t) {
            PmSessionCommand.handleException(session, t);
            CommandResult commandResult = CommandResult.FAILURE;
            return commandResult;
        }
        finally {
            session.getPmSession().commandEnd(session);
        }
    }

    protected String getArgumentValue() {
        return this.cmd.getArgument().getValue();
    }

    protected String getOptionValue(String name) {
        for (ProcessedOption opt : this.cmd.getOptions(false)) {
            if (!opt.name().equals(name)) continue;
            return opt.getValue();
        }
        return null;
    }

    protected List<String> getArgumentsValues() {
        return this.cmd.getArguments().getValues();
    }

    private String rename(String name, List<DynamicOption> options) {
        throw new RuntimeException("TODO Must rename " + name);
    }

    private MapProcessedCommandBuilder.MapProcessedCommand buildCommand() throws CommandLineParserException {
        MapProcessedCommandBuilder builder = new MapProcessedCommandBuilder();
        builder.command(this);
        builder.lookupAtCompletionOnly(this.onlyAtCompletion);
        builder.name(this.getName());
        builder.activator(this.getActivator());
        List<ProcessedOption> otherOptions = this.getStaticOptions();
        for (ProcessedOption o : otherOptions) {
            this.staticOptions.add(o.name());
            if (o.name().equals(ARGUMENT_NAME)) {
                if (o.hasMultipleValues()) {
                    builder.arguments(o);
                    continue;
                }
                builder.argument(o);
                continue;
            }
            builder.addOption(o);
        }
        builder.description(this.getDescription());
        builder.optionProvider(new DynamicOptionsProvider());
        return builder.create();
    }

    private void validateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        Set<String> providedOptions = this.getValues().keySet();
        List<ProcessedOption> sOptions = this.cmd.getOptions(false);
        if (this.optimizeRetrieval) {
            for (String o : providedOptions) {
                for (ProcessedOption opt : sOptions) {
                    if (!opt.name().equals(o)) continue;
                    String val = (String)this.getValue(opt.name());
                    if (!opt.hasValue() || val != null && !val.isEmpty()) continue;
                    throw new CommandExecutionException("Option --" + opt.name() + " was specified, but no value was given");
                }
            }
            for (ProcessedOption opt : sOptions) {
                if (!opt.isRequired() || providedOptions.contains(opt.name())) continue;
                throw new CommandExecutionException("Option --" + opt.name() + " is required for this command.");
            }
        } else {
            List<ProcessedOption> dOptions = this.cmd.getOptions(true);
            for (String o : providedOptions) {
                boolean found = false;
                if (ARGUMENT_NAME.equals(o)) continue;
                for (ProcessedOption opt : sOptions) {
                    if (!opt.name().equals(o)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                for (ProcessedOption opt : dOptions) {
                    if (!opt.name().equals(o)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new CommandExecutionException("Unknown option --" + o);
            }
        }
        this.doValidateOptions(invoc);
    }

    protected abstract void doValidateOptions(PmCommandInvocation var1) throws CommandExecutionException;

    protected abstract boolean canComplete(PmSession var1);

    private Map<String, String> getOptions() throws CommandException {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String m : this.getValues().keySet()) {
            if (m == null) {
                throw new CommandException("Invalid null option");
            }
            if (this.staticOptions.contains(m)) continue;
            options.put(m, (String)this.getValue(m));
        }
        return options;
    }

    private class DynamicOptionsProvider
    implements MapProcessedCommandBuilder.ProcessedOptionProvider {
        private DynamicOptionsProvider() {
        }

        @Override
        public List<ProcessedOption> getOptions(List<ProcessedOption> currentOptions) {
            if (!AbstractDynamicCommand.this.canComplete(AbstractDynamicCommand.this.pmSession)) {
                return Collections.emptyList();
            }
            try {
                ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
                List<DynamicOption> parameters = AbstractDynamicCommand.this.getDynamicOptions(AbstractDynamicCommand.this.pmSession.getState());
                for (DynamicOption opt : parameters) {
                    if (currentOptions != null) {
                        ProcessedOption found = null;
                        for (ProcessedOption option : currentOptions) {
                            if (!option.name().equals(opt.getName())) continue;
                            found = option;
                            break;
                        }
                        if (found != null) {
                            options.add(found);
                            continue;
                        }
                    }
                    ProcessedOptionBuilder builder = ProcessedOptionBuilder.builder();
                    if (AbstractDynamicCommand.this.staticOptions.contains(opt.getName())) {
                        AbstractDynamicCommand.this.renamedOptions.put(AbstractDynamicCommand.this.rename(opt.getName(), parameters), opt.getName());
                    }
                    builder.name(opt.getName());
                    builder.type(String.class);
                    builder.optionType(OptionType.NORMAL);
                    builder.required(opt.isRequired());
                    if (opt.getDefaultValue() != null) {
                        builder.addDefaultValue(opt.getDefaultValue());
                    }
                    options.add(builder.build());
                }
                return options;
            }
            catch (Exception ex) {
                CliLogging.log.errorf("Error retrieving dynamic options: {0}", (Object)ex.getLocalizedMessage());
                return Collections.emptyList();
            }
        }
    }

    public class DynamicOption {
        private final String name;
        private final boolean required;
        private String defaultValue;

        public DynamicOption(String name, boolean required) {
            this.name = name;
            this.required = required;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

