/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.spec.ConfigLayerDependency;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.universe.FeaturePackLocation;

public class LayersConfigBuilder {
    private final String[] layers;
    private final String config;
    private final String model;
    private final FeaturePackLocation loc;

    LayersConfigBuilder(PmSession session, String[] layers, String model, String config, FeaturePackLocation loc) throws ProvisioningException, IOException {
        this.layers = layers;
        this.loc = loc;
        Map<String, Map<String, Set<String>>> layersMap = LayersConfigBuilder.getAllLayers(session, loc, false);
        this.model = LayersConfigBuilder.getModel(model, layersMap);
        if (this.model == null) {
            throw new ProvisioningException(CliErrors.noLayersForModel(model));
        }
        Map<String, Set<String>> map = layersMap.get(this.model);
        if (map == null) {
            throw new ProvisioningException(CliErrors.noLayersForModel(this.model));
        }
        Set<String> actualLayers = map.keySet();
        for (String l : layers) {
            if (actualLayers.contains(l)) continue;
            throw new ProvisioningException(CliErrors.unknownLayer(l));
        }
        this.config = config == null ? this.model + ".xml" : config;
    }

    private static String getModel(String model, Map<String, Map<String, Set<String>>> layersMap) throws ProvisioningException {
        if (model == null) {
            if (layersMap.isEmpty()) {
                throw new ProvisioningException(CliErrors.noLayers());
            }
            if (layersMap.size() != 1) {
                throw new ProvisioningException(CliErrors.tooMuchModels());
            }
            model = layersMap.keySet().iterator().next();
        }
        return model;
    }

    public static Set<String> getLayerNames(PmSession session, String model, FeaturePackLocation loc, Set<String> noDependencies) throws ProvisioningException, IOException {
        Set<String> names;
        Map<String, Map<String, Set<String>>> layersMap = LayersConfigBuilder.getAllLayers(session, loc, true);
        Map<String, Set<String>> layers = layersMap.get(model = LayersConfigBuilder.getModel(model, layersMap));
        if (layers != null) {
            names = new HashSet();
            HashSet<String> allDependencies = new HashSet<String>();
            for (String string : noDependencies) {
                LayersConfigBuilder.getDependencies(string, allDependencies, layers);
            }
            for (Map.Entry entry : layers.entrySet()) {
                if (allDependencies.contains(entry.getKey()) && !noDependencies.contains(entry.getKey())) continue;
                names.add((String)entry.getKey());
            }
        } else {
            names = Collections.emptySet();
        }
        return names;
    }

    private static void getDependencies(String name, Set<String> set, Map<String, Set<String>> all) {
        Set<String> deps = all.get(name);
        if (deps != null) {
            set.addAll(deps);
            for (String n : deps) {
                LayersConfigBuilder.getDependencies(n, set, all);
            }
        }
    }

    public static Map<String, Map<String, Set<String>>> getAllLayers(ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        return LayersConfigBuilder.getAllLayers(pLayout, true);
    }

    private static Map<String, Map<String, Set<String>>> getAllLayers(PmSession session, FeaturePackLocation loc, boolean includeDependencies) throws ProvisioningException, IOException {
        ProvisioningConfig pConfig = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.builder(loc).build())).build();
        try (ProvisioningLayout<FeaturePackLayout> layout = session.getLayoutFactory().newConfigLayout(pConfig);){
            Map<String, Map<String, Set<String>>> map = LayersConfigBuilder.getAllLayers(layout, includeDependencies);
            return map;
        }
    }

    private static Map<String, Map<String, Set<String>>> getAllLayers(ProvisioningLayout<FeaturePackLayout> pLayout, boolean includeDependencies) throws ProvisioningException, IOException {
        HashMap<String, Map<String, Set<String>>> layersMap = new HashMap<String, Map<String, Set<String>>>();
        for (FeaturePackLayout fp : pLayout.getOrderedFeaturePacks()) {
            for (ConfigId layer : fp.loadLayers()) {
                Set existingDependencies;
                String model = layer.getModel();
                HashMap names = (HashMap)layersMap.get(model);
                if (names == null) {
                    names = new HashMap();
                    layersMap.put(model, names);
                }
                Set<String> dependencies = new TreeSet();
                if (includeDependencies) {
                    ConfigLayerSpec spec = fp.loadConfigLayerSpec(model, layer.getName());
                    for (ConfigLayerDependency dep : spec.getLayerDeps()) {
                        dependencies.add(dep.getName());
                    }
                }
                if ((existingDependencies = (Set)names.get(layer.getName())) != null) {
                    existingDependencies.addAll(dependencies);
                    dependencies = existingDependencies;
                }
                names.put(layer.getName(), dependencies);
            }
        }
        return layersMap;
    }

    ProvisioningConfig build() throws ProvisioningException, IOException {
        ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
        ConfigModel.Builder configBuilder = ConfigModel.builder(this.model, this.config);
        for (String layer : this.layers) {
            configBuilder.includeLayer(layer);
        }
        builder.addConfig(configBuilder.build());
        builder.addFeaturePackDep(((FeaturePackConfig.Builder)FeaturePackConfig.builder(this.loc).setInheritConfigs(false)).setInheritPackages(false).build());
        return builder.build();
    }
}

