/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.ConfigXmlParser10;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.xml.XmlParsers;
import org.jboss.galleon.xml.util.FormattingXmlStreamWriter;

public class Configuration
implements MavenConfig.MavenChangeListener {
    public static final long CACHE_PERIOD = 2592000000L;
    private static final String GALLON_DIR_NAME = ".galleon-cli";
    private static final String CONFIG_FILE_NAME = "cli-config";
    private static final String LAYOUT_DIR_NAME = "layout";
    private static final String LAYOUT_CONTENT_FILE_NAME = "layout.properties";
    private static final String CACHE_DIR_NAME = "cache";
    private static final String HISTORY_FILE_NAME = "cli-history";
    private final Path cacheDir;
    private final Path layoutCacheDir;
    private final Path layoutContentFile;
    private final File historyFile;
    private final MavenConfig maven;

    private Configuration() throws ProvisioningException {
        Path galleonDir = Configuration.getConfigDirectory();
        if (Files.exists(galleonDir, new LinkOption[0]) && !Files.isDirectory(galleonDir, new LinkOption[0])) {
            throw new ProvisioningException(CliErrors.invalidConfigDirectory(galleonDir));
        }
        this.historyFile = galleonDir.resolve(HISTORY_FILE_NAME).toFile();
        this.cacheDir = galleonDir.resolve(CACHE_DIR_NAME);
        this.layoutCacheDir = this.cacheDir.resolve(LAYOUT_DIR_NAME);
        this.layoutContentFile = this.cacheDir.resolve(LAYOUT_CONTENT_FILE_NAME);
        this.maven = new MavenConfig();
        this.maven.addListener(this);
    }

    public MavenConfig getMavenConfig() {
        return this.maven;
    }

    public Path getLayoutCache() {
        return this.layoutCacheDir;
    }

    public Properties getLayoutCacheContent() throws IOException {
        Properties props = new Properties();
        if (Files.exists(this.layoutContentFile, new LinkOption[0])) {
            try (FileInputStream stream = new FileInputStream(this.layoutContentFile.toFile());){
                props.load(stream);
            }
        }
        return props;
    }

    public void storeLayoutCacheContent(Properties props) throws IOException {
        if (props.isEmpty()) {
            Files.deleteIfExists(this.layoutContentFile);
            return;
        }
        if (!Files.exists(this.layoutContentFile, new LinkOption[0])) {
            Files.createFile(this.layoutContentFile, new FileAttribute[0]);
        }
        try (FileOutputStream stream = new FileOutputStream(this.layoutContentFile.toFile());){
            props.store(stream, null);
        }
    }

    @Override
    public void configurationChanged(MavenConfig config) throws XMLStreamException, IOException {
        this.needRewrite();
    }

    public void needRewrite() throws XMLStreamException, IOException {
        Path configFile = Configuration.getConfigFile();
        Files.deleteIfExists(configFile);
        try (BufferedWriter bw = Files.newBufferedWriter(configFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
             FormattingXmlStreamWriter writer = new FormattingXmlStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(bw));){
            writer.writeStartDocument();
            writer.writeStartElement(ConfigXmlParser10.ROOT_1_0.getLocalPart());
            writer.writeDefaultNamespace("urn:jboss:galleon:cli:1.0");
            this.maven.write(writer);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }

    public File getHistoryFile() {
        return this.historyFile;
    }

    public static Configuration parse() throws ProvisioningException {
        return Configuration.parse(Collections.emptyMap());
    }

    public static Configuration parse(Map<String, String> options) throws ProvisioningException {
        Configuration config = new Configuration();
        Path configFile = Configuration.getConfigFile();
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                XmlParsers.parse(reader, config);
            }
            catch (IOException | XMLStreamException e) {
                throw new ProvisioningException(Errors.parseXml(configFile), e);
            }
        }
        return config;
    }

    private static Path getConfigDirectory() {
        Path galleonDir = new File(System.getProperty("user.home") + File.separator + GALLON_DIR_NAME).toPath();
        if (!Files.exists(galleonDir, new LinkOption[0])) {
            galleonDir.toFile().mkdir();
        }
        return galleonDir;
    }

    private static Path getConfigFile() {
        return Configuration.getConfigDirectory().resolve(CONFIG_FILE_NAME);
    }

    public void clearLayoutCache() throws IOException {
        try {
            IoUtils.recursiveDelete(this.getLayoutCache());
        }
        finally {
            Files.deleteIfExists(this.layoutContentFile);
        }
    }

    static {
        new ConfigXmlParser10().plugin(XmlParsers.getInstance());
    }
}

