/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.progresstracking;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.progresstracking.TrackedProcessor;

public class DefaultProgressTracker<T>
implements ProgressTracker<T> {
    private final ProgressCallback<T> callback;
    private long totalVolume;
    private long pulseAtVolume;
    private long pulsePct;
    private long minPulseInterval;
    private long maxPulseInterval;
    private long processedSincePulse;
    private long processedVolume;
    private long lastPulseNano;
    private long lastPulseInterval;
    private T item;

    public DefaultProgressTracker(ProgressCallback<T> callback) {
        this.callback = callback;
        this.pulsePct = callback.getProgressPulsePct();
        if (this.pulsePct > 100L) {
            throw new IllegalArgumentException("The argument was not expected to be bigger than 100 but was " + this.pulsePct);
        }
        this.setMinPulseMs(callback.getMinPulseIntervalMs());
        this.setMaxPulseMs(callback.getMaxPulseIntervalMs());
    }

    private DefaultProgressTracker<T> setMinPulseMs(long minPulseIntervalMs) {
        this.minPulseInterval = minPulseIntervalMs <= 0L ? minPulseIntervalMs : minPulseIntervalMs * 1000000L;
        return this;
    }

    private DefaultProgressTracker<T> setMaxPulseMs(long maxPulseIntervalMs) {
        this.maxPulseInterval = maxPulseIntervalMs <= 0L ? maxPulseIntervalMs : maxPulseIntervalMs * 1000000L;
        return this;
    }

    public static <T> void process(DefaultProgressTracker<T> tracker, TrackedProcessor processor, Collection<T> col) throws Exception {
        tracker.starting(col.size());
        DefaultProgressTracker.doProcess(tracker, processor, col);
    }

    public static <T> void process(DefaultProgressTracker<T> tracker, TrackedProcessor processor, T[] arr) throws Exception {
        tracker.starting(arr.length);
        DefaultProgressTracker.doProcess(tracker, processor, Arrays.asList(arr));
    }

    public static <T> void process(DefaultProgressTracker<T> tracker, TrackedProcessor processor, Iterable<T> i) throws Exception {
        tracker.starting(-1L);
        DefaultProgressTracker.doProcess(tracker, processor, i);
    }

    private static <T> void doProcess(ProgressTracker<T> tracker, TrackedProcessor processor, Iterable<T> i) throws Exception {
        for (T o : i) {
            tracker.processing(o);
            processor.process(o);
            tracker.processed(o);
        }
        tracker.complete();
    }

    @Override
    public void starting(long totalVolume) {
        this.totalVolume = totalVolume;
        if (totalVolume >= 0L && this.pulsePct > 0L) {
            double pulseAtVolume = (double)this.pulsePct * (double)totalVolume / 100.0;
            this.pulseAtVolume = (int)pulseAtVolume;
            if (pulseAtVolume != (double)this.pulseAtVolume) {
                ++this.pulseAtVolume;
                this.pulsePct = Math.round(100.0 / (double)totalVolume * (double)this.pulseAtVolume);
            }
        } else {
            this.pulseAtVolume = this.pulsePct < 0L ? this.pulsePct : 1L;
        }
        this.processedSincePulse = 0L;
        this.processedVolume = 0L;
        this.callback.starting(this);
        this.lastPulseInterval = -1L;
        this.lastPulseNano = System.nanoTime();
    }

    @Override
    public void processing(T item) {
        this.item = item;
        this.callback.processing(this);
    }

    @Override
    public void processed(T item) {
        long curTime;
        if (this.pulseAtVolume < 0L || this.totalVolume >= 0L && this.processedVolume >= this.totalVolume) {
            return;
        }
        ++this.processedVolume;
        this.callback.processed(this);
        if (++this.processedSincePulse >= this.pulseAtVolume) {
            do {
                this.processedSincePulse -= this.pulseAtVolume;
                if (this.minPulseInterval <= 0L) {
                    this.callback.pulse(this);
                    continue;
                }
                long curTime2 = System.nanoTime();
                if (curTime2 - this.lastPulseNano < this.minPulseInterval) continue;
                this.lastPulseInterval = curTime2 - this.lastPulseNano;
                this.callback.pulse(this);
                this.lastPulseNano = curTime2;
            } while (this.processedSincePulse >= this.pulseAtVolume);
            return;
        }
        if (this.maxPulseInterval > 0L && (curTime = System.nanoTime()) - this.lastPulseNano >= this.maxPulseInterval) {
            this.lastPulseInterval = curTime - this.lastPulseNano;
            this.callback.pulse(this);
            this.lastPulseNano = curTime;
            this.processedSincePulse = 0L;
        }
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public void complete() {
        if (this.lastPulseInterval > 0L && this.processedSincePulse > 0L) {
            this.callback.pulse(this);
        }
        this.callback.complete(this);
    }

    @Override
    public long getTotalVolume() {
        return this.totalVolume;
    }

    @Override
    public double getProgress() {
        return this.totalVolume < 0L ? 0.0 : (double)this.processedVolume * 100.0 / (double)this.totalVolume;
    }

    @Override
    public long getProcessedVolume() {
        return this.processedVolume;
    }

    @Override
    public long getLastPulseInterval() {
        return this.lastPulseInterval < 0L ? this.lastPulseInterval : this.lastPulseInterval / 1000000L;
    }

    public static void main(String[] args) throws Exception {
        DefaultProgressTracker<Long> tracker = new DefaultProgressTracker<Long>(new ProgressCallback<Long>(){

            @Override
            public long getProgressPulsePct() {
                return 10L;
            }

            @Override
            public long getMinPulseIntervalMs() {
                return 500L;
            }

            @Override
            public long getMaxPulseIntervalMs() {
                return 500L;
            }

            @Override
            public void starting(ProgressTracker<Long> tracker) {
                System.out.println("Processing");
            }

            @Override
            public void processing(ProgressTracker<Long> tracker) {
            }

            @Override
            public void pulse(ProgressTracker<Long> tracker) {
                System.out.println(String.format("  %s of %s (%s%%), %sms", tracker.getProcessedVolume(), tracker.getTotalVolume(), Math.round(tracker.getProgress()), tracker.getLastPulseInterval()));
            }

            @Override
            public void complete(ProgressTracker<Long> tracker) {
                System.out.println("  Complete!");
            }
        });
        long totalVolume = 50L;
        DefaultProgressTracker.trackVolume(50L, tracker);
        DefaultProgressTracker.trackFlow(50L, tracker);
    }

    private static void trackVolume(long totalVolume, DefaultProgressTracker<Long> tracker) throws InterruptedException {
        System.out.println();
        System.out.println("total volume " + tracker.totalVolume);
        System.out.println("actual pulse " + tracker.pulsePct);
        System.out.println("pulse volume " + tracker.pulseAtVolume);
        System.out.println("min pulse ms " + tracker.minPulseInterval / 1000000L);
        System.out.println();
        tracker.starting(totalVolume);
        int i = 0;
        while (true) {
            tracker.processing(Long.valueOf(i));
            tracker.processed(Long.valueOf(i));
            if ((long)(++i) >= totalVolume) break;
            Thread.currentThread();
            Thread.sleep(500 - i * 10);
        }
        tracker.complete();
    }

    private static void trackFlow(long totalVolume, DefaultProgressTracker<Long> tracker) throws InterruptedException {
        System.out.println();
        System.out.println("total volume " + tracker.totalVolume);
        System.out.println("actual pulse " + tracker.pulsePct);
        System.out.println("pulse volume " + tracker.pulseAtVolume);
        System.out.println("min pulse ms " + tracker.minPulseInterval / 1000000L);
        System.out.println("");
        tracker.starting(totalVolume);
        int i = 0;
        while (true) {
            tracker.processing(Long.valueOf(i));
            tracker.processed(Long.valueOf(i));
            if ((long)(++i) >= totalVolume) break;
            Thread.currentThread();
            Thread.sleep(500 - i * 10);
        }
        tracker.complete();
    }
}

