/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenLatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRangeParser;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;

public class SimplisticMavenRepoManager
implements MavenRepoManager {
    public static final String REPOSITORY_ID = "repository.maven";
    public static final String SIMPLISTIC_MAVEN_REPO_HOME = "simplistic.maven.repo.home";
    private static final MavenArtifactVersionRangeParser versionRangeParser = new MavenArtifactVersionRangeParser();
    private final Path repoHome;
    private final MavenRepoManager fallback;

    public static SimplisticMavenRepoManager getInstance() {
        String prop = System.getProperty(SIMPLISTIC_MAVEN_REPO_HOME);
        return SimplisticMavenRepoManager.getInstance(prop == null ? Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2") : Paths.get(prop, new String[0]));
    }

    public static SimplisticMavenRepoManager getInstance(Path repoHome) {
        return new SimplisticMavenRepoManager(repoHome, null);
    }

    public static SimplisticMavenRepoManager getInstance(Path repoHome, MavenRepoManager fallback) {
        return new SimplisticMavenRepoManager(repoHome, fallback);
    }

    private SimplisticMavenRepoManager(Path repoHome, MavenRepoManager fallback) {
        this.repoHome = repoHome;
        this.fallback = fallback;
    }

    @Override
    public String getRepositoryId() {
        return REPOSITORY_ID;
    }

    @Override
    public Path resolve(String location) throws ProvisioningException {
        return MavenRepoManager.super.resolve(location);
    }

    @Override
    public void resolve(MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = null;
        try {
            path = this.getArtifactPath(artifact);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
            }
            artifact.setPath(path);
            return;
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            try {
                this.fallback.resolve(artifact);
            }
            catch (MavenUniverseException e2) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path), e2);
            }
            return;
        }
    }

    @Override
    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = null;
        try {
            path = this.resolveLatestVersionDir(artifact, lowestQualifier);
            artifact.setVersion(path.getFileName().toString());
            path = path.resolve(artifact.getArtifactFileName());
            if (!Files.exists(path, new LinkOption[0])) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
            }
            artifact.setPath(path);
            return;
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            this.fallback.resolveLatestVersion(artifact, lowestQualifier);
            return;
        }
    }

    private String pathDoesNotExist(MavenArtifact artifact, Path path) throws MavenUniverseException {
        return "Failed to resolve " + artifact.getCoordsAsString() + ": " + path + " does not exist";
    }

    @Override
    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.resolveLatestVersionDir(artifact, lowestQualifier).getFileName().toString();
    }

    @Override
    public void install(MavenArtifact artifact, Path path) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already associated with a path " + path);
        }
        Path targetPath = this.getArtifactPath(artifact);
        try {
            IoUtils.copy(path, targetPath);
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to install " + artifact.getCoordsAsString(), e);
        }
        artifact.setPath(targetPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path resolveLatestVersionDir(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        String part;
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        if (artifact.getArtifactId() == null) {
            MavenErrors.missingArtifactId();
        }
        if (artifact.getVersionRange() == null) {
            throw new MavenUniverseException("Version range is missing for " + artifact.getCoordsAsString());
        }
        Path artifactDir = this.repoHome;
        String[] stringArray = groupParts = artifact.getGroupId().split("\\.");
        int n = stringArray.length;
        for (int n2 = 0; n2 < n; artifactDir = artifactDir.resolve(part), ++n2) {
            part = stringArray[n2];
        }
        if (!Files.exists(artifactDir = artifactDir.resolve(artifact.getArtifactId()), new LinkOption[0])) {
            throw MavenErrors.artifactNotFound(artifact, this.repoHome);
        }
        final MavenArtifactVersionRange range = versionRangeParser.parseRange(artifact.getVersionRange());
        if (lowestQualifier == null) {
            lowestQualifier = "";
        }
        try (final DirectoryStream<Path> stream = Files.newDirectoryStream(artifactDir);){
            Iterable<String> versions = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        final Iterator<Path> i;
                        Path nextPath;
                        {
                            this.i = stream.iterator();
                            this.nextPath = this.toNext(range);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextPath != null;
                        }

                        @Override
                        public String next() {
                            if (this.nextPath != null) {
                                String s = this.nextPath.getFileName().toString();
                                this.nextPath = this.toNext(range);
                                return s;
                            }
                            throw new NoSuchElementException();
                        }

                        private Path toNext(MavenArtifactVersionRange range) {
                            while (this.i.hasNext()) {
                                Path path = this.i.next();
                                MavenArtifactVersion next = new MavenArtifactVersion(path.getFileName().toString());
                                if (!range.includesVersion(next)) continue;
                                return path;
                            }
                            return null;
                        }
                    };
                }
            };
            MavenArtifactVersion latest = MavenArtifactVersion.getLatest(versions, lowestQualifier);
            if (latest == null) {
                throw new MavenLatestVersionNotAvailableException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()));
            }
            Path path = artifactDir.resolve(latest.toString());
            return path;
        }
        catch (MavenUniverseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MavenUniverseException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()), e);
        }
    }

    private Path getArtifactPath(MavenArtifact artifact) throws MavenUniverseException {
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        Path p = this.repoHome;
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            p = p.resolve(part);
        }
        String artifactFileName = artifact.getArtifactFileName();
        return p.resolve(artifact.getArtifactId()).resolve(artifact.getVersion()).resolve(artifactFileName);
    }

    @Override
    public boolean isResolved(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLatestVersionResolved(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLatestVersion(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> getAllVersions(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

