/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser10;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class FeaturePackXmlParser10
implements PlugableXmlParser<FeaturePackSpec.Builder> {
    public static final String NAMESPACE_1_0 = "urn:jboss:galleon:feature-pack:1.0";
    public static final QName ROOT_1_0 = new QName("urn:jboss:galleon:feature-pack:1.0", Element.FEATURE_PACK.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, FeaturePackSpec.Builder fpBuilder) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID);
        block17: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            required.remove(attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = reader.getAttributeValue(i);
                    continue block17;
                }
                case ARTIFACT_ID: {
                    artifactId = reader.getAttributeValue(i);
                    continue block17;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block17;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        fpBuilder.setFPID(LegacyGalleon1Universe.toFpl(groupId, artifactId, version).getFPID());
        block18: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case DEPENDENCIES: {
                            FeaturePackXmlParser10.readFeaturePackDeps(reader, fpBuilder);
                            continue block18;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser10.parseDefaultConfigs(reader, fpBuilder);
                            continue block18;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                fpBuilder.addConfig(config.build());
                                continue block18;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse config element", reader.getLocation(), e);
                            }
                        }
                        case DEFAULT_PACKAGES: {
                            this.readDefaultPackages(reader, fpBuilder);
                            continue block18;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readFeaturePackDeps(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        boolean hasChildren = false;
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!hasChildren) {
                        throw ParsingUtils.expectedAtLeastOneChild(reader, Element.DEPENDENCIES, Element.DEPENDENCY);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case DEPENDENCY: {
                            ProvisioningXmlParser10.readFeaturePackDep(reader, fpBuilder);
                            hasChildren = true;
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readDefaultPackages(XMLExtendedStreamReader reader, FeaturePackSpec.Builder fpBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        boolean hasChildren = false;
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!hasChildren) {
                        throw ParsingUtils.expectedAtLeastOneChild(reader, Element.DEFAULT_PACKAGES, Element.PACKAGE);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PACKAGE: {
                            fpBuilder.addDefaultPackage(this.parseName(reader));
                            hasChildren = true;
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private String parseName(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean parsedTarget = false;
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case NAME: {
                    path = reader.getAttributeValue(i);
                    parsedTarget = true;
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!parsedTarget) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        return path;
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT_ID("artifactId"),
        GROUP_ID("groupId"),
        CLASSIFIER("classifier"),
        COORDS("coords"),
        EXTENSION("extension"),
        INHERIT("inherit"),
        MODEL("model"),
        NAMED_CONFIGS_ONLY("named-configs-only"),
        VERSION("version"),
        NAME("name"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<String, Attribute>(11);
            attributes.put(ARTIFACT_ID.getLocalName(), ARTIFACT_ID);
            attributes.put(GROUP_ID.getLocalName(), GROUP_ID);
            attributes.put(CLASSIFIER.getLocalName(), CLASSIFIER);
            attributes.put(COORDS.getLocalName(), COORDS);
            attributes.put(EXTENSION.getLocalName(), EXTENSION);
            attributes.put(INHERIT.getLocalName(), INHERIT);
            attributes.put(MODEL.getLocalName(), MODEL);
            attributes.put(NAME.getLocalName(), NAME);
            attributes.put(NAMED_CONFIGS_ONLY.getLocalName(), NAMED_CONFIGS_ONLY);
            attributes.put(VERSION.getLocalName(), VERSION);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        EXCLUDE("exclude"),
        FEATURE_PACK("feature-pack"),
        INCLUDE("include"),
        NAME("name"),
        PACKAGES("packages"),
        PACKAGE("package"),
        UNKNOWN(null);

        private static final Map<String, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:feature-pack:1.0";

        static Element of(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return FeaturePackXmlParser10.NAMESPACE_1_0;
        }

        static {
            elements = new HashMap<String, Element>(12);
            elements.put(Element.CONFIG.name, CONFIG);
            elements.put(Element.DEFAULT_CONFIGS.name, DEFAULT_CONFIGS);
            elements.put(Element.DEFAULT_PACKAGES.name, DEFAULT_PACKAGES);
            elements.put(Element.DEPENDENCIES.name, DEPENDENCIES);
            elements.put(Element.DEPENDENCY.name, DEPENDENCY);
            elements.put(Element.EXCLUDE.name, EXCLUDE);
            elements.put(Element.FEATURE_PACK.name, FEATURE_PACK);
            elements.put(Element.INCLUDE.name, INCLUDE);
            elements.put(Element.NAME.name, NAME);
            elements.put(Element.PACKAGES.name, PACKAGES);
            elements.put(Element.PACKAGE.name, PACKAGE);
            elements.put(null, UNKNOWN);
        }
    }
}

