/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ProvisioningXmlParser10
implements PlugableXmlParser<ProvisioningConfig.Builder> {
    public static final String NAMESPACE_1_0 = "urn:jboss:galleon:provisioning:1.0";
    public static final QName ROOT_1_0 = new QName("urn:jboss:galleon:provisioning:1.0", Element.INSTALLATION.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisioningConfig.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        boolean hasFp = false;
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!hasFp) {
                        throw ParsingUtils.expectedAtLeastOneChild(reader, Element.INSTALLATION, Element.FEATURE_PACK);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case FEATURE_PACK: {
                            hasFp = true;
                            ProvisioningXmlParser10.readFeaturePackDep(reader, builder);
                            continue block11;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser10.parseDefaultConfigs(reader, builder);
                            continue block11;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                builder.addConfig(config.build());
                                continue block11;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse config element", reader.getLocation(), e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    static void readFeaturePackDep(XMLExtendedStreamReader reader, FeaturePackDepsConfigBuilder<?> fpBuilder) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID);
        block21: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            required.remove(attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = reader.getAttributeValue(i);
                    continue block21;
                }
                case ARTIFACT_ID: {
                    artifactId = reader.getAttributeValue(i);
                    continue block21;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block21;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        String origin = null;
        FeaturePackConfig.Builder depBuilder = FeaturePackConfig.builder(LegacyGalleon1Universe.toFpl(groupId, artifactId, version));
        block22: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        fpBuilder.addFeaturePackDep(origin, depBuilder.build());
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to add feature-pack configuration dependency", e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PACKAGES: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages(reader, depBuilder);
                                continue block22;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse " + Element.PACKAGES.getLocalName() + ": " + e.getLocalizedMessage(), reader.getLocation(), e);
                            }
                        }
                        case ORIGIN: {
                            origin = reader.getElementText();
                            continue block22;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser10.parseDefaultConfigs(reader, depBuilder);
                            continue block22;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig(reader, config);
                            try {
                                depBuilder.addConfig(config.build());
                                continue block22;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse config element", reader.getLocation(), e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    public static void parseDefaultConfigs(XMLExtendedStreamReader reader, ConfigCustomizationsBuilder<?> fpBuilder) throws XMLStreamException {
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case INHERIT: {
                    fpBuilder.setInheritConfigs(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block12;
                }
                case INHERIT_UNNAMED_MODELS: {
                    fpBuilder.setInheritModelOnlyConfigs(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getLocalName());
                    switch (element) {
                        case INCLUDE: {
                            ProvisioningXmlParser10.parseConfigModelRef(reader, fpBuilder, true);
                            continue block13;
                        }
                        case EXCLUDE: {
                            ProvisioningXmlParser10.parseConfigModelRef(reader, fpBuilder, false);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void parseConfigModelRef(XMLExtendedStreamReader reader, ConfigCustomizationsBuilder<?> fpBuilder, boolean include) throws XMLStreamException {
        String name = null;
        String model = null;
        Boolean namedConfigsOnly = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case MODEL: {
                    model = reader.getAttributeValue(i);
                    continue block7;
                }
                case NAMED_MODELS_ONLY: {
                    namedConfigsOnly = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        try {
            if (include) {
                if (name == null) {
                    fpBuilder.includeConfigModel(model);
                } else {
                    fpBuilder.includeDefaultConfig(new ConfigId(model, name));
                }
            } else if (name == null) {
                if (namedConfigsOnly != null) {
                    fpBuilder.excludeConfigModel(model, namedConfigsOnly);
                } else {
                    fpBuilder.excludeConfigModel(model);
                }
            } else {
                fpBuilder.excludeDefaultConfig(model, name);
            }
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException(e);
        }
        ParsingUtils.parseNoContent(reader);
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT_ID("artifactId"),
        GROUP_ID("groupId"),
        INHERIT("inherit"),
        INHERIT_UNNAMED_MODELS("inherit-unnamed-models"),
        MODEL("model"),
        NAME("name"),
        NAMED_MODELS_ONLY("named-models-only"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<String, Attribute>(9);
            attributes.put(Attribute.ARTIFACT_ID.name, ARTIFACT_ID);
            attributes.put(Attribute.GROUP_ID.name, GROUP_ID);
            attributes.put(Attribute.INHERIT.name, INHERIT);
            attributes.put(Attribute.INHERIT_UNNAMED_MODELS.name, INHERIT_UNNAMED_MODELS);
            attributes.put(Attribute.MODEL.name, MODEL);
            attributes.put(Attribute.NAME.name, NAME);
            attributes.put(Attribute.NAMED_MODELS_ONLY.name, NAMED_MODELS_ONLY);
            attributes.put(Attribute.VERSION.name, VERSION);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        EXCLUDE("exclude"),
        FEATURE_PACK("feature-pack"),
        INCLUDE("include"),
        INSTALLATION("installation"),
        ORIGIN("origin"),
        PACKAGES("packages"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:provisioning:1.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ProvisioningXmlParser10.NAMESPACE_1_0;
        }

        public String toString() {
            return this.name;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(9);
            elementsByLocal.put(Element.CONFIG.name, CONFIG);
            elementsByLocal.put(Element.DEFAULT_CONFIGS.name, DEFAULT_CONFIGS);
            elementsByLocal.put(Element.EXCLUDE.name, EXCLUDE);
            elementsByLocal.put(Element.FEATURE_PACK.name, FEATURE_PACK);
            elementsByLocal.put(Element.INCLUDE.name, INCLUDE);
            elementsByLocal.put(Element.INSTALLATION.name, INSTALLATION);
            elementsByLocal.put(Element.ORIGIN.name, ORIGIN);
            elementsByLocal.put(Element.PACKAGES.name, PACKAGES);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

