/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CliMavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.util.PathsUtils;

public class UniverseManager
implements MavenConfig.MavenChangeListener {
    public static final String JBOSS_UNIVERSE_GROUP_ID = "org.jboss.universe";
    public static final String JBOSS_UNIVERSE_ARTIFACT_ID = "community-universe";
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thr = new Thread(r, "Galleon CLI universe initializer");
            thr.setDaemon(true);
            return thr;
        }
    });
    private MavenUniverse builtinUniverse;
    private final UniverseSpec builtinUniverseSpec;
    private final UniverseResolver universeResolver;
    private final PmSession pmSession;
    private final List<Future<?>> submited = new ArrayList();
    private volatile boolean closed;
    private boolean bckResolution = true;

    UniverseManager(PmSession pmSession, Configuration config, CliMavenArtifactRepositoryManager maven, UniverseResolver universeResolver, UniverseSpec builtin) throws ProvisioningException {
        this.pmSession = pmSession;
        config.getMavenConfig().addListener(this);
        UniverseFactoryLoader.getInstance().addArtifactResolver(maven);
        this.universeResolver = universeResolver;
        this.builtinUniverseSpec = builtin == null ? new UniverseSpec("maven", "org.jboss.universe:community-universe") : builtin;
    }

    public void disableBackgroundResolution() {
        this.bckResolution = false;
    }

    synchronized void resolveBuiltinUniverse() {
        if (this.closed) {
            return;
        }
        Future<?> f = this.executorService.submit(() -> {
            UniverseManager universeManager = this;
            synchronized (universeManager) {
                if (this.closed) {
                    return;
                }
                try {
                    ArrayList<FeaturePackLocation> deps = new ArrayList<FeaturePackLocation>();
                    this.builtinUniverse = (MavenUniverse)this.universeResolver.getUniverse(this.builtinUniverseSpec);
                    if (this.closed) {
                        return;
                    }
                    for (Producer producer : this.builtinUniverse.getProducers()) {
                        if (this.closed) {
                            return;
                        }
                        for (Channel c : producer.getChannels()) {
                            if (this.closed) {
                                return;
                            }
                            FeaturePackLocation ploc = new FeaturePackLocation(this.builtinUniverseSpec, producer.getName(), c.getName(), null, null);
                            deps.add(ploc);
                        }
                    }
                }
                catch (Exception ex) {
                    CliLogging.exceptionResolvingBuiltinUniverse(ex);
                }
            }
        });
        this.submited.add(f);
    }

    synchronized void close() {
        this.closed = true;
        this.executorService.shutdownNow();
        boolean terminated = true;
        for (Future<?> f : this.submited) {
            if (f.isDone()) continue;
            terminated = false;
            break;
        }
        if (!terminated) {
            this.pmSession.println("Awaiting termination of background resolution...");
            try {
                this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                this.pmSession.println("Interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenUniverse getBuiltinUniverse() {
        UniverseManager universeManager = this;
        synchronized (universeManager) {
            return this.builtinUniverse;
        }
    }

    public UniverseSpec getBuiltinUniverseSpec() {
        return this.builtinUniverseSpec;
    }

    public synchronized Universe<?> getUniverse(UniverseSpec spec) throws ProvisioningException {
        return this.universeResolver.getUniverse(spec);
    }

    public synchronized Path resolve(FeaturePackLocation fpl) throws ProvisioningException {
        return this.universeResolver.resolve(fpl);
    }

    public synchronized boolean isResolved(FeaturePackLocation fpl) throws ProvisioningException {
        return this.universeResolver.isResolved(fpl);
    }

    public synchronized FeaturePackLocation resolveLatestBuild(FeaturePackLocation fpl) throws ProvisioningException {
        return this.universeResolver.resolveLatestBuild(fpl);
    }

    private ProvisioningManager getProvisioningManager(Path installation) throws ProvisioningException {
        if (installation == null) {
            throw new ProvisioningException(CliErrors.noDirectoryProvided());
        }
        if (!Files.exists(PathsUtils.getProvisioningXml(installation), new LinkOption[0])) {
            throw new ProvisioningException(CliErrors.notValidInstallation(installation));
        }
        ProvisioningManager mgr = this.pmSession.newProvisioningManager(installation, false);
        return mgr;
    }

    public void addUniverse(String name, String factory, String location) throws ProvisioningException, IOException {
        UniverseSpec u = new UniverseSpec(factory, location);
        this.pmSession.getState().addUniverse(this.pmSession, name, factory, location);
        this.resolveUniverse(u);
    }

    public void addUniverse(Path installation, String name, String factory, String location) throws ProvisioningException, IOException {
        UniverseSpec u = new UniverseSpec(factory, location);
        ProvisioningManager mgr = this.getProvisioningManager(installation);
        if (name != null) {
            mgr.addUniverse(name, u);
        } else {
            mgr.setDefaultUniverse(u);
        }
        this.resolveUniverse(u);
    }

    private void resolveUniverse(UniverseSpec u) throws ProvisioningException {
        Universe<?> universe = this.universeResolver.getUniverse(u);
        for (Producer p : universe.getProducers()) {
            for (Channel channel : p.getChannels()) {
            }
        }
    }

    public void removeUniverse(String name) throws ProvisioningException, IOException {
        this.pmSession.getState().removeUniverse(this.pmSession, name);
    }

    public void removeUniverse(Path installation, String name) throws ProvisioningException, IOException {
        ProvisioningManager mgr = this.getProvisioningManager(installation);
        mgr.removeUniverse(name);
    }

    public Set<String> getUniverseNames(Path installation) {
        if (this.pmSession.getState() != null) {
            return this.pmSession.getState().getConfig().getUniverseNamedSpecs().keySet();
        }
        try {
            ProvisioningManager mgr = this.getProvisioningManager(installation);
            return mgr.getProvisioningConfig().getUniverseNamedSpecs().keySet();
        }
        catch (ProvisioningException ex) {
            return Collections.emptySet();
        }
    }

    public UniverseSpec getDefaultUniverseSpec(Path installation) {
        UniverseSpec defaultUniverse = null;
        if (this.pmSession.getState() != null) {
            defaultUniverse = this.pmSession.getState().getConfig().getDefaultUniverse();
        } else {
            try {
                ProvisioningManager mgr = this.getProvisioningManager(installation);
                defaultUniverse = mgr.getProvisioningConfig().getDefaultUniverse();
            }
            catch (ProvisioningException provisioningException) {
                // empty catch block
            }
        }
        return defaultUniverse == null ? this.builtinUniverseSpec : defaultUniverse;
    }

    public String getUniverseName(Path installation, UniverseSpec u) {
        ProvisioningConfig config = null;
        if (this.pmSession.getState() != null) {
            config = this.pmSession.getState().getConfig();
        } else {
            try {
                config = this.getProvisioningManager(installation).getProvisioningConfig();
            }
            catch (ProvisioningException ex) {
                return null;
            }
        }
        for (Map.Entry<String, UniverseSpec> entry : config.getUniverseNamedSpecs().entrySet()) {
            if (!entry.getValue().equals(u)) continue;
            return entry.getKey();
        }
        return null;
    }

    public UniverseSpec getUniverseSpec(Path installation, String name) {
        ProvisioningConfig config;
        if (this.pmSession.getState() != null) {
            config = this.pmSession.getState().getConfig();
        } else {
            try {
                config = this.getProvisioningManager(installation).getProvisioningConfig();
            }
            catch (ProvisioningException ex) {
                return null;
            }
        }
        return config.getUniverseNamedSpecs().get(name);
    }

    @Override
    public void configurationChanged(MavenConfig config) throws XMLStreamException, IOException {
        if (this.bckResolution) {
            this.resolveBuiltinUniverse();
        }
    }

    public void visitAllUniverses(UniverseVisitor visitor, boolean allBuilds, Path installation) {
        try {
            UniverseManager.visit(visitor, this.getUniverse(this.builtinUniverseSpec), this.builtinUniverseSpec, allBuilds);
        }
        catch (ProvisioningException ex) {
            visitor.exception(this.builtinUniverseSpec, ex);
        }
        UniverseSpec defaultUniverse = this.getDefaultUniverseSpec(null);
        try {
            if (defaultUniverse != null && !this.builtinUniverseSpec.equals(defaultUniverse)) {
                UniverseManager.visit(visitor, this.getUniverse(defaultUniverse), defaultUniverse, allBuilds);
            }
        }
        catch (ProvisioningException ex) {
            visitor.exception(defaultUniverse, ex);
        }
        Set<String> universes = this.getUniverseNames(installation);
        for (String u : universes) {
            UniverseSpec universeSpec = this.getUniverseSpec(installation, u);
            try {
                UniverseManager.visit(visitor, this.getUniverse(universeSpec), universeSpec, allBuilds);
            }
            catch (ProvisioningException ex) {
                visitor.exception(universeSpec, ex);
            }
        }
    }

    public void visitUniverse(UniverseSpec universeSpec, UniverseVisitor visitor, boolean allBuilds) throws ProvisioningException {
        UniverseManager.visit(visitor, this.getUniverse(universeSpec), universeSpec, allBuilds);
    }

    private static void visit(UniverseVisitor visitor, Universe<?> universe, UniverseSpec universeSpec, boolean allBuilds) throws ProvisioningException {
        for (Producer producer : universe.getProducers()) {
            for (Channel channel : producer.getChannels()) {
                List<String> builds;
                if (allBuilds && (builds = UniverseManager.getAllBuilds(universeSpec, producer, channel)) != null && !builds.isEmpty()) {
                    for (String build : builds) {
                        visitor.visit(producer, new FeaturePackLocation(universeSpec, producer.getName(), channel.getName(), null, build));
                    }
                }
                for (String freq : producer.getFrequencies()) {
                    String build;
                    build = UniverseManager.getBuild(universeSpec, producer, channel, freq);
                    if (build == null) continue;
                    FeaturePackLocation loc = new FeaturePackLocation(universeSpec, producer.getName(), channel.getName(), freq, build);
                    visitor.visit(producer, loc);
                }
            }
        }
    }

    private static List<String> getAllBuilds(UniverseSpec spec, Producer<?> producer, Channel channel) {
        FeaturePackLocation loc = new FeaturePackLocation(spec, producer.getName(), channel.getName(), null, null);
        List<String> build = Collections.emptyList();
        try {
            build = channel.getAllBuilds(loc);
        }
        catch (ProvisioningException provisioningException) {
            // empty catch block
        }
        return build;
    }

    private static String getBuild(UniverseSpec spec, Producer<?> producer, Channel channel, String freq) {
        FeaturePackLocation loc = new FeaturePackLocation(spec, producer.getName(), channel.getName(), freq, null);
        String build = null;
        try {
            build = channel.getLatestBuild(loc);
        }
        catch (ProvisioningException provisioningException) {
            // empty catch block
        }
        return build;
    }

    public static interface UniverseVisitor {
        public void visit(Producer<?> var1, FeaturePackLocation var2);

        public void exception(UniverseSpec var1, Exception var2);
    }
}

