/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.layout.FeaturePackLayoutTransformer;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.FeaturePackInstallException;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlWriter;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class ProvisioningRuntime
implements FeaturePackSet<FeaturePackRuntime>,
AutoCloseable {
    private final long startTime;
    private ProvisioningConfig config;
    private FsDiff fsDiff;
    private final Path stagedDir;
    private final ProvisioningLayout<FeaturePackRuntime> layout;
    private final MessageWriter messageWriter;
    private List<ProvisionedConfig> configs = Collections.emptyList();

    ProvisioningRuntime(final ProvisioningRuntimeBuilder builder, MessageWriter messageWriter) throws ProvisioningException {
        this.startTime = builder.startTime;
        this.config = builder.config;
        this.layout = builder.layout.transform(new FeaturePackLayoutTransformer<FeaturePackRuntime, FeaturePackRuntimeBuilder>(){

            @Override
            public FeaturePackRuntime transform(FeaturePackRuntimeBuilder other) throws ProvisioningException {
                return other.build(builder);
            }
        });
        this.fsDiff = builder.fsDiff;
        try {
            this.configs = builder.getResolvedConfigs();
            this.stagedDir = this.layout.newStagedDir();
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            this.layout.close();
            throw e;
        }
        this.messageWriter = messageWriter;
    }

    public Path getStagedDir() {
        return this.stagedDir;
    }

    public ProvisioningConfig getProvisioningConfig() {
        return this.config;
    }

    public ProvisioningLayout<FeaturePackRuntime> getLayout() {
        return this.layout;
    }

    public FsDiff getFsDiff() {
        return this.fsDiff;
    }

    @Deprecated
    public ProvisioningLayoutFactory getLayoutFactory() {
        return this.layout.getFactory();
    }

    @Override
    public boolean hasFeaturePacks() {
        return this.layout.hasFeaturePacks();
    }

    @Override
    public boolean hasFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.layout.hasFeaturePack(producer);
    }

    @Override
    public Collection<FeaturePackRuntime> getFeaturePacks() {
        return this.layout.getOrderedFeaturePacks();
    }

    @Override
    public FeaturePackRuntime getFeaturePack(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        return this.layout.getFeaturePack(producer);
    }

    public MessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    public Path getResource(String ... path) throws ProvisioningException {
        return this.layout.getResource(path);
    }

    public Path getTmpPath(String ... path) {
        return this.layout.getTmpPath(path);
    }

    @Deprecated
    public boolean isOptionSet(PluginOption option) throws ProvisioningException {
        return this.isOptionSet((ProvisioningOption)option);
    }

    @Deprecated
    public String getOptionValue(PluginOption option) throws ProvisioningException {
        return this.getOptionValue((ProvisioningOption)option);
    }

    @Deprecated
    public String getOptionValue(PluginOption option, String defaultValue) throws ProvisioningException {
        return this.getOptionValue((ProvisioningOption)option, defaultValue);
    }

    public boolean isOptionSet(ProvisioningOption option) throws ProvisioningException {
        return this.layout.isOptionSet(option.getName());
    }

    public String getOptionValue(ProvisioningOption option) throws ProvisioningException {
        return this.getOptionValue(option, null);
    }

    public String getOptionValue(ProvisioningOption option, String defaultValue) throws ProvisioningException {
        String value = this.layout.getOptionValue(option.getName());
        if (value == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            defaultValue = option.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            if (option.isRequired()) {
                throw new ProvisioningException("Required plugin option " + option.getName() + " has not been provided");
            }
            return null;
        }
        Set<String> valueSet = option.getValueSet();
        if (!valueSet.isEmpty() && !valueSet.contains(value)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Plugin option ").append(option.getName()).append(" is set to ").append(value).append(" but expects one of ");
            StringUtils.append(buf, valueSet);
            throw new ProvisioningException(buf.toString());
        }
        return value;
    }

    @Deprecated
    public Map<String, String> getPluginOptions() {
        return this.layout.getOptions();
    }

    public RepositoryArtifactResolver getArtifactResolver(String repositoryId) throws ProvisioningException {
        return this.layout.getFactory().getUniverseResolver().getArtifactResolver(repositoryId);
    }

    @Override
    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    @Override
    public List<ProvisionedConfig> getConfigs() {
        return this.configs;
    }

    public void provision() throws ProvisioningException {
        this.layout.visitPlugins(new FeaturePackPluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                plugin.preInstall(ProvisioningRuntime.this);
            }
        }, InstallPlugin.class);
        for (FeaturePackRuntime fp : this.layout.getOrderedFeaturePacks()) {
            this.messageWriter.verbose("Installing %s", fp.getFPID());
            for (PackageRuntime pkg : fp.getPackages()) {
                Path pkgSrcDir = pkg.getContentDir();
                if (!Files.exists(pkgSrcDir, new LinkOption[0])) continue;
                try {
                    IoUtils.copy(pkgSrcDir, this.stagedDir);
                }
                catch (IOException e) {
                    throw new FeaturePackInstallException(Errors.packageContentCopyFailed(pkg.getName()), e);
                }
            }
        }
        this.layout.visitPlugins(new FeaturePackPluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                plugin.postInstall(ProvisioningRuntime.this);
            }
        }, InstallPlugin.class);
        try {
            ProvisioningXmlWriter.getInstance().write(this.config, PathsUtils.getProvisioningXml(this.stagedDir));
        }
        catch (IOException | XMLStreamException e) {
            throw new FeaturePackInstallException(Errors.writeFile(PathsUtils.getProvisioningXml(this.stagedDir)), e);
        }
        try {
            ProvisionedStateXmlWriter.getInstance().write(this, PathsUtils.getProvisionedStateXml(this.stagedDir));
        }
        catch (IOException | XMLStreamException e) {
            throw new FeaturePackInstallException(Errors.writeFile(PathsUtils.getProvisionedStateXml(this.stagedDir)), e);
        }
    }

    @Override
    public void close() {
        this.layout.close();
        if (this.messageWriter.isVerboseEnabled()) {
            long time = System.currentTimeMillis() - this.startTime;
            long seconds = time / 1000L;
            this.messageWriter.verbose("Done in %d.%d seconds", seconds, time - seconds * 1000L);
        }
    }
}

