/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.plugin.AbstractProvisionCommand;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public class StateProvisionCommand
extends AbstractProvisionCommand {
    public StateProvisionCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected String getDescription() {
        return "Provision an installation from a provisioning state";
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state) throws Exception {
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        ProvisioningRuntime rt = state.getRuntime();
        Set<ProvisioningOption> opts = this.getPluginOptions(rt);
        for (ProvisioningOption opt : opts) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(this, opt.getName(), opt.isRequired());
            options.add(dynOption);
        }
        return options;
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        return true;
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        return Collections.emptyList();
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
    }

    @Override
    protected void doRunCommand(PmCommandInvocation invoc, Map<String, String> options) throws CommandExecutionException {
        State state = invoc.getPmSession().getState();
        try {
            this.getManager(invoc).provision(state.getConfig(), options);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.provisioningFailed(), ex);
        }
        Path home = this.getInstallationDirectory(invoc.getConfiguration().getAeshContext());
        if (home != null && Files.exists(home, new LinkOption[0])) {
            try {
                invoc.println("Installation done in " + home.toFile().getCanonicalPath());
            }
            catch (IOException ex) {
                throw new CommandExecutionException(invoc.getPmSession(), CliErrors.retrievePath(), ex);
            }
        } else {
            invoc.println("Nothing to install");
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

