/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.featurepack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.featurepack.AbstractFeaturePackCommand;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="get-info", description="Display information on a feature pack")
public class GetInfoCommand
extends AbstractFeaturePackCommand {
    public static final String PATCH_FOR = "Patch for ";
    @Option(completer=InfoTypeCompleter.class, description="Type of information to display (all, configs, dependencies, layers, options)")
    private String type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        block44: {
            if (this.fpl != null && this.file != null) {
                throw new CommandExecutionException("File and location can't be both set");
            }
            if (this.fpl == null && this.file == null) {
                throw new CommandExecutionException("File or location must be set");
            }
            PmSession session = commandInvocation.getPmSession();
            FeaturePackLayout product = null;
            ArrayList<FeaturePackLocation> dependencies = new ArrayList<FeaturePackLocation>();
            try (ProvisioningLayout<FeaturePackLayout> layout = null;){
                try {
                    if (this.fpl != null) {
                        FeaturePackLocation loc = session.getResolvedLocation(null, this.fpl);
                        FeaturePackConfig config = FeaturePackConfig.forLocation(loc);
                        ProvisioningConfig provisioning = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(config)).build();
                        layout = session.getLayoutFactory().newConfigLayout(provisioning);
                    } else {
                        layout = session.getLayoutFactory().newConfigLayout(this.file.toPath(), true);
                    }
                    for (FeaturePackLayout fpLayout : layout.getOrderedFeaturePacks()) {
                        boolean isProduct = true;
                        for (FeaturePackLayout fpLayout2 : layout.getOrderedFeaturePacks()) {
                            if (!fpLayout2.getSpec().hasTransitiveDep(fpLayout.getFPID().getProducer()) && fpLayout2.getSpec().getFeaturePackDep(fpLayout.getFPID().getProducer()) == null) continue;
                            isProduct = false;
                            break;
                        }
                        if (isProduct) {
                            product = fpLayout;
                            continue;
                        }
                        dependencies.add(session.getExposedLocation(null, fpLayout.getFPID().getLocation()));
                    }
                }
                catch (ProvisioningException ex) {
                    throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.infoFailed(), ex);
                }
                if (product == null) {
                    throw new CommandExecutionException("No feature-pack found");
                }
                commandInvocation.println("");
                StateInfoUtil.printFeaturePack(commandInvocation, session.getExposedLocation(null, product.getFPID().getLocation()));
                try {
                    FeaturePackLocation.FPID patchFor = product.getSpec().getPatchFor();
                    if (patchFor != null) {
                        commandInvocation.println("");
                        commandInvocation.println(PATCH_FOR + patchFor);
                    }
                }
                catch (ProvisioningException e) {
                    throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.infoFailed(), e);
                }
                try {
                    if (this.type == null) break block44;
                    commandInvocation.println("");
                    switch (this.type) {
                        case "all": {
                            if (this.displayDependencies(commandInvocation, dependencies)) {
                                commandInvocation.println("");
                            }
                            if (this.displayConfigs(commandInvocation, layout)) {
                                commandInvocation.println("");
                            }
                            if (this.displayLayers(commandInvocation, layout)) {
                                commandInvocation.println("");
                            }
                            if (this.displayOptionalPackages(commandInvocation, layout)) {
                                commandInvocation.println("");
                            }
                            this.displayOptions(commandInvocation, layout);
                            break;
                        }
                        case "configs": {
                            if (!this.displayConfigs(commandInvocation, layout)) {
                                commandInvocation.println("No configurations.");
                            }
                            break;
                        }
                        case "dependencies": {
                            if (!this.displayDependencies(commandInvocation, dependencies)) {
                                commandInvocation.println("No dependencies.");
                            }
                            break;
                        }
                        case "layers": {
                            if (!this.displayLayers(commandInvocation, layout)) {
                                commandInvocation.println("No layers.");
                            }
                            break;
                        }
                        case "options": {
                            if (!this.displayOptions(commandInvocation, layout)) {
                                commandInvocation.println("No options.");
                            }
                            break;
                        }
                        case "optional-packages": {
                            if (!this.displayOptionalPackages(commandInvocation, layout)) {
                                commandInvocation.println("No optional packages.");
                            }
                            break;
                        }
                        default: {
                            throw new CommandExecutionException(CliErrors.invalidInfoType());
                        }
                    }
                }
                catch (IOException | ProvisioningException ex) {
                    throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.infoFailed(), ex);
                }
            }
        }
    }

    private boolean displayDependencies(PmCommandInvocation commandInvocation, List<FeaturePackLocation> dependencies) throws CommandExecutionException {
        String str = StateInfoUtil.buildDependencies(dependencies, null);
        if (str != null) {
            commandInvocation.print(str);
        }
        return str != null;
    }

    private boolean displayConfigs(PmCommandInvocation commandInvocation, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        HashMap<String, List<ConfigInfo>> configs = new HashMap<String, List<ConfigInfo>>();
        try (ProvisioningRuntime rt = ProvisioningRuntimeBuilder.newInstance(commandInvocation.getPmSession().getMessageWriter(false)).initRtLayout(pLayout.transform(ProvisioningRuntimeBuilder.FP_RT_FACTORY)).setEncoding("UTF-8").build();){
            for (ProvisionedConfig m : rt.getConfigs()) {
                String model = m.getModel();
                ArrayList<ConfigInfo> names = (ArrayList<ConfigInfo>)configs.get(model);
                if (names == null) {
                    names = new ArrayList<ConfigInfo>();
                    configs.put(model, names);
                }
                if (m.getName() == null) continue;
                names.add(new ConfigInfo(model, m.getName(), m.getLayers()));
            }
            String str = StateInfoUtil.buildConfigs(configs, pLayout);
            if (str != null) {
                commandInvocation.print(str);
            }
            boolean bl = str != null;
            return bl;
        }
    }

    private boolean displayLayers(PmCommandInvocation commandInvocation, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        String str = StateInfoUtil.buildLayers(pLayout);
        if (str != null) {
            commandInvocation.print(str);
        }
        return str != null;
    }

    private boolean displayOptions(PmCommandInvocation commandInvocation, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        String str = StateInfoUtil.buildOptions(PluginResolver.resolvePlugins(layout));
        if (str != null) {
            commandInvocation.print(str);
        }
        return str != null;
    }

    private boolean displayOptionalPackages(PmCommandInvocation commandInvocation, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        HashMap configs = new HashMap();
        try (ProvisioningRuntime rt = ProvisioningRuntimeBuilder.newInstance(commandInvocation.getPmSession().getMessageWriter(false)).initRtLayout(pLayout.transform(ProvisioningRuntimeBuilder.FP_RT_FACTORY)).setEncoding("UTF-8").build();){
            FeatureContainer container = FeatureContainers.fromProvisioningRuntime(commandInvocation.getPmSession(), rt);
            String str = StateInfoUtil.buildOptionalPackages(commandInvocation.getPmSession(), container, pLayout);
            if (str != null) {
                commandInvocation.print(str);
            }
            boolean bl = str != null;
            return bl;
        }
    }

    public class InfoTypeCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            return Arrays.asList("all", "configs", "dependencies", "layers", "optional-packages", "options");
        }
    }
}

