/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.Caches;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureGroupsBuilder;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeaturePackInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.FeatureSpecsBuilder;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageGroupsBuilder;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.cli.model.ProvisioningInfo;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.plugin.CliPlugin;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class FeatureContainers {
    public static FeatureContainer fromFeaturePackId(PmSession session, FeaturePackLocation.FPID fpid, String name) throws ProvisioningException, IOException {
        FeatureContainer fp;
        if (fpid.getBuild() == null) {
            FeaturePackLocation loc = session.getUniverse().resolveLatestBuild(fpid.getLocation());
            fpid = loc.getFPID();
        }
        if ((fp = Caches.getFeaturePackInfo(fpid)) != null) {
            return fp;
        }
        try (ProvisioningRuntime rt = FeatureContainers.buildFullRuntime(fpid, session);){
            fp = new FeaturePackInfo(name, fpid, rt.getProvisioningConfig());
            FeatureContainers.populateFeatureContainer(fp, session, rt, true);
            Caches.addFeaturePackInfo(fpid, fp);
        }
        return fp;
    }

    public static FeatureContainer fromProvisioningRuntime(PmSession session, ProvisioningRuntime runtime) throws ProvisioningException, IOException {
        ProvisioningInfo info = new ProvisioningInfo(runtime.getProvisioningConfig());
        FeatureContainers.populateFeatureContainer(info, session, runtime, false);
        return info;
    }

    private static void populateFeatureContainer(final FeatureContainer fp, PmSession session, final ProvisioningRuntime runtime, final boolean allSpecs) throws ProvisioningException, IOException {
        final HashMap<String, FeaturePackRuntime> gavs = new HashMap<String, FeaturePackRuntime>();
        for (FeaturePackRuntime rt : runtime.getFeaturePacks()) {
            gavs.put(Identity.buildOrigin(rt.getFPID().getProducer()), rt);
        }
        final ArrayList cliPlugins = new ArrayList();
        FeaturePackPluginVisitor<CliPlugin> visitor = new FeaturePackPluginVisitor<CliPlugin>(){

            @Override
            public void visitPlugin(CliPlugin plugin) throws ProvisioningException {
                cliPlugins.add(plugin);
            }
        };
        runtime.getLayout().visitPlugins(visitor, CliPlugin.class);
        final CliPlugin plugin = cliPlugins.isEmpty() ? null : (CliPlugin)cliPlugins.get(0);
        PackageGroupsBuilder pkgBuilder = new PackageGroupsBuilder();
        final FeatureSpecsBuilder specsBuilder = new FeatureSpecsBuilder();
        String optionalOption = runtime.getProvisioningConfig().getOption(ProvisioningOption.OPTIONAL_PACKAGES.getName());
        if (optionalOption == null) {
            optionalOption = "all";
        }
        boolean includeOptional = false;
        boolean includePassive = false;
        boolean checkPassive = false;
        if (optionalOption.equals("all")) {
            includePassive = true;
            includeOptional = true;
        } else if (optionalOption.equals("none")) {
            includeOptional = false;
            includePassive = false;
        } else if (optionalOption.equals("passive")) {
            includeOptional = false;
            includePassive = true;
            checkPassive = true;
        } else if (optionalOption.equals("passive+")) {
            includeOptional = true;
            includePassive = true;
            checkPassive = true;
        } else {
            throw new ProvisioningException("Not recognized value for optional-packages");
        }
        final boolean includeOptionalF = includeOptional;
        final boolean includePassiveF = includePassive;
        final HashMap allPackages = new HashMap();
        for (FeaturePackRuntime rt : runtime.getFeaturePacks()) {
            fp.addLayers(rt.loadLayers());
            pkgBuilder.resetRoots();
            allPackages.put(rt.getFPID().getProducer().toString(), new HashMap());
            for (PackageRuntime packageRuntime : rt.getPackages()) {
                if (checkPassive && packageRuntime.isPassive() && !packageRuntime.isPassiveIncluded()) continue;
                ((Map)allPackages.get(rt.getFPID().getProducer().toString())).put(packageRuntime.getName(), packageRuntime);
                pkgBuilder.buildGroups(new PackageInfo(packageRuntime, Identity.fromChannel(rt.getFPID().getProducer(), packageRuntime.getName()), plugin), new PackageGroupsBuilder.PackageInfoBuilder(){

                    @Override
                    public PackageInfo build(Identity identity, PackageInfo parent) {
                        try {
                            FeaturePackRuntime currentRuntime = parent.getFeaturePackRuntime();
                            Identity resolvedIdentity = null;
                            PackageRuntime p = null;
                            if (identity.getOrigin().equals("")) {
                                p = currentRuntime.getPackage(identity.getName());
                                if (p == null) {
                                    for (FeaturePackConfig fpdep : currentRuntime.getSpec().getFeaturePackDeps()) {
                                        FeaturePackRuntime depRuntime;
                                        if (currentRuntime.getSpec().originOf(fpdep.getLocation().getProducer()) != null || (p = (depRuntime = (FeaturePackRuntime)gavs.get(Identity.buildOrigin(fpdep.getLocation().getProducer()))).getPackage(identity.getName())) == null) continue;
                                        resolvedIdentity = Identity.fromChannel(fpdep.getLocation().getProducer(), identity.getName());
                                        break;
                                    }
                                } else {
                                    resolvedIdentity = Identity.fromChannel(currentRuntime.getFPID().getProducer(), identity.getName());
                                }
                            } else {
                                FeaturePackRuntime extRt = (FeaturePackRuntime)gavs.get(identity.getOrigin());
                                if (extRt == null) {
                                    FeaturePackConfig fpdep = currentRuntime.getSpec().getFeaturePackDep(identity.getOrigin());
                                    if (fpdep != null) {
                                        resolvedIdentity = Identity.fromChannel(fpdep.getLocation().getProducer(), identity.getName());
                                        extRt = (FeaturePackRuntime)gavs.get(resolvedIdentity.getOrigin());
                                    }
                                } else {
                                    resolvedIdentity = identity;
                                }
                                if (extRt != null) {
                                    p = extRt.getPackage(identity.getName());
                                }
                            }
                            if (p == null) {
                                return null;
                            }
                            return new PackageInfo(p, resolvedIdentity, plugin);
                        }
                        catch (IOException | ProvisioningException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            fp.setPackagesRoot(Identity.buildOrigin(rt.getFPID().getProducer()), pkgBuilder.getPackagesRoot());
            if (!allSpecs) continue;
            Group specsRoot = specsBuilder.buildTree(runtime.getLayout(), session, rt.getFPID(), fp.getFPID(), pkgBuilder.getPackages(), allSpecs, null);
            fp.setFeatureSpecRoot(Identity.buildOrigin(rt.getFPID().getProducer()), specsRoot);
        }
        fp.setAllPackages(pkgBuilder.getPackages());
        final HashMap actualSet = new HashMap();
        final HashMap<ResolvedSpecId, List<FeatureInfo>> features = new HashMap<ResolvedSpecId, List<FeatureInfo>>();
        for (ProvisionedConfig provisionedConfig : runtime.getConfigs()) {
            final ConfigInfo config = new ConfigInfo(provisionedConfig.getModel(), provisionedConfig.getName(), provisionedConfig.getLayers());
            fp.addFinalConfig(config);
            final FeatureGroupsBuilder grpBuilder = new FeatureGroupsBuilder();
            provisionedConfig.handle(new ProvisionedConfigHandler(){

                @Override
                public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
                    HashSet<ResolvedSpecId> set;
                    FeaturePackRuntime rt = runtime.getFeaturePack(feature.getSpecId().getProducer());
                    FeatureSpec featureSpec = rt.getFeatureSpec(feature.getSpecId().getName());
                    FeaturePackLocation.ProducerSpec producer = feature.getSpecId().getProducer();
                    for (PackageDependencySpec spec : featureSpec.getLocalPackageDeps()) {
                        PackageRuntime pkg = (PackageRuntime)((Map)allPackages.get(producer.toString())).get(spec.getName());
                        if (pkg == null) continue;
                        if (includePassiveF && pkg.isPassive()) {
                            fp.addPassivePackage(producer.toString(), feature.getSpecId().getName(), spec.getName());
                            continue;
                        }
                        if (!includeOptionalF || !pkg.isOptional()) continue;
                        fp.addOptionalPackage(producer.toString(), feature.getSpecId().getName(), spec.getName());
                    }
                    if (featureSpec.hasExternalPackageDeps()) {
                        for (String origin : featureSpec.getPackageOrigins()) {
                            for (PackageDependencySpec spec : featureSpec.getExternalPackageDeps(origin)) {
                                PackageRuntime pkg = (PackageRuntime)((Map)allPackages.get(origin)).get(spec.getName());
                                if (pkg == null) continue;
                                if (includePassiveF && pkg.isPassive()) {
                                    fp.addPassivePackage(origin, feature.getSpecId().getName(), spec.getName());
                                    continue;
                                }
                                if (!includeOptionalF || !pkg.isOptional()) continue;
                                fp.addOptionalPackage(origin, feature.getSpecId().getName(), spec.getName());
                            }
                        }
                    }
                    if ((set = (HashSet<ResolvedSpecId>)actualSet.get(feature.getSpecId().getProducer())) == null) {
                        set = new HashSet<ResolvedSpecId>();
                        actualSet.put(feature.getSpecId().getProducer(), set);
                    }
                    set.add(feature.getSpecId());
                    String fullSpecName = feature.getSpecId().getName();
                    ArrayList<String> path = new ArrayList<String>();
                    Group parent = grpBuilder.buildFeatureGroups(fullSpecName, feature.getId(), path);
                    FeatureInfo featInfo = new FeatureInfo(config, feature, path, fp.getFPID());
                    ArrayList<FeatureInfo> lst = (ArrayList<FeatureInfo>)features.get(feature.getSpecId());
                    if (lst == null) {
                        lst = new ArrayList<FeatureInfo>();
                        features.put(feature.getSpecId(), lst);
                    }
                    lst.add(featInfo);
                    parent.setFeature(featInfo);
                    if (allSpecs) {
                        FeatureSpecInfo spec = specsBuilder.getAllSpecs().get(feature.getSpecId());
                        featInfo.attachSpecInfo(spec);
                        parent.setFeature(featInfo);
                    }
                }
            });
            config.setFeatureGroupRoot(grpBuilder.getRoot());
        }
        for (String string : allPackages.keySet()) {
            Object vals22;
            Map<String, Set<String>> passives;
            HashSet<String> allOptionals = new HashSet<String>();
            HashSet allPassives = new HashSet();
            Map<String, Set<String>> optionals = fp.getOptionalPackages().get(string);
            if (optionals != null) {
                for (Set<String> set : optionals.values()) {
                    allOptionals.addAll(set);
                }
            }
            if ((passives = fp.getPassivePackages().get(string)) != null) {
                for (Object vals22 : passives.values()) {
                    allPassives.addAll(vals22);
                }
            }
            Map map = (Map)allPackages.get(string);
            vals22 = map.entrySet().iterator();
            while (vals22.hasNext()) {
                Map.Entry entry = (Map.Entry)vals22.next();
                String name = (String)entry.getKey();
                PackageRuntime pkg = (PackageRuntime)entry.getValue();
                if (allOptionals.contains(name) || allPassives.contains(name)) continue;
                if (includePassiveF && pkg.isPassive()) {
                    fp.addOrphanPassivePackage(string, name);
                    continue;
                }
                if (!includeOptionalF || !pkg.isOptional()) continue;
                fp.addOrphanOptionalPackage(string, name);
            }
        }
        if (!allSpecs) {
            for (Map.Entry entry : actualSet.entrySet()) {
                Group specsRoot = specsBuilder.buildTree(runtime.getLayout(), session, ((FeaturePackLocation.ProducerSpec)entry.getKey()).getLocation().getFPID(), fp.getFPID(), pkgBuilder.getPackages(), false, (Set)entry.getValue());
                for (ResolvedSpecId rs : (Set)entry.getValue()) {
                    List lst = (List)features.get(rs);
                    for (FeatureInfo fi : lst) {
                        fi.attachSpecInfo(specsBuilder.getAllSpecs().get(rs));
                    }
                }
                fp.setFeatureSpecRoot(Identity.buildOrigin((FeaturePackLocation.ProducerSpec)entry.getKey()), specsRoot);
            }
        }
        fp.seAllFeatureSpecs(specsBuilder.getAllSpecs());
        fp.setAllFeatures(features);
    }

    private static ProvisioningRuntime buildFullRuntime(FeaturePackLocation.FPID fpid, PmSession pmSession) throws ProvisioningException {
        FeaturePackConfig config = FeaturePackConfig.forLocation(fpid.getLocation());
        ProvisioningConfig provisioning = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(config)).build();
        ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(pmSession.getMessageWriter(false)).initLayout(pmSession.getLayoutFactory(), provisioning).setEncoding("UTF-8").build();
        return runtime;
    }
}

