/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;

class FeaturePackProvisioning {
    FeaturePackProvisioning() {
    }

    State.Action removeDependency(FeaturePackLocation fpl) throws ProvisioningException {
        return new RemoveDependencyAction(fpl);
    }

    State.Action addDependency(PmSession pmSession, String name, FeaturePackLocation fpl, boolean inheritConfigs, boolean inheritPackages) throws ProvisioningException, IOException {
        AddDependencyAction action = new AddDependencyAction(fpl, inheritConfigs, inheritPackages);
        return action;
    }

    State.Action includeConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new IncludeConfigurationAction(cf);
    }

    State.Action removeIncludedConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveIncludedConfigurationAction(cf);
    }

    State.Action excludeConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new ExcludeConfigurationAction(cf);
    }

    State.Action removeExcludedConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveExcludedConfigurationAction(cf);
    }

    State.Action includePackage(String pkg, FeaturePackConfig cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        HashMap<FeaturePackConfig, String> map = new HashMap<FeaturePackConfig, String>();
        map.put(cf, pkg);
        return new IncludePackageAction((Map<FeaturePackConfig, String>)map);
    }

    State.Action removeIncludedPackage(Map<FeaturePackConfig, String> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveIncludedPackageAction(cf);
    }

    State.Action excludePackage(String pkg, FeaturePackConfig cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        HashMap<FeaturePackConfig, String> map = new HashMap<FeaturePackConfig, String>();
        map.put(cf, pkg);
        return new ExcludePackageAction((Map<FeaturePackConfig, String>)map);
    }

    State.Action removeExcludedPackage(Map<FeaturePackConfig, String> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveExcludedPackageAction(cf);
    }

    State.Action excludePackageFromNewTransitive(FeaturePackLocation.ProducerSpec producer, String pkg) {
        return new ExcludePackageFromNewTransitiveAction(producer, pkg);
    }

    State.Action includePackageInNewTransitive(FeaturePackLocation.ProducerSpec producer, String pkg) {
        return new IncludePackageInNewTransitiveAction(producer, pkg);
    }

    private class RemoveExcludedPackageAction
    extends AbstractAction<String> {
        RemoveExcludedPackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                fpBuilder.removeExcludedPackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private class RemoveIncludedPackageAction
    extends AbstractAction<String> {
        RemoveIncludedPackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                fpBuilder.removeIncludedPackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private class IncludePackageInNewTransitiveAction
    implements State.Action {
        private final String pkg;
        private final FeaturePackLocation loc;

        IncludePackageInNewTransitiveAction(FeaturePackLocation.ProducerSpec producer, String pkg) {
            this.pkg = pkg;
            this.loc = FeaturePackLocation.fromString(producer.toString());
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            FeaturePackConfig config = FeaturePackConfig.transitiveBuilder(this.loc).includePackage(this.pkg).build();
            builder.addFeaturePackDep(config);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeTransitiveDep(this.loc.getFPID());
        }
    }

    private class ExcludePackageFromNewTransitiveAction
    implements State.Action {
        private final String pkg;
        private final FeaturePackLocation loc;

        ExcludePackageFromNewTransitiveAction(FeaturePackLocation.ProducerSpec producer, String pkg) {
            this.pkg = pkg;
            this.loc = FeaturePackLocation.fromString(producer.toString());
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            FeaturePackConfig config = FeaturePackConfig.transitiveBuilder(this.loc).excludePackage(this.pkg).build();
            builder.addFeaturePackDep(config);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeTransitiveDep(this.loc.getFPID());
        }
    }

    private class ExcludePackageAction
    extends AbstractAction<String> {
        ExcludePackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                if (fpBuilder.isPackageIncluded(pkg)) {
                    fpBuilder.removeIncludedPackage(pkg);
                }
                fpBuilder.excludePackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private class IncludePackageAction
    extends AbstractAction<String> {
        IncludePackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                if (fpBuilder.isPackageExcluded(pkg)) {
                    fpBuilder.removeExcludedPackage(pkg);
                }
                fpBuilder.includePackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private class RemoveIncludedConfigurationAction
    extends AbstractAction<ConfigId> {
        RemoveIncludedConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            try {
                fpBuilder.removeIncludedDefaultConfig(id);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private class RemoveExcludedConfigurationAction
    extends AbstractAction<ConfigId> {
        RemoveExcludedConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            try {
                fpBuilder.removeExcludedDefaultConfig(id);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private class ExcludeConfigurationAction
    extends AbstractAction<ConfigId> {
        ExcludeConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            if (fpBuilder.isDefaultConfigIncluded(id)) {
                fpBuilder.removeIncludedDefaultConfig(id);
            }
            fpBuilder.excludeDefaultConfig(id);
            return true;
        }
    }

    private class IncludeConfigurationAction
    extends AbstractAction<ConfigId> {
        IncludeConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            try {
                if (fpBuilder.isDefaultConfigExcluded(id)) {
                    fpBuilder.removeExcludedDefaultConfig(id);
                }
                fpBuilder.includeDefaultConfig(id);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }
    }

    private abstract class AbstractAction<T>
    implements State.Action {
        private final Map<FeaturePackConfig, T> cf;
        private final Map<FeaturePackLocation.FPID, Integer> indexes = new HashMap<FeaturePackLocation.FPID, Integer>();
        private final List<FeaturePackConfig> transitives = new ArrayList<FeaturePackConfig>();

        AbstractAction(Map<FeaturePackConfig, T> cf) {
            this.cf = cf;
        }

        protected abstract boolean doAction(FeaturePackConfig.Builder var1, T var2) throws ProvisioningException;

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (Map.Entry<FeaturePackConfig, T> entry : this.cf.entrySet()) {
                FeaturePackConfig.Builder fpBuilder = FeaturePackConfig.builder(entry.getKey());
                boolean doit = this.doAction(fpBuilder, entry.getValue());
                if (!doit) continue;
                FeaturePackConfig cfg = fpBuilder.build();
                if (cfg.isTransitive()) {
                    builder.removeTransitiveDep(cfg.getLocation().getFPID());
                    if (cfg.getLocation().getBuild() != null || !this.isEmptyConfig(cfg)) {
                        builder.addFeaturePackDep(cfg);
                    }
                    this.transitives.add(entry.getKey());
                    continue;
                }
                int index = builder.getFeaturePackDepIndex(entry.getKey().getLocation());
                this.indexes.put(entry.getKey().getLocation().getFPID(), index);
                builder.removeFeaturePackDep(entry.getKey().getLocation());
                builder.addFeaturePackDep(index, fpBuilder.build());
            }
        }

        private boolean isEmptyConfig(FeaturePackConfig cfg) {
            return !cfg.hasDefinedConfigs() && !cfg.hasExcludedConfigs() && !cfg.hasExcludedPackages() && !cfg.hasFullModelsExcluded() && !cfg.hasFullModelsIncluded() && !cfg.hasIncludedConfigs() && !cfg.hasIncludedPackages() && !cfg.hasPatches() && cfg.isInheritPackages() && cfg.isInheritConfigs();
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (Map.Entry<FeaturePackConfig, T> entry : this.cf.entrySet()) {
                Integer index = this.indexes.get(entry.getKey().getLocation().getFPID());
                if (index == null) continue;
                builder.removeFeaturePackDep(entry.getKey().getLocation());
                builder.addFeaturePackDep(index, entry.getKey());
            }
            for (FeaturePackConfig t : this.transitives) {
                if (builder.hasTransitiveFeaturePackDep(t.getLocation().getProducer())) {
                    builder.removeTransitiveDep(t.getLocation().getFPID());
                }
                builder.addFeaturePackDep(t);
            }
        }
    }

    private class RemoveDependencyAction
    implements State.Action {
        private final FeaturePackLocation fpl;
        private int index;
        private FeaturePackConfig fpConfig;

        RemoveDependencyAction(FeaturePackLocation fpl) {
            this.fpl = fpl;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            this.index = builder.getFeaturePackDepIndex(this.fpl);
            this.fpConfig = current.getFeaturePackDep(this.fpl.getProducer());
            builder.removeFeaturePackDep(this.fpl);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.addFeaturePackDep(this.index, this.fpConfig);
        }
    }

    private class AddDependencyAction
    implements State.Action {
        private final FeaturePackConfig.Builder newDepBuilder;
        private final FeaturePackLocation fpl;

        AddDependencyAction(FeaturePackLocation fpl, boolean inheritConfigs, boolean inheritPackages) {
            this.fpl = fpl;
            this.newDepBuilder = ((FeaturePackConfig.Builder)FeaturePackConfig.builder(fpl).setInheritConfigs(inheritConfigs)).setInheritPackages(inheritPackages);
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.addFeaturePackDep(this.newDepBuilder.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeFeaturePackDep(this.fpl);
        }
    }
}

