/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenLatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRangeParser;

public class LocalArtifactVersionRangeResolver {
    private static final MavenArtifactVersionRangeParser versionRangeParser = new MavenArtifactVersionRangeParser();
    protected final Path repoHome;

    public LocalArtifactVersionRangeResolver(Path localRepo) {
        this.repoHome = localRepo;
    }

    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = this.resolveLatestVersionDir(artifact, lowestQualifier);
        artifact.setVersion(path.getFileName().toString());
        path = path.resolve(artifact.getArtifactFileName());
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
        }
        artifact.setPath(path);
    }

    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.resolveLatestVersionDir(artifact, lowestQualifier).getFileName().toString();
    }

    protected String pathDoesNotExist(MavenArtifact artifact, Path path) throws MavenUniverseException {
        return "Failed to resolve " + artifact.getCoordsAsString() + ": " + path + " does not exist";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path resolveLatestVersionDir(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        String part;
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        if (artifact.getArtifactId() == null) {
            MavenErrors.missingArtifactId();
        }
        if (artifact.getVersionRange() == null) {
            throw new MavenUniverseException("Version range is missing for " + artifact.getCoordsAsString());
        }
        Path artifactDir = this.repoHome;
        String[] stringArray = groupParts = artifact.getGroupId().split("\\.");
        int n = stringArray.length;
        for (int n2 = 0; n2 < n; artifactDir = artifactDir.resolve(part), ++n2) {
            part = stringArray[n2];
        }
        if (!Files.exists(artifactDir = artifactDir.resolve(artifact.getArtifactId()), new LinkOption[0])) {
            throw MavenErrors.artifactNotFound(artifact, this.repoHome);
        }
        final MavenArtifactVersionRange range = versionRangeParser.parseRange(artifact.getVersionRange());
        if (lowestQualifier == null) {
            lowestQualifier = "";
        }
        try (final DirectoryStream<Path> stream = Files.newDirectoryStream(artifactDir);){
            Iterable<String> versions = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        final Iterator<Path> i;
                        Path nextPath;
                        {
                            this.i = stream.iterator();
                            this.nextPath = this.toNext(range);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextPath != null;
                        }

                        @Override
                        public String next() {
                            if (this.nextPath != null) {
                                String s = this.nextPath.getFileName().toString();
                                this.nextPath = this.toNext(range);
                                return s;
                            }
                            throw new NoSuchElementException();
                        }

                        private Path toNext(MavenArtifactVersionRange range) {
                            while (this.i.hasNext()) {
                                Path path = this.i.next();
                                MavenArtifactVersion next = new MavenArtifactVersion(path.getFileName().toString());
                                if (!range.includesVersion(next)) continue;
                                return path;
                            }
                            return null;
                        }
                    };
                }
            };
            MavenArtifactVersion latest = MavenArtifactVersion.getLatest(versions, lowestQualifier);
            if (latest == null) {
                throw new MavenLatestVersionNotAvailableException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()));
            }
            Path path = artifactDir.resolve(latest.toString());
            return path;
        }
        catch (MavenUniverseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MavenUniverseException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()), e);
        }
    }
}

