/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.ConfigLayerSpecXmlParser;
import org.jboss.galleon.xml.FeaturePackXmlParser;
import org.jboss.galleon.xml.FeatureSpecXmlParser;

public abstract class FeaturePackLayout {
    public static final int DIRECT_DEP = 0;
    public static final int TRANSITIVE_DEP = 1;
    public static final int PATCH = 2;
    protected final FeaturePackLocation.FPID fpid;
    protected final int type;
    protected Path dir;
    protected FeaturePackSpec spec;

    protected FeaturePackLayout(FeaturePackLocation.FPID fpid, Path dir, int type) {
        this.fpid = fpid;
        this.dir = dir;
        this.type = type;
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public FeaturePackSpec getSpec() throws ProvisioningException {
        if (this.spec == null) {
            try (BufferedReader reader = Files.newBufferedReader(this.dir.resolve("feature-pack.xml"));){
                this.spec = FeaturePackXmlParser.getInstance().parse(reader);
            }
            catch (Exception e) {
                throw new ProvisioningException(Errors.readFile(this.dir.resolve("feature-pack.xml")));
            }
        }
        return this.spec;
    }

    public Path getDir() {
        return this.dir;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDirectDep() {
        return this.type == 0;
    }

    public boolean isTransitiveDep() {
        return this.type == 1;
    }

    public boolean isPatch() {
        return this.type == 2;
    }

    public Path getResource(String ... path) throws ProvisioningDescriptionException {
        if (path.length == 0) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (path.length == 1) {
            return this.dir.resolve("resources").resolve(path[0]);
        }
        Path p = this.dir.resolve("resources");
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }

    public boolean hasFeatureSpec(String name) {
        return Files.exists(this.dir.resolve("features").resolve(name).resolve("spec.xml"), new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureSpec loadFeatureSpec(String name) throws ProvisioningException {
        Path specXml = this.dir.resolve("features").resolve(name).resolve("spec.xml");
        if (!Files.exists(specXml, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(specXml);){
            FeatureSpec featureSpec = FeatureSpecXmlParser.getInstance().parse(reader);
            return featureSpec;
        }
        catch (Exception e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(specXml), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigLayerSpec loadConfigLayerSpec(String model, String name) throws ProvisioningException {
        Path specXml = model == null ? this.getDir().resolve("layers").resolve(name).resolve("layer-spec.xml") : this.getDir().resolve("layers").resolve(model).resolve(name).resolve("layer-spec.xml");
        if (!Files.exists(specXml, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(specXml);){
            ConfigLayerSpec configLayerSpec = ConfigLayerSpecXmlParser.getInstance().parse(reader);
            return configLayerSpec;
        }
        catch (Exception e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(specXml), e);
        }
    }

    public Set<ConfigId> loadLayers() throws ProvisioningException, IOException {
        final Path layersDir = this.getDir().resolve("layers");
        if (!Files.exists(layersDir, new LinkOption[0])) {
            return Collections.emptySet();
        }
        final HashSet<ConfigId> layers = new HashSet<ConfigId>();
        Files.walkFileTree(layersDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().equals("layer-spec.xml")) {
                    Path rootDir = file.getParent().getParent();
                    ConfigId id = rootDir.equals(layersDir) ? new ConfigId(null, file.getParent().getFileName().toString()) : new ConfigId(rootDir.getFileName().toString(), file.getParent().getFileName().toString());
                    layers.add(id);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return layers;
    }
}

