/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.UnsatisfiedPackageDependencyException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.FpStack;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedConfig;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureGroupConfig;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.ConfigLayerDependency;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class ProvisioningRuntimeBuilder {
    public static final FeaturePackLayoutFactory<FeaturePackRuntimeBuilder> FP_RT_FACTORY = new FeaturePackLayoutFactory<FeaturePackRuntimeBuilder>(){

        @Override
        public FeaturePackRuntimeBuilder newFeaturePack(FeaturePackLocation fpl, FeaturePackSpec spec, Path fpDir, int type) {
            return new FeaturePackRuntimeBuilder(fpl.getFPID(), spec, fpDir, type);
        }
    };
    long startTime;
    boolean logTime;
    ProvisioningConfig config;
    ProvisioningLayout<FeaturePackRuntimeBuilder> layout;
    Path stagedDir;
    boolean recordState;
    FsDiff fsDiff;
    private final MessageWriter messageWriter;
    Map<String, ConfigModelStack> nameOnlyConfigs = Collections.emptyMap();
    Map<String, Map<String, ConfigModelStack>> namedModelConfigs = Collections.emptyMap();
    private FeaturePackRuntimeBuilder thisOrigin;
    private FeaturePackRuntimeBuilder currentOrigin;
    private ConfigModelStack configStack;
    private FpStack fpConfigStack;
    private ResolvedFeature parentFeature;
    private Map<ConfigId, ConfigModelStack> configsToBuild = Collections.emptyMap();
    private Map<ConfigId, ConfigModelStack> layers = Collections.emptyMap();
    private ArrayList<PackageRuntime.Builder> resolvedPkgBranch = new ArrayList();
    int pkgsTotal;
    private List<FeaturePackRuntimeBuilder> visited = new ArrayList<FeaturePackRuntimeBuilder>();
    private int pkgDepMask;
    int includedPkgDeps;
    static final int PKG_DEP_MASK_ALL = Integer.MAX_VALUE;
    static final int PKG_DEP_MASK_PASSIVE = 0x7FFFFFFE;
    static final int PKG_DEP_MASK_REQUIRED = 0x7FFFFFFC;
    static final int PKG_DEP_ALL = 0;
    static final int PKG_DEP_PASSIVE = 1;
    static final int PKG_DEP_PASSIVE_PLUS = 2;
    static final int PKG_DEP_REQUIRED = 3;

    public static ProvisioningRuntimeBuilder newInstance() {
        return ProvisioningRuntimeBuilder.newInstance(DefaultMessageWriter.getDefaultInstance());
    }

    public static ProvisioningRuntimeBuilder newInstance(MessageWriter messageWriter) {
        return new ProvisioningRuntimeBuilder(messageWriter);
    }

    private ProvisioningRuntimeBuilder(MessageWriter messageWriter) {
        this.messageWriter = messageWriter;
    }

    public ProvisioningRuntimeBuilder setLogTime(boolean logTime) {
        this.logTime = logTime;
        return this;
    }

    public ProvisioningRuntimeBuilder initRtLayout(ProvisioningLayout<FeaturePackRuntimeBuilder> configLayout) throws ProvisioningException {
        this.layout = configLayout;
        return this;
    }

    public ProvisioningRuntimeBuilder initLayout(ProvisioningLayout<?> configLayout) throws ProvisioningException {
        this.layout = configLayout.transform(FP_RT_FACTORY);
        return this;
    }

    public ProvisioningRuntimeBuilder initLayout(ProvisioningLayoutFactory layoutFactory, ProvisioningConfig config) throws ProvisioningException {
        this.layout = layoutFactory.newConfigLayout(config, FP_RT_FACTORY, false);
        return this;
    }

    public ProvisioningRuntimeBuilder setFsDiff(FsDiff fsDiff) {
        this.fsDiff = fsDiff;
        return this;
    }

    public ProvisioningRuntimeBuilder setStagedDir(Path p) {
        this.stagedDir = p;
        return this;
    }

    public ProvisioningRuntimeBuilder setRecordState(boolean recordState) {
        this.recordState = recordState;
        return this;
    }

    public ProvisioningRuntime build() throws ProvisioningException {
        this.startTime = this.logTime || this.messageWriter.isVerboseEnabled() ? System.nanoTime() : -1L;
        try {
            ProvisioningRuntime provisioningRuntime = this.doBuild();
            return provisioningRuntime;
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            throw e;
        }
        finally {
            this.layout.close();
        }
    }

    private ProvisioningRuntime doBuild() throws ProvisioningException {
        String optionalPackages;
        this.config = this.layout.getConfig();
        this.fpConfigStack = new FpStack(this.config);
        switch (optionalPackages = this.layout.getOptionValue(ProvisioningOption.OPTIONAL_PACKAGES)) {
            case "all": {
                this.pkgDepMask = Integer.MAX_VALUE;
                this.includedPkgDeps = 0;
                break;
            }
            case "passive+": {
                this.pkgDepMask = Integer.MAX_VALUE;
                this.includedPkgDeps = 2;
                break;
            }
            case "passive": {
                this.pkgDepMask = 0x7FFFFFFE;
                this.includedPkgDeps = 1;
                break;
            }
            case "none": {
                this.pkgDepMask = 0x7FFFFFFC;
                this.includedPkgDeps = 3;
                break;
            }
            default: {
                throw new ProvisioningDescriptionException(Errors.pluginOptionIllegalValue(ProvisioningOption.OPTIONAL_PACKAGES.getName(), optionalPackages, ProvisioningOption.OPTIONAL_PACKAGES.getValueSet()));
            }
        }
        this.collectDefaultConfigs();
        List<ConfigModelStack> configStacks = Collections.emptyList();
        if (this.config.hasDefinedConfigs()) {
            for (ConfigModel config : this.config.getDefinedConfigs()) {
                if (config.getId().isModelOnly()) continue;
                this.configStack = this.configsToBuild.get(config.getId());
                configStacks = this.pushConfig(configStacks, config);
            }
        }
        boolean extendedStackLevel = this.processFpDepConfigs(this.config);
        for (int i = configStacks.size() - 1; i >= 0; --i) {
            ConfigModelStack configStack = (ConfigModelStack)configStacks.get(i);
            this.processConfig(configStack, this.popConfig(configStack));
        }
        if (extendedStackLevel) {
            this.fpConfigStack.popLevel();
        }
        this.mergeModelOnlyConfigs();
        return new ProvisioningRuntime(this, this.messageWriter);
    }

    private void mergeModelOnlyConfigs() throws ProvisioningException {
        if (this.namedModelConfigs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, ConfigModelStack>> entry : this.namedModelConfigs.entrySet()) {
            ConfigId modelOnlyId = new ConfigId(entry.getKey(), null);
            ConfigModelStack modelOnlyStack = this.resolveModelOnlyConfig(modelOnlyId);
            if (modelOnlyStack == null) continue;
            for (ConfigModelStack configStack : entry.getValue().values()) {
                configStack.merge(modelOnlyStack);
            }
        }
    }

    private void collectDefaultConfigs() throws ProvisioningException {
        if (this.config.hasDefinedConfigs()) {
            for (ConfigModel config : this.config.getDefinedConfigs()) {
                ConfigModelStack configStack;
                ConfigId id = config.getId();
                if (id.isModelOnly() || (configStack = this.configsToBuild.get(id)) != null) continue;
                configStack = this.getConfigStack(id);
                this.configsToBuild = CollectionUtils.putLinked(this.configsToBuild, id, configStack);
            }
        }
        if (this.pushFpDepConfigs(this.config)) {
            while (this.fpConfigStack.hasNext()) {
                this.collectDefaultConfigs(this.fpConfigStack.next());
            }
            this.fpConfigStack.popLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDefaultConfigs(FeaturePackConfig fpConfig) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
        this.thisOrigin = this.layout.getFeaturePack(producer);
        FeaturePackRuntimeBuilder parentFp = this.setOrigin(this.thisOrigin);
        try {
            if (fpConfig.hasDefinedConfigs()) {
                for (ConfigModel configModel : fpConfig.getDefinedConfigs()) {
                    ConfigModelStack configStack;
                    ConfigId id = configModel.getId();
                    if (id.isModelOnly() || this.fpConfigStack.isFilteredOut(producer, id, true) || (configStack = this.configsToBuild.get(id)) != null) continue;
                    configStack = this.getConfigStack(id);
                    this.configsToBuild = CollectionUtils.putLinked(this.configsToBuild, id, configStack);
                }
            }
            if (!fpConfig.isTransitive()) {
                FeaturePackSpec currentSpec = this.currentOrigin.getSpec();
                if (currentSpec.hasDefinedConfigs()) {
                    for (ConfigModel config : currentSpec.getDefinedConfigs()) {
                        ConfigModelStack configStack;
                        ConfigId id = config.getId();
                        if (id.isModelOnly() || this.fpConfigStack.isFilteredOut(producer, id, false) || (configStack = this.configsToBuild.get(id)) != null) continue;
                        configStack = this.getConfigStack(id);
                        this.configsToBuild = CollectionUtils.putLinked(this.configsToBuild, id, configStack);
                    }
                }
                if (currentSpec.hasFeaturePackDeps()) {
                    int n;
                    boolean bl = false;
                    if (currentSpec.hasTransitiveDeps()) {
                        for (FeaturePackConfig fpDep : currentSpec.getTransitiveDeps()) {
                            int n2;
                            n2 |= this.fpConfigStack.push(fpDep, n2 != 0);
                        }
                    }
                    for (FeaturePackConfig fpDep : currentSpec.getFeaturePackDeps()) {
                        n |= this.fpConfigStack.push(fpDep, n != 0);
                    }
                    if (n != 0) {
                        while (this.fpConfigStack.hasNext()) {
                            this.collectDefaultConfigs(this.fpConfigStack.next());
                        }
                    }
                    if (n != 0) {
                        this.fpConfigStack.popLevel();
                    }
                }
            }
        }
        finally {
            this.thisOrigin = parentFp;
            this.setOrigin(parentFp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void processFpConfig(FeaturePackConfig fpConfig) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
        this.thisOrigin = this.layout.getFeaturePack(producer);
        FeaturePackRuntimeBuilder parentFp = this.setOrigin(this.thisOrigin);
        try {
            ConfigModelStack configStack;
            List<ConfigModelStack> fpConfigStacks = Collections.emptyList();
            List<ConfigModelStack> specConfigStacks = Collections.emptyList();
            for (Map.Entry<ConfigId, ConfigModelStack> entry : this.configsToBuild.entrySet()) {
                ConfigId configId = entry.getKey();
                this.configStack = entry.getValue();
                ConfigModel config = fpConfig.getDefinedConfig(configId);
                if (config != null && !this.fpConfigStack.isFilteredOut(producer, configId, true)) {
                    fpConfigStacks = this.pushConfig(fpConfigStacks, config);
                }
                if (fpConfig.isTransitive() || !this.fpConfigStack.isIncludedInTransitiveDeps(producer, configId) && (this.fpConfigStack.isFilteredOutFromDeps(producer, configId, false) || !this.thisOrigin.getSpec().hasDefinedConfig(configId) && this.configStack.size() <= 1 && this.thisOrigin.getConfig(configId) == null)) continue;
                specConfigStacks = this.pushFpConfig(specConfigStacks, configId);
            }
            this.configStack = null;
            boolean extendedStackLevel = false;
            if (!fpConfig.isTransitive()) {
                extendedStackLevel = this.processFpDepConfigs(this.currentOrigin.getSpec());
                if (this.currentOrigin.getSpec().hasDefaultPackages()) {
                    for (String packageName : this.currentOrigin.getSpec().getDefaultPackageNames()) {
                        if (this.fpConfigStack.isPackageFilteredOut(this.currentOrigin.producer, packageName)) continue;
                        this.resolvePackage(packageName, null, 4);
                    }
                }
            }
            if (!specConfigStacks.isEmpty()) {
                void var7_12;
                int n = specConfigStacks.size() - 1;
                while (var7_12 >= 0) {
                    configStack = (ConfigModelStack)specConfigStacks.get((int)var7_12);
                    this.processConfig(configStack, this.popConfig(configStack));
                    --var7_12;
                }
            }
            if (fpConfig.hasIncludedPackages()) {
                for (String pkgName : fpConfig.getIncludedPackages()) {
                    if (this.fpConfigStack.isPackageFilteredOut(this.currentOrigin.producer, pkgName)) continue;
                    this.resolvePackage(pkgName, null, 4);
                }
            }
            if (!fpConfigStacks.isEmpty()) {
                void var7_15;
                int n = fpConfigStacks.size() - 1;
                while (var7_15 >= 0) {
                    configStack = (ConfigModelStack)fpConfigStacks.get((int)var7_15);
                    this.processConfig(configStack, this.popConfig(configStack));
                    --var7_15;
                }
            }
            if (extendedStackLevel) {
                this.fpConfigStack.popLevel();
            }
        }
        finally {
            this.thisOrigin = parentFp;
            this.setOrigin(parentFp);
        }
    }

    private boolean processFpDepConfigs(FeaturePackDepsConfig fpSpec) throws ProvisioningException {
        if (!fpSpec.hasFeaturePackDeps() || !this.pushFpDepConfigs(fpSpec)) {
            return false;
        }
        while (this.fpConfigStack.hasNext()) {
            this.processFpConfig(this.fpConfigStack.next());
        }
        return true;
    }

    private boolean pushFpDepConfigs(FeaturePackDepsConfig fpSpec) {
        boolean extendedStackLevel = false;
        if (fpSpec.hasTransitiveDeps()) {
            extendedStackLevel = this.pushFpDepConfigs(fpSpec.getTransitiveDeps(), false);
        }
        extendedStackLevel |= this.pushFpDepConfigs(fpSpec.getFeaturePackDeps(), extendedStackLevel);
        return extendedStackLevel;
    }

    private boolean pushFpDepConfigs(Collection<FeaturePackConfig> fpConfigs, boolean extendedStackLevel) {
        for (FeaturePackConfig fpDep : fpConfigs) {
            extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
        }
        return extendedStackLevel;
    }

    private List<ConfigModelStack> pushFpConfig(List<ConfigModelStack> configStacks, ConfigId configId) throws ProvisioningException {
        ConfigModel config = this.currentOrigin.getConfig(configId);
        if (config != null) {
            configStacks = this.pushConfig(configStacks, config);
        }
        if ((config = this.currentOrigin.getSpec().getDefinedConfig(configId)) != null) {
            configStacks = this.pushConfig(configStacks, config);
        }
        return configStacks;
    }

    private List<ConfigModelStack> pushConfig(List<ConfigModelStack> configStacks, ConfigModel config) throws ProvisioningException {
        this.configStack.pushConfig(config);
        return CollectionUtils.add(configStacks, this.configStack);
    }

    private ConfigModel popConfig(ConfigModelStack configStack) throws ProvisioningException {
        ConfigModel config = configStack.peekAtConfig();
        if (config.hasIncludedLayers()) {
            for (String dep : config.getIncludedLayers()) {
                if (configStack.isLayerFilteredOut(dep)) continue;
                this.includeLayer(configStack, new ConfigId(config.getModel(), dep));
            }
        }
        return configStack.popConfig();
    }

    private void includeLayer(ConfigModelStack configStack, ConfigId layerId) throws ProvisioningException {
        if (!configStack.addLayer(layerId)) {
            return;
        }
        ConfigModelStack layerStack = this.resolveConfigLayer(layerId);
        if (layerStack.hasLayerDeps()) {
            for (ConfigLayerDependency layerDep : layerStack.getLayerDeps()) {
                if (configStack.isLayerExcluded(layerDep.getName())) {
                    if (layerDep.isOptional()) continue;
                    throw new ProvisioningException(Errors.unsatisfiedLayerDependency(layerId.getName(), layerDep.getName()));
                }
                this.includeLayer(configStack, new ConfigId(configStack.id.getModel(), layerDep.getName()));
            }
        }
        configStack.includedLayer(layerId);
        for (ResolvedFeature feature : layerStack.orderFeatures(false)) {
            if (configStack.isFilteredOut(feature.getSpecId(), feature.getId())) continue;
            configStack.includeFeature(feature.id, feature.spec, feature.params, feature.deps, feature.unsetParams, feature.resetParams);
        }
    }

    private ConfigModelStack resolveConfigLayer(ConfigId layerId) throws ProvisioningException {
        ConfigModelStack layerStack = this.layers.get(layerId);
        if (layerStack == null) {
            layerStack = new ConfigModelStack(layerId, this);
            boolean resolved = false;
            for (FeaturePackConfig fpConfig : this.config.getFeaturePackDeps()) {
                resolved |= this.resolveConfigLayer(fpConfig.getLocation().getProducer(), layerStack, layerId);
            }
            this.clearFlag(2);
            if (!resolved) {
                throw new ProvisioningException(Errors.layerNotFound(layerId));
            }
            this.layers = CollectionUtils.put(this.layers, layerId, layerStack);
        }
        return layerStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resolveConfigLayer(FeaturePackLocation.ProducerSpec producer, ConfigModelStack layerStack, ConfigId layerId) throws ProvisioningException {
        FeaturePackRuntimeBuilder fp = this.layout.getFeaturePack(producer);
        if (!this.setFlag(fp, 2)) {
            return fp.getConfigLayer(layerId) != null;
        }
        FeaturePackRuntimeBuilder prevOrigin = this.currentOrigin;
        try {
            boolean resolved;
            ConfigLayerSpec configLayer = fp.getConfigLayer(layerId);
            boolean bl = resolved = configLayer != null;
            if (resolved) {
                layerStack.pushGroup(configLayer);
            }
            if (fp.getSpec().hasFeaturePackDeps()) {
                for (FeaturePackConfig depConfig : fp.getSpec().getFeaturePackDeps()) {
                    resolved |= this.resolveConfigLayer(depConfig.getLocation().getProducer(), layerStack, layerId);
                }
            }
            if (configLayer != null) {
                this.setOrigin(fp);
                this.processConfigLayer(layerStack, this.popLayer(layerStack));
            }
            boolean bl2 = resolved;
            return bl2;
        }
        finally {
            this.setOrigin(prevOrigin);
        }
    }

    private FeatureGroupSupport popLayer(ConfigModelStack layerStack) throws ProvisioningException {
        FeatureGroupSupport fg = layerStack.peekAtGroup();
        if (!(fg instanceof ConfigLayerSpec)) {
            throw new ProvisioningException("Expected config layer but got " + fg);
        }
        ConfigLayerSpec layer = (ConfigLayerSpec)fg;
        if (layer.hasLayerDeps()) {
            for (ConfigLayerDependency dep : layer.getLayerDeps()) {
                layerStack.addLayerDep(dep);
            }
        }
        layerStack.popGroup();
        return fg;
    }

    private ConfigModelStack resolveModelOnlyConfig(ConfigId configId) throws ProvisioningException {
        boolean extendedStackLevel = false;
        if (this.config.hasTransitiveDeps()) {
            for (FeaturePackConfig fpDep : this.config.getTransitiveDeps()) {
                extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
            }
        }
        ConfigModelStack modelOnlyStack = null;
        for (FeaturePackConfig fpDep : this.config.getFeaturePackDeps()) {
            extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
            if (fpDep.isConfigModelExcluded(configId) || !fpDep.isInheritModelOnlyConfigs() && !fpDep.isConfigModelIncluded(configId)) continue;
            modelOnlyStack = this.resolveModelOnlyConfig(fpDep, modelOnlyStack, configId);
        }
        this.clearFlag(4);
        if (extendedStackLevel) {
            this.fpConfigStack.popLevel();
        }
        return modelOnlyStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigModelStack resolveModelOnlyConfig(FeaturePackConfig fpConfig, ConfigModelStack modelOnlyStack, ConfigId configId) throws ProvisioningException {
        FeaturePackRuntimeBuilder fp = this.layout.getFeaturePack(fpConfig.getLocation().getProducer());
        if (!this.setFlag(fp, 4)) {
            return modelOnlyStack;
        }
        FeaturePackRuntimeBuilder prevOrigin = this.currentOrigin;
        try {
            int pushedCount = 0;
            ConfigModel config = fpConfig.getDefinedConfig(configId);
            if (config != null) {
                if (modelOnlyStack == null) {
                    modelOnlyStack = new ConfigModelStack(configId, this);
                }
                modelOnlyStack.pushConfig(config);
                ++pushedCount;
            }
            if ((config = fp.getSpec().getDefinedConfig(configId)) != null) {
                if (modelOnlyStack == null) {
                    modelOnlyStack = new ConfigModelStack(configId, this);
                }
                modelOnlyStack.pushConfig(config);
                ++pushedCount;
            }
            if ((config = fp.getConfig(configId)) != null) {
                if (modelOnlyStack == null) {
                    modelOnlyStack = new ConfigModelStack(configId, this);
                }
                modelOnlyStack.pushConfig(config);
                ++pushedCount;
            }
            boolean extendedStackLevel = false;
            if (fp.getSpec().hasTransitiveDeps()) {
                for (FeaturePackConfig fpDep : fp.getSpec().getTransitiveDeps()) {
                    extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
                }
            }
            if (fp.getSpec().hasFeaturePackDeps()) {
                for (FeaturePackConfig fpDep : fp.getSpec().getFeaturePackDeps()) {
                    extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
                    if (fpDep.isConfigModelExcluded(configId) || !fpDep.isInheritModelOnlyConfigs() && !fpDep.isConfigModelIncluded(configId)) continue;
                    modelOnlyStack = this.resolveModelOnlyConfig(fpDep, modelOnlyStack, configId);
                }
            }
            while (pushedCount > 0) {
                this.setOrigin(fp);
                this.processConfig(modelOnlyStack, this.popConfig(modelOnlyStack));
                --pushedCount;
            }
            if (extendedStackLevel) {
                this.fpConfigStack.popLevel();
            }
        }
        finally {
            this.setOrigin(prevOrigin);
        }
        return modelOnlyStack;
    }

    private void processConfig(ConfigModelStack configStack, ConfigModel config) throws ProvisioningException {
        this.configStack = configStack;
        configStack.overwriteProps(config.getProperties());
        configStack.overwriteConfigDeps(config.getConfigDeps());
        try {
            if (config.hasPackageDeps()) {
                if (this.currentOrigin == null) {
                    throw new ProvisioningDescriptionException(Errors.topConfigsCantDefinePackageDeps(config.getId()));
                }
                this.processPackageDeps(config, null);
            }
            this.processConfigItemContainer(config);
            this.configStack = null;
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToResolveConfigSpec(config.getModel(), config.getName()), e);
        }
    }

    private void processConfigLayer(ConfigModelStack configStack, FeatureGroupSupport layer) throws ProvisioningException {
        this.configStack = configStack;
        try {
            if (layer.hasPackageDeps()) {
                this.processPackageDeps(layer, null);
            }
            this.processConfigItemContainer(layer);
            this.configStack = null;
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToResolveConfigLayer(configStack.id.getModel(), layer.getName()), e);
        }
    }

    private ConfigModelStack getConfigStack(ConfigId id) throws ProvisioningException {
        if (id.getName() == null) {
            throw new IllegalStateException("Config model not associated with a name");
        }
        if (id.getModel() == null) {
            this.configStack = this.nameOnlyConfigs.get(id.getName());
            if (this.configStack == null) {
                this.configStack = new ConfigModelStack(id, this);
                this.nameOnlyConfigs = CollectionUtils.putLinked(this.nameOnlyConfigs, id.getName(), this.configStack);
            }
            return this.configStack;
        }
        Map<String, ConfigModelStack> namedConfigs = this.namedModelConfigs.get(id.getModel());
        if (namedConfigs == null) {
            this.configStack = new ConfigModelStack(id, this);
            namedConfigs = Collections.singletonMap(id.getName(), this.configStack);
            this.namedModelConfigs = CollectionUtils.putLinked(this.namedModelConfigs, id.getModel(), namedConfigs);
            return this.configStack;
        }
        this.configStack = namedConfigs.get(id.getName());
        if (this.configStack != null) {
            return this.configStack;
        }
        if (namedConfigs.size() == 1) {
            namedConfigs = new LinkedHashMap<String, ConfigModelStack>(namedConfigs);
            if (this.namedModelConfigs.size() == 1) {
                this.namedModelConfigs = new LinkedHashMap<String, Map<String, ConfigModelStack>>(this.namedModelConfigs);
            }
            this.namedModelConfigs.put(id.getModel(), namedConfigs);
        }
        this.configStack = new ConfigModelStack(id, this);
        namedConfigs.put(id.getName(), this.configStack);
        return this.configStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFeatureGroup(FeatureGroupSupport includedFg) throws ProvisioningException {
        boolean pushed = this.configStack.pushGroup(includedFg);
        FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
        try {
            FeatureGroup originalFg = this.getFeatureGroupSpec(includedFg.getName());
            if (originalFg.hasPackageDeps()) {
                this.processPackageDeps(originalFg, null);
            }
            if (!pushed) {
                return;
            }
            this.processConfigItemContainer(originalFg);
        }
        finally {
            this.currentOrigin = originalOrigin;
        }
        this.configStack.popGroup();
        if (includedFg.hasItems()) {
            this.processConfigItemContainer(includedFg);
        }
    }

    private FeaturePackRuntimeBuilder setOrigin(String origin) throws ProvisioningException {
        return origin == null ? this.currentOrigin : this.setOrigin(this.getOrigin(origin));
    }

    FeaturePackRuntimeBuilder setOrigin(FeaturePackRuntimeBuilder origin) {
        FeaturePackRuntimeBuilder prevOrigin = this.currentOrigin;
        this.currentOrigin = origin;
        return prevOrigin;
    }

    FeaturePackRuntimeBuilder getOrigin(String depName) throws ProvisioningException {
        if ("this".equals(depName)) {
            if (this.thisOrigin == null) {
                throw new ProvisioningException("Feature-pack reference 'this' cannot be used in the current context.");
            }
            return this.thisOrigin;
        }
        FeaturePackLocation fpl = this.currentOrigin == null ? this.config.getFeaturePackDep(depName).getLocation() : this.currentOrigin.getSpec().getFeaturePackDep(depName).getLocation();
        return this.layout.getFeaturePack(fpl.getProducer());
    }

    private FeaturePackRuntimeBuilder setThisOrigin(FeaturePackRuntimeBuilder origin) {
        FeaturePackRuntimeBuilder prevOrigin = this.thisOrigin;
        this.thisOrigin = origin;
        return prevOrigin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolvedFeatureGroupConfig resolveFeatureGroupConfig(ConfigModelStack configStack, FeatureGroupSupport fg) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec fgOrigin = null;
        if (!fg.isConfig() && !fg.isLayer()) {
            FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
            this.getFeatureGroupSpec(fg.getName());
            fgOrigin = this.currentOrigin.producer;
            this.currentOrigin = originalOrigin;
        }
        ResolvedFeatureGroupConfig resolvedFgc = new ResolvedFeatureGroupConfig(configStack, fg, fgOrigin);
        resolvedFgc.inheritFeatures = fg.isInheritFeatures();
        if (fg.hasExcludedSpecs()) {
            resolvedFgc.excludedSpecs = this.resolveSpecIds(resolvedFgc.excludedSpecs, fg.getExcludedSpecs());
        }
        if (fg.hasIncludedSpecs()) {
            resolvedFgc.includedSpecs = this.resolveSpecIds(resolvedFgc.includedSpecs, fg.getIncludedSpecs());
        }
        if (fg.hasExcludedFeatures()) {
            resolvedFgc.excludedFeatures = this.resolveExcludedIds(resolvedFgc.excludedFeatures, fg.getExcludedFeatures());
        }
        if (fg.hasIncludedFeatures()) {
            resolvedFgc.includedFeatures = this.resolveIncludedIds(resolvedFgc.includedFeatures, fg.getIncludedFeatures());
        }
        if (fg.hasExternalFeatureGroups()) {
            FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
            for (Map.Entry<String, FeatureGroup> entry : fg.getExternalFeatureGroups().entrySet()) {
                FeatureGroup extFg = entry.getValue();
                this.setOrigin(entry.getKey());
                try {
                    if (extFg.hasExcludedSpecs()) {
                        resolvedFgc.excludedSpecs = this.resolveSpecIds(resolvedFgc.excludedSpecs, extFg.getExcludedSpecs());
                    }
                    if (extFg.hasIncludedSpecs()) {
                        resolvedFgc.includedSpecs = this.resolveSpecIds(resolvedFgc.includedSpecs, extFg.getIncludedSpecs());
                    }
                    if (extFg.hasExcludedFeatures()) {
                        resolvedFgc.excludedFeatures = this.resolveExcludedIds(resolvedFgc.excludedFeatures, extFg.getExcludedFeatures());
                    }
                    if (!extFg.hasIncludedFeatures()) continue;
                    resolvedFgc.includedFeatures = this.resolveIncludedIds(resolvedFgc.includedFeatures, extFg.getIncludedFeatures());
                }
                finally {
                    this.setOrigin(originalOrigin);
                }
            }
        }
        return resolvedFgc;
    }

    void processIncludedFeatures(ResolvedFeatureGroupConfig pushedFgConfig) throws ProvisioningException {
        if (pushedFgConfig.includedFeatures.isEmpty()) {
            return;
        }
        for (Map.Entry<ResolvedFeatureId, FeatureConfig> feature : pushedFgConfig.includedFeatures.entrySet()) {
            ResolvedFeatureId includedId;
            FeatureConfig includedFc = feature.getValue();
            if (includedFc == null || !includedFc.hasParams() || pushedFgConfig.configStack.isFilteredOut(includedId.specId, includedId = feature.getKey())) continue;
            if (!pushedFgConfig.configStack.includes(includedId)) {
                throw new ProvisioningException(Errors.featureNotInScope(includedId, pushedFgConfig.fg.getId() == null ? "'anonymous'" : pushedFgConfig.fg.getId().toString(), this.currentOrigin == null ? null : this.currentOrigin.producer.getLocation().getFPID()));
            }
            this.resolveFeature(pushedFgConfig.configStack, includedFc);
        }
    }

    private Map<ResolvedFeatureId, FeatureConfig> resolveIncludedIds(Map<ResolvedFeatureId, FeatureConfig> includedFeatures, Map<FeatureId, FeatureConfig> features) throws ProvisioningException {
        for (Map.Entry<FeatureId, FeatureConfig> included : features.entrySet()) {
            FeatureConfig fc = new FeatureConfig(included.getValue());
            ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(fc.getSpecId().getName());
            if (this.parentFeature != null) {
                includedFeatures = CollectionUtils.put(includedFeatures, resolvedSpec.resolveIdFromForeignKey(this.parentFeature.id, fc.getParentRef(), fc.getParams()), fc);
                continue;
            }
            includedFeatures = CollectionUtils.put(includedFeatures, resolvedSpec.resolveFeatureId(fc.getParams()), fc);
        }
        return includedFeatures;
    }

    private Set<ResolvedFeatureId> resolveExcludedIds(Set<ResolvedFeatureId> resolvedIds, Map<FeatureId, String> features) throws ProvisioningException {
        for (Map.Entry<FeatureId, String> excluded : features.entrySet()) {
            FeatureId excludedId = excluded.getKey();
            ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(excludedId.getSpec().getName());
            if (this.parentFeature != null) {
                resolvedIds = CollectionUtils.add(resolvedIds, resolvedSpec.resolveIdFromForeignKey(this.parentFeature.id, excluded.getValue(), excludedId.getParams()));
                continue;
            }
            resolvedIds = CollectionUtils.add(resolvedIds, resolvedSpec.resolveFeatureId(excludedId.getParams()));
        }
        return resolvedIds;
    }

    private Set<ResolvedSpecId> resolveSpecIds(Set<ResolvedSpecId> resolvedIds, Set<SpecId> specs) throws ProvisioningException {
        for (SpecId specId : specs) {
            resolvedIds = CollectionUtils.add(resolvedIds, this.getFeatureSpec((String)specId.getName()).id);
        }
        return resolvedIds;
    }

    private void processConfigItemContainer(ConfigItemContainer ciContainer) throws ProvisioningException {
        if (!ciContainer.hasItems()) {
            return;
        }
        FeaturePackRuntimeBuilder prevFpOrigin = ciContainer.isResetFeaturePackOrigin() ? this.setThisOrigin(this.currentOrigin) : null;
        for (ConfigItem item : ciContainer.getItems()) {
            FeaturePackRuntimeBuilder originalFp = this.setOrigin(item.getOrigin());
            try {
                if (item.isGroup()) {
                    this.processFeatureGroup((FeatureGroup)item);
                    continue;
                }
                this.resolveFeature(this.configStack, (FeatureConfig)item);
            }
            catch (ProvisioningException e) {
                if (this.currentOrigin == null) {
                    throw e;
                }
                throw new ProvisioningException(item.isGroup() ? Errors.failedToProcess(this.currentOrigin.producer.getLocation().getFPID(), ((FeatureGroup)item).getName()) : Errors.failedToProcess(this.currentOrigin.producer.getLocation().getFPID(), (FeatureConfig)item), e);
            }
            finally {
                this.setOrigin(originalFp);
            }
        }
        if (prevFpOrigin != null) {
            this.setThisOrigin(prevFpOrigin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveFeature(ConfigModelStack configStack, FeatureConfig fc) throws ProvisioningException {
        FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
        ResolvedFeatureSpec spec = this.getFeatureSpec(fc.getSpecId().getName(), true);
        ResolvedFeature originalParent = this.parentFeature;
        try {
            ResolvedFeatureId resolvedId;
            ResolvedFeatureId resolvedFeatureId = resolvedId = this.parentFeature == null ? spec.resolveFeatureId(fc.getParams()) : spec.resolveIdFromForeignKey(this.parentFeature.id, fc.getParentRef(), fc.getParams());
            if (configStack.isFilteredOut(spec.id, resolvedId)) {
                return;
            }
            this.parentFeature = this.resolveFeatureDepsAndRefs(configStack, spec, resolvedId, spec.resolveNonIdParams(this.parentFeature == null ? null : this.parentFeature.id, fc.getParentRef(), fc.getParams()), fc.getFeatureDeps());
            if (fc.hasUnsetParams()) {
                this.parentFeature.unsetAllParams(fc.getUnsetParams(), true);
            }
            if (fc.hasResetParams()) {
                this.parentFeature.resetAllParams(fc.getResetParams());
            }
        }
        finally {
            this.currentOrigin = originalOrigin;
        }
        this.processConfigItemContainer(fc);
        this.parentFeature = originalParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedFeature resolveFeatureDepsAndRefs(ConfigModelStack configStack, ResolvedFeatureSpec spec, ResolvedFeatureId resolvedId, Map<String, Object> resolvedParams, Collection<FeatureDependencySpec> featureDeps) throws ProvisioningException {
        if (spec.xmlSpec.hasPackageDeps()) {
            this.processPackageDeps(spec.xmlSpec, null);
        }
        ResolvedFeature resolvedFeature = configStack.includeFeature(resolvedId, spec, resolvedParams, this.resolveFeatureDeps(configStack, featureDeps, spec), Collections.emptySet(), Collections.emptySet());
        if (spec.xmlSpec.hasFeatureRefs()) {
            ResolvedFeature myParent = this.parentFeature;
            this.parentFeature = resolvedFeature;
            for (FeatureReferenceSpec refSpec : spec.xmlSpec.getFeatureRefs()) {
                if (!refSpec.isInclude()) continue;
                FeaturePackRuntimeBuilder originalFp = this.setOrigin(refSpec.getOrigin());
                try {
                    ResolvedFeatureSpec refResolvedSpec = this.getFeatureSpec(refSpec.getFeature().getName());
                    List<ResolvedFeatureId> refIds = spec.resolveRefId(this.parentFeature, refSpec, refResolvedSpec);
                    if (refIds.isEmpty()) continue;
                    for (ResolvedFeatureId refId : refIds) {
                        if (configStack.includes(refId) || configStack.isFilteredOut(refId.specId, refId)) continue;
                        this.resolveFeatureDepsAndRefs(configStack, refResolvedSpec, refId, Collections.emptyMap(), Collections.emptyList());
                    }
                }
                finally {
                    this.setOrigin(originalFp);
                }
            }
            this.parentFeature = myParent;
        }
        return resolvedFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ResolvedFeatureId, FeatureDependencySpec> resolveFeatureDeps(ConfigModelStack configStack, Collection<FeatureDependencySpec> featureDeps, ResolvedFeatureSpec spec) throws ProvisioningException {
        Map<ResolvedFeatureId, FeatureDependencySpec> resolvedDeps = spec.resolveFeatureDeps(this, featureDeps);
        if (!resolvedDeps.isEmpty()) {
            for (Map.Entry<ResolvedFeatureId, FeatureDependencySpec> dep : resolvedDeps.entrySet()) {
                ResolvedFeatureId depId;
                if (!dep.getValue().isInclude() || configStack.includes(depId = dep.getKey()) || configStack.isFilteredOut(depId.specId, depId)) continue;
                FeatureDependencySpec depSpec = dep.getValue();
                FeaturePackRuntimeBuilder originalFp = this.setOrigin(depSpec.getOrigin());
                try {
                    this.resolveFeatureDepsAndRefs(configStack, this.getFeatureSpec(depId.getSpecId().getName()), depId, Collections.emptyMap(), Collections.emptyList());
                }
                finally {
                    this.setOrigin(originalFp);
                }
            }
        }
        return resolvedDeps;
    }

    private void resolvePackage(String pkgName, PackageRuntime.Builder parent, int type) throws ProvisioningException {
        int offset = this.resolvedPkgBranch.size();
        boolean resolved = false;
        try {
            this.currentOrigin.setFlag(1);
            resolved = this.resolvePackage(this.currentOrigin, pkgName, parent, type);
            if (resolved) {
                if (offset == 0) {
                    for (int i = this.resolvedPkgBranch.size() - 1; i >= 0; --i) {
                        PackageRuntime.Builder pkg = this.resolvedPkgBranch.get(i);
                        pkg.schedule();
                        pkg.clearFlag(1);
                    }
                    this.resolvedPkgBranch.clear();
                }
                return;
            }
        }
        catch (UnsatisfiedPackageDependencyException e) {
            if (PackageDependencySpec.isOptional(type)) {
                return;
            }
            throw e;
        }
        finally {
            if (!resolved) {
                int i = this.resolvedPkgBranch.size() - offset;
                while (i > 0) {
                    this.resolvedPkgBranch.remove(offset + --i).clearFlag(1);
                }
            }
            this.clearFlag(1);
            this.currentOrigin.clearFlag(1);
        }
        throw new ProvisioningDescriptionException(Errors.packageNotFound(this.currentOrigin.producer.getLocation().getFPID(), pkgName));
    }

    private boolean resolvePackage(FeaturePackRuntimeBuilder origin, String name, PackageRuntime.Builder parent, int type) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            if (origin.resolvePackage(name, this, parent, type)) {
                return true;
            }
            fpDeps = origin.getSpec();
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return false;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            FeaturePackRuntimeBuilder fpDepBuilder = this.layout.getFeaturePack(fpDep.getLocation().getProducer());
            if (!this.setFlag(fpDepBuilder, 1) || !this.resolvePackage(fpDepBuilder, name, parent, type)) continue;
            return true;
        }
        return false;
    }

    boolean addToPkgDepBranch(PackageRuntime.Builder pkg) {
        if (pkg.setFlag(1)) {
            this.resolvedPkgBranch.add(pkg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPackageDeps(PackageDepsSpec pkgDeps, PackageRuntime.Builder parent) throws ProvisioningException {
        if (pkgDeps.hasLocalPackageDeps()) {
            for (PackageDependencySpec dep : pkgDeps.getLocalPackageDeps()) {
                if (this.fpConfigStack.isPackageExcluded(this.currentOrigin.producer, dep.getName())) {
                    if (dep.isOptional()) continue;
                    throw new UnsatisfiedPackageDependencyException(this.currentOrigin.getFPID(), dep.getName());
                }
                if ((this.pkgDepMask & dep.getType()) <= 0) continue;
                this.resolvePackage(dep.getName(), parent, dep.getType());
            }
        }
        if (!pkgDeps.hasExternalPackageDeps()) {
            return;
        }
        for (String origin : pkgDeps.getPackageOrigins()) {
            FeaturePackRuntimeBuilder originalFp = this.setOrigin(origin);
            try {
                for (PackageDependencySpec dep : pkgDeps.getExternalPackageDeps(origin)) {
                    if (this.fpConfigStack.isPackageExcluded(this.currentOrigin.producer, dep.getName())) {
                        if (dep.isOptional()) continue;
                        throw new UnsatisfiedPackageDependencyException(this.currentOrigin.getFPID(), dep.getName());
                    }
                    if ((this.pkgDepMask & dep.getType()) <= 0) continue;
                    this.resolvePackage(dep.getName(), parent, dep.getType());
                }
            }
            finally {
                this.setOrigin(originalFp);
            }
        }
    }

    List<ProvisionedConfig> getResolvedConfigs() throws ProvisioningException {
        int configsTotal = this.configsToBuild.size();
        if (configsTotal == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProvisionedConfig> configList = new ArrayList<ProvisionedConfig>(configsTotal);
        this.buildConfigs(configList, this.configsToBuild.entrySet());
        return configList.size() > 0 ? Collections.unmodifiableList(configList) : configList;
    }

    private void buildConfigs(List<ProvisionedConfig> configList, Set<Map.Entry<ConfigId, ConfigModelStack>> configStacks) throws ProvisioningException {
        for (Map.Entry<ConfigId, ConfigModelStack> entry : configStacks) {
            ConfigId id = entry.getKey();
            if (id.getName() == null || this.contains(configList, id)) continue;
            this.orderConfig(entry.getValue(), configList, Collections.emptySet());
        }
    }

    private void orderConfig(ConfigModelStack config, List<ProvisionedConfig> configList, Set<ConfigId> scheduledIds) throws ProvisioningException {
        if (!config.hasConfigDeps()) {
            configList.add(ResolvedConfig.build(config));
            return;
        }
        scheduledIds = CollectionUtils.add(scheduledIds, config.id);
        for (ConfigId depId : config.getConfigDeps().values()) {
            ConfigModelStack configStack;
            if (scheduledIds.contains(depId) || this.contains(configList, depId)) continue;
            if (depId.isModelOnly()) {
                Map<String, ConfigModelStack> configs = this.namedModelConfigs.get(depId.getModel());
                if (configs == null) {
                    throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
                }
                for (ConfigModelStack dep : configs.values()) {
                    if (this.contains(configList, dep.id)) continue;
                    this.orderConfig(dep, configList, scheduledIds);
                }
                continue;
            }
            if (depId.getModel() == null) {
                configStack = this.nameOnlyConfigs.get(depId.getName());
            } else {
                Map<String, ConfigModelStack> configs = this.namedModelConfigs.get(depId.getModel());
                if (configs == null) {
                    throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
                }
                configStack = configs.get(depId.getName());
            }
            if (configStack == null) {
                throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
            }
            if (this.contains(configList, configStack.id)) continue;
            this.orderConfig(configStack, configList, scheduledIds);
        }
        scheduledIds = CollectionUtils.remove(scheduledIds, config.id);
        configList.add(ResolvedConfig.build(config));
    }

    private boolean contains(List<ProvisionedConfig> configList, ConfigId depId) {
        int i = 0;
        while (i < configList.size()) {
            if (!((ResolvedConfig)configList.get((int)i++)).id.equals(depId)) continue;
            return true;
        }
        return false;
    }

    private FeatureGroup getFeatureGroupSpec(String name) throws ProvisioningException {
        FeatureGroup fg = this.getFeatureGroupSpec(this.currentOrigin, name);
        this.clearFlag(1);
        if (fg == null) {
            throw new ProvisioningDescriptionException("Failed to locate feature group '" + name + "' in " + (this.currentOrigin == null ? "the provisioning configuration" : this.currentOrigin.producer + " and its dependencies"));
        }
        return fg;
    }

    private FeatureGroup getFeatureGroupSpec(FeaturePackRuntimeBuilder origin, String name) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            if (origin.isFlagOn(1)) {
                return null;
            }
            FeatureGroup fg = origin.getFeatureGroupSpec(name);
            if (fg != null) {
                this.currentOrigin = origin;
                return fg;
            }
            fpDeps = origin.getSpec();
            this.setFlag(origin, 1);
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return null;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            FeatureGroup fg = this.getFeatureGroupSpec(this.layout.getFeaturePack(fpDep.getLocation().getProducer()), name);
            if (fg == null) continue;
            return fg;
        }
        return null;
    }

    private ResolvedFeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        return this.getFeatureSpec(name, false);
    }

    private ResolvedFeatureSpec getFeatureSpec(String name, boolean switchOrigin) throws ProvisioningException {
        return this.getFeatureSpec(this.currentOrigin, name, switchOrigin);
    }

    ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name) throws ProvisioningException {
        return this.getFeatureSpec(origin, name, false);
    }

    private ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name, boolean switchOrigin) throws ProvisioningException {
        ResolvedFeatureSpec resolvedSpec = this.findFeatureSpec(origin, name, switchOrigin);
        this.clearFlag(1);
        if (resolvedSpec == null) {
            if (origin == null) {
                throw new ProvisioningDescriptionException("Failed to locate feature spec '" + name + "' in the installed feature-packs.");
            }
            throw new ProvisioningDescriptionException("Failed to locate feature spec '" + name + "' in " + origin.producer + " and its dependencies.");
        }
        return resolvedSpec;
    }

    private ResolvedFeatureSpec findFeatureSpec(FeaturePackRuntimeBuilder origin, String name, boolean switchOrigin) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            if (origin.isFlagOn(1)) {
                return null;
            }
            ResolvedFeatureSpec fs = origin.getFeatureSpec(name);
            if (fs != null) {
                if (switchOrigin) {
                    this.currentOrigin = origin;
                }
                return fs;
            }
            fpDeps = origin.getSpec();
            this.setFlag(origin, 1);
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return null;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            ResolvedFeatureSpec fs = this.findFeatureSpec(this.layout.getFeaturePack(fpDep.getLocation().getProducer()), name, switchOrigin);
            if (fs == null) continue;
            return fs;
        }
        return null;
    }

    private boolean setFlag(FeaturePackRuntimeBuilder fp, int flag) {
        if (fp.setFlag(flag)) {
            if (fp.getFlags() == flag) {
                this.visited.add(fp);
            }
            return true;
        }
        return false;
    }

    private void clearFlag(int flag) {
        if (!this.visited.isEmpty()) {
            for (int i = this.visited.size() - 1; i >= 0; --i) {
                if (this.visited.get(i).clearFlag(flag) != 0) continue;
                this.visited.remove(i);
            }
        }
    }
}

