/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.type.builtin;

import org.jboss.galleon.type.FeatureParameterType;
import org.jboss.galleon.type.ParameterTypeNotFoundException;
import org.jboss.galleon.type.ParameterTypeProvider;
import org.jboss.galleon.type.builtin.FormattedParameterType;
import org.jboss.galleon.type.builtin.StringParameterType;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.formatparser.FormatParser;
import org.jboss.galleon.util.formatparser.FormatParsingException;

public class BuiltInParameterTypeProvider
implements ParameterTypeProvider {
    private static final BuiltInParameterTypeProvider INSTANCE = new BuiltInParameterTypeProvider();

    public static BuiltInParameterTypeProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public FeatureParameterType getType(FeaturePackLocation.ProducerSpec producer, String name) throws ParameterTypeNotFoundException {
        if ("String".equals(name)) {
            return StringParameterType.getInstance();
        }
        try {
            return new FormattedParameterType(FormatParser.resolveFormat(name));
        }
        catch (FormatParsingException e) {
            throw new ParameterTypeNotFoundException("Failed to resolve parameter type " + name, e);
        }
    }
}

