/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeaturePackSpec
extends FeaturePackDepsConfig {
    private final FeaturePackLocation.FPID fpid;
    private final Set<String> defPackages;
    private final Map<String, FeaturePackPlugin> plugins;
    private final FeaturePackLocation.FPID patchFor;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FeaturePackLocation.FPID fpid) {
        return new Builder().setFPID(fpid);
    }

    protected FeaturePackSpec(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.fpid = builder.fpid;
        this.defPackages = CollectionUtils.unmodifiable(builder.defPackages);
        this.plugins = CollectionUtils.unmodifiable(builder.plugins);
        this.patchFor = builder.patchFor;
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public boolean isPatch() {
        return this.patchFor != null;
    }

    public FeaturePackLocation.FPID getPatchFor() {
        return this.patchFor;
    }

    public boolean hasDefaultPackages() {
        return !this.defPackages.isEmpty();
    }

    public Set<String> getDefaultPackageNames() {
        return this.defPackages;
    }

    public boolean isDefaultPackage(String name) {
        return this.defPackages.contains(name);
    }

    public boolean hasPlugins() {
        return !this.plugins.isEmpty();
    }

    public Map<String, FeaturePackPlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defPackages == null ? 0 : this.defPackages.hashCode());
        result = 31 * result + (this.fpid == null ? 0 : this.fpid.hashCode());
        result = 31 * result + (this.patchFor == null ? 0 : this.patchFor.hashCode());
        result = 31 * result + (this.plugins == null ? 0 : this.plugins.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackSpec other = (FeaturePackSpec)obj;
        if (this.defPackages == null ? other.defPackages != null : !this.defPackages.equals(other.defPackages)) {
            return false;
        }
        if (this.fpid == null ? other.fpid != null : !this.fpid.equals(other.fpid)) {
            return false;
        }
        if (this.patchFor == null ? other.patchFor != null : !this.patchFor.equals(other.patchFor)) {
            return false;
        }
        return !(this.plugins == null ? other.plugins != null : !this.plugins.equals(other.plugins));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.fpid);
        if (this.patchFor != null) {
            buf.append(" patch-for=").append(this.patchFor);
        }
        if (!this.fpDeps.isEmpty()) {
            StringUtils.append(buf.append(" dependencies="), this.fpDeps.keySet());
        }
        if (!this.definedConfigs.isEmpty()) {
            StringUtils.append(buf.append(" defaultConfigs="), this.definedConfigs.values());
        }
        if (!this.defPackages.isEmpty()) {
            StringUtils.append(buf.append(" defaultPackages="), this.defPackages);
        }
        if (!this.plugins.isEmpty()) {
            StringUtils.append(buf.append(" plugins="), this.plugins.values());
        }
        return buf.append("]").toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private FeaturePackLocation.FPID fpid;
        private Set<String> defPackages = Collections.emptySet();
        private FeaturePackLocation.FPID patchFor;
        private Map<String, FeaturePackPlugin> plugins = Collections.emptyMap();

        protected Builder() {
        }

        public Builder setFPID(FeaturePackLocation.FPID fpid) {
            this.fpid = fpid;
            return this;
        }

        public FeaturePackLocation.FPID getFPID() {
            return this.fpid;
        }

        public Builder setPatchFor(FeaturePackLocation.FPID patchFor) {
            if (patchFor.getBuild() == null) {
                throw new IllegalArgumentException("FPID is missing build number");
            }
            this.patchFor = patchFor;
            return this;
        }

        @Override
        public boolean hasDefaultUniverse() {
            return true;
        }

        @Override
        public UniverseSpec getDefaultUniverse() {
            return this.defaultUniverse == null ? this.fpid.getLocation().getUniverse() : this.defaultUniverse;
        }

        public Builder addDefaultPackage(String packageName) {
            assert (packageName != null) : "packageName is null";
            this.defPackages = CollectionUtils.addLinked(this.defPackages, packageName);
            return this;
        }

        public Builder addPlugin(FeaturePackPlugin plugin) {
            this.plugins = CollectionUtils.putLinked(this.plugins, plugin.getId(), plugin);
            return this;
        }

        public FeaturePackSpec build() throws ProvisioningDescriptionException {
            try {
                return new FeaturePackSpec(this);
            }
            catch (ProvisioningDescriptionException e) {
                throw new ProvisioningDescriptionException("Failed to build feature-pack spec for " + this.fpid, e);
            }
        }
    }
}

