/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.Execution;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.ProcessManager;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Signal;
import org.aesh.utils.Config;

public class Process
extends Thread
implements Consumer<Signal> {
    private final Connection conn;
    private final Execution<? extends CommandInvocation> execution;
    private final ProcessManager manager;
    private volatile boolean running;
    private static final Logger LOGGER = LoggerUtil.getLogger(Process.class.getName());
    private int pid;

    public Process(ProcessManager manager, Connection conn, Execution<? extends CommandInvocation> execution) {
        this.manager = manager;
        this.conn = conn;
        this.execution = execution;
    }

    @Override
    public void accept(Signal signal) {
        switch (signal) {
            case INT: {
                if (!this.running) break;
                LOGGER.info("got interrupted in Task");
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Consumer<Signal> prev = this.conn.getSignalHandler();
        Consumer<int[]> prevIn = this.conn.getStdinHandler();
        this.conn.setSignalHandler(this);
        this.running = true;
        this.pid = (int)Thread.currentThread().getId();
        try {
            this.execution.execute();
        }
        catch (CommandException | CommandLineParserException | CommandValidatorException | OptionValidatorException e) {
            this.execution.setResut(CommandResult.FAILURE);
            this.conn.write(e.getMessage() + Config.getLineSeparator());
        }
        catch (InterruptedException e) {
            this.execution.setResut(CommandResult.FAILURE);
        }
        catch (Exception e) {
            this.execution.setResut(CommandResult.FAILURE);
            this.conn.write(e.getMessage() + Config.getLineSeparator());
            LOGGER.log(Level.WARNING, "Uncaught exception when executing the command: " + this.execution.getCommand().toString(), e);
        }
        finally {
            this.running = false;
            this.conn.setSignalHandler(prev);
            this.conn.setStdinHandler(prevIn);
            this.manager.processFinished(this);
        }
    }

    public Execution<? extends CommandInvocation> execution() {
        return this.execution;
    }

    public int pid() {
        return this.pid;
    }
}

