/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.rtinfo.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

@Component(role=RuntimeInformation.class)
public class DefaultRuntimeInformation
implements RuntimeInformation {
    @Requirement
    private Logger logger;
    private String mavenVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMavenVersion() {
        if (this.mavenVersion == null) {
            Properties props = new Properties();
            String resource = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
            InputStream is = DefaultRuntimeInformation.class.getResourceAsStream("/" + resource);
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    String msg = "Could not parse " + resource + ", Maven runtime information not available";
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn(msg, e);
                    }
                    this.logger.warn(msg);
                }
                finally {
                    IOUtil.close(is);
                }
            } else {
                this.logger.warn("Could not locate " + resource + " on classpath, Maven runtime information not available");
            }
            String version = props.getProperty("version", "").trim();
            this.mavenVersion = !version.startsWith("${") ? version : "";
        }
        return this.mavenVersion;
    }

    @Override
    public boolean isMavenVersion(String versionRange) {
        Version current;
        VersionConstraint constraint;
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        if (versionRange == null) {
            throw new IllegalArgumentException("Version range must not be null");
        }
        if (StringUtils.isBlank(versionRange)) {
            throw new IllegalArgumentException("Version range must not be empty");
        }
        try {
            constraint = versionScheme.parseVersionConstraint(versionRange);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            String mavenVersion = this.getMavenVersion();
            if (mavenVersion.length() <= 0) {
                throw new IllegalStateException("Could not determine current Maven version");
            }
            current = versionScheme.parseVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("Could not parse current Maven version: " + e.getMessage(), e);
        }
        if (constraint.getRange() == null) {
            return constraint.getVersion().compareTo(current) <= 0;
        }
        return constraint.containsVersion(current);
    }
}

