/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.util.CollectionUtils;

public class ProvisioningOption {
    public static final ProvisioningOption OPTIONAL_PACKAGES = ProvisioningOption.builder("optional-packages").setDefaultValue("all").addToValueSet("all").addToValueSet("none").addToValueSet("passive").addToValueSet("passive+").build();
    public static final ProvisioningOption VERSION_CONVERGENCE = ProvisioningOption.builder("version-convergence").setDefaultValue("first-processed").addToValueSet("first-processed").addToValueSet("fail").build();
    public static final ProvisioningOption IGNORE_NOT_EXCLUDED_LAYERS = ProvisioningOption.builder("ignore-not-excluded-layers").setDefaultValue("false").setBooleanValueSet().build();
    public static final ProvisioningOption STORE_INPUT_PROVISIONING_CONFIG = ProvisioningOption.builder("store-input-provisioning-config").setDefaultValue("false").setBooleanValueSet().build();
    public static final ProvisioningOption PRINT_ONLY_CONFLICTS = ProvisioningOption.builder("print-only-conflicts").setDefaultValue("true").setBooleanValueSet().build();
    private static final List<ProvisioningOption> stdOptions = Arrays.asList(IGNORE_NOT_EXCLUDED_LAYERS, OPTIONAL_PACKAGES, VERSION_CONVERGENCE, PRINT_ONLY_CONFLICTS, STORE_INPUT_PROVISIONING_CONFIG);
    private static Set<String> valueSetBoolean;
    private final String name;
    private final boolean required;
    private final boolean persistent;
    private final String defaultValue;
    private final Set<String> valueSet;

    public static List<ProvisioningOption> getStandardList() {
        return stdOptions;
    }

    public static Set<String> getBooleanValueSet() {
        return valueSetBoolean == null ? (valueSetBoolean = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("true", "false")))) : valueSetBoolean;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    protected ProvisioningOption(String name) {
        this.name = name;
        this.required = false;
        this.persistent = true;
        this.defaultValue = null;
        this.valueSet = ProvisioningOption.getBooleanValueSet();
    }

    protected ProvisioningOption(Builder builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.persistent = builder.persistent;
        this.defaultValue = builder.defaultValue;
        this.valueSet = CollectionUtils.unmodifiable(builder.valueSet);
        if (!this.valueSet.isEmpty() && this.defaultValue != null && !this.valueSet.contains(this.defaultValue)) {
            throw new IllegalArgumentException("The default value " + this.defaultValue + " of provisioning option " + this.name + " is not in the allowed value set " + builder.valueSet);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Set<String> getValueSet() {
        return this.valueSet;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.persistent ? 1231 : 1237);
        result = 31 * result + (this.required ? 1231 : 1237);
        result = 31 * result + (this.valueSet == null ? 0 : this.valueSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningOption other = (ProvisioningOption)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.persistent != other.persistent) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        return !(this.valueSet == null ? other.valueSet != null : !this.valueSet.equals(other.valueSet));
    }

    public static class Builder {
        private final String name;
        private boolean required;
        private boolean persistent = true;
        private String defaultValue;
        private Set<String> valueSet = Collections.emptySet();

        protected Builder(String name) {
            this.name = name;
        }

        public Builder setRequired() {
            this.required = true;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setBooleanValueSet() {
            this.valueSet = ProvisioningOption.getBooleanValueSet();
            return this;
        }

        public Builder addToValueSet(String ... value) {
            if (value.length > 0) {
                for (String v : value) {
                    this.valueSet = CollectionUtils.add(this.valueSet, v);
                }
            }
            return this;
        }

        public Builder setPersistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public ProvisioningOption build() {
            return new ProvisioningOption(this);
        }
    }
}

