/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.installation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.option.Option;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public abstract class AbstractInstallationCommand
extends PmSessionCommand
implements CommandWithInstallationDirectory {
    @Option(name="dir", required=false, description="Installation directory")
    protected File targetDirArg;

    protected ProvisioningManager getManager(PmSession session) throws ProvisioningException {
        return session.newProvisioningManager(Util.lookupInstallationDir(session.getAeshContext(), this.targetDirArg == null ? null : this.targetDirArg.toPath()), false);
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        try {
            return Util.lookupInstallationDir(context, this.targetDirArg == null ? null : this.targetDirArg.toPath());
        }
        catch (ProvisioningException ex) {
            return null;
        }
    }

    public FeatureContainer getFeatureContainer(PmSession session, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException, CommandExecutionException, IOException {
        FeatureContainer container;
        ProvisioningManager manager = this.getManager(session);
        if (manager.getProvisionedState() == null) {
            throw new CommandExecutionException("Specified directory doesn't contain an installation");
        }
        if (layout == null) {
            ProvisioningConfig config = manager.getProvisioningConfig();
            try (ProvisioningRuntime runtime = manager.getRuntime(config);){
                container = FeatureContainers.fromProvisioningRuntime(session, runtime);
            }
        }
        try (ProvisioningRuntime runtime = manager.getRuntime(layout);){
            container = FeatureContainers.fromProvisioningRuntime(session, runtime);
        }
        return container;
    }
}

