/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.state.ProvisionedPackage;
import org.jboss.galleon.util.CollectionUtils;

public class PackageRuntime
implements ProvisionedPackage {
    static final int ON_DEP_BRANCH = 1;
    static final int SCHEDULED = 2;
    static final int INCLUDED = 4;
    static final int PARENT_INCLUDED = 8;
    static final int ROOT = 16;
    static final int VISITED = 32;
    private final FeaturePackRuntime fp;
    private final PackageSpec spec;
    private final Path layoutDir;
    private final int status;
    private final boolean isPassiveIncluded;
    private final boolean passive;

    static Builder builder(FeaturePackRuntimeBuilder fp, PackageSpec spec, Path dir, int id) {
        return new Builder(fp, spec, dir, id);
    }

    private PackageRuntime(Builder builder, FeaturePackRuntime fp) {
        this.fp = fp;
        this.spec = builder.spec;
        this.layoutDir = builder.dir;
        this.passive = builder.type == 3;
        this.isPassiveIncluded = this.passive && builder.isPassiveWithSatisfiedDeps();
        this.status = builder.status;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public boolean isOptional() {
        return (this.status & 4) == 0 && ((this.status & 8) > 0 || (this.status & 0x10) > 0);
    }

    public boolean isPassiveIncluded() {
        return this.isPassiveIncluded;
    }

    public FeaturePackRuntime getFeaturePackRuntime() {
        return this.fp;
    }

    public PackageSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    public Path getResource(String ... path) throws ProvisioningDescriptionException {
        if (path.length == 0) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (path.length == 1) {
            return this.layoutDir.resolve(path[0]);
        }
        Path p = this.layoutDir;
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }

    public Path getContentDir() {
        return this.layoutDir.resolve("content");
    }

    static class Builder {
        final FeaturePackRuntimeBuilder fp;
        final Path dir;
        final PackageSpec spec;
        final int id;
        private int status;
        private List<Builder> requiredDeps = Collections.emptyList();
        private List<Builder> optionalDeps = Collections.emptyList();
        int type = 1;

        private Builder(FeaturePackRuntimeBuilder fp, PackageSpec spec, Path dir, int id) {
            this.fp = fp;
            this.dir = dir;
            this.spec = spec;
            this.id = id;
        }

        boolean isFlagOn(int flag) {
            return (this.status & flag) > 0;
        }

        boolean setFlag(int flag) {
            if ((this.status & flag) > 0) {
                return false;
            }
            this.status ^= flag;
            return true;
        }

        void clearFlag(int flag) {
            if ((this.status & flag) > 0) {
                this.status ^= flag;
            }
        }

        void schedule() {
            if (this.setFlag(2)) {
                this.fp.pkgOrder.add(this.spec.getName());
            }
        }

        void referencedAs(int type) {
            if (type == 3) {
                this.type = type;
            }
        }

        void addPackageDep(Builder dep, int type, int includedOptionalDeps) {
            if (type == 4) {
                if (this.isFlagOn(4)) {
                    dep.include();
                } else {
                    this.requiredDeps = CollectionUtils.add(this.requiredDeps, dep);
                }
                return;
            }
            if (includedOptionalDeps == 3 || includedOptionalDeps == 0) {
                return;
            }
            if (includedOptionalDeps == 2 || type == 3) {
                this.optionalDeps = CollectionUtils.add(this.optionalDeps, dep);
                if (this.isFlagOn(4)) {
                    dep.setFlag(8);
                }
            }
        }

        void include() {
            if (!this.setFlag(4)) {
                return;
            }
            if (!this.requiredDeps.isEmpty()) {
                for (Builder dep : this.requiredDeps) {
                    dep.include();
                }
            }
            if (!this.optionalDeps.isEmpty()) {
                for (Builder dep : this.optionalDeps) {
                    dep.setFlag(8);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isPassiveWithSatisfiedDeps() {
            if (this.type != 3) {
                return false;
            }
            int specRequiredDeps = this.spec.getRequiredPackageDepsTotal();
            if (specRequiredDeps == 0 || !this.setFlag(32)) {
                return true;
            }
            try {
                if (specRequiredDeps != this.requiredDeps.size()) {
                    boolean bl = false;
                    return bl;
                }
                for (Builder dep : this.requiredDeps) {
                    if (dep.isFlagOn(4) || dep.isPassiveWithSatisfiedDeps()) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.clearFlag(32);
            }
            return true;
        }

        PackageRuntime build(FeaturePackRuntime fp) {
            return new PackageRuntime(this, fp);
        }
    }
}

