/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.xml.XmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class ProvisionedStateXmlParser
implements XmlParser<ProvisionedState> {
    private static final ProvisionedStateXmlParser INSTANCE = new ProvisionedStateXmlParser();

    public static ProvisionedStateXmlParser getInstance() {
        return INSTANCE;
    }

    public static ProvisionedState parse(Path path) throws ProvisioningException {
        ProvisionedState provisionedState;
        block9: {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                provisionedState = ProvisionedStateXmlParser.getInstance().parse(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw new ProvisioningException(Errors.parseXml(path), e);
                }
            }
            reader.close();
        }
        return provisionedState;
    }

    private ProvisionedStateXmlParser() {
    }

    @Override
    public ProvisionedState parse(Reader input) throws XMLStreamException {
        ProvisionedState.Builder builder = ProvisionedState.builder();
        XmlParsers.parse(input, builder);
        return builder.build();
    }
}

