/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.FeaturePackXmlParser;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class FeaturePackDescriber {
    /*
     * Enabled aggressive exception aggregation
     */
    public static FeaturePackSpec readSpec(Path artifactZip) throws ProvisioningException {
        block18: {
            try (FileSystem zipfs = ZipUtils.newFileSystem(artifactZip);){
                FeaturePackSpec featurePackSpec;
                block19: {
                    Iterator<Path> iterator = zipfs.getRootDirectories().iterator();
                    if (!iterator.hasNext()) break block18;
                    Path zipRoot = iterator.next();
                    Path p = zipRoot.resolve("feature-pack.xml");
                    if (!Files.exists(p, new LinkOption[0])) {
                        throw new ProvisioningException("Feature-pack archive does not contain feature-pack.xml");
                    }
                    BufferedReader reader = Files.newBufferedReader(p);
                    try {
                        featurePackSpec = FeaturePackXmlParser.getInstance().parse(reader);
                        if (reader == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (XMLStreamException e) {
                            throw new ProvisioningException(Errors.parseXml(p), e);
                        }
                    }
                    reader.close();
                }
                return featurePackSpec;
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(artifactZip), e);
            }
        }
        return null;
    }

    public static FeaturePackDescription describeFeaturePackZip(Path artifactZip) throws IOException, ProvisioningDescriptionException {
        try (FileSystem zipfs = ZipUtils.newFileSystem(artifactZip);){
            Iterator<Path> iterator = zipfs.getRootDirectories().iterator();
            if (iterator.hasNext()) {
                Path zipRoot = iterator.next();
                FeaturePackDescription featurePackDescription = FeaturePackDescriber.describeFeaturePack(zipRoot, "UTF-8");
                return featurePackDescription;
            }
        }
        return null;
    }

    public static FeaturePackDescription describeFeaturePack(Path fpDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackDescription.Builder layoutBuilder;
        FeaturePackDescriber.assertDirectory(fpDir);
        Path fpXml = fpDir.resolve("feature-pack.xml");
        if (!Files.exists(fpXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(fpXml));
        }
        try (BufferedReader is = Files.newBufferedReader(fpXml, Charset.forName(encoding));){
            FeaturePackSpec.Builder specBuilder = FeaturePackSpec.builder();
            XmlParsers.parse(is, specBuilder);
            layoutBuilder = FeaturePackDescription.builder(specBuilder);
        }
        catch (IOException e) {
            throw new ProvisioningDescriptionException(Errors.openFile(fpXml));
        }
        catch (XMLStreamException e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(fpXml), e);
        }
        Path packagesDir = fpDir.resolve("packages");
        if (Files.exists(packagesDir, new LinkOption[0])) {
            FeaturePackDescriber.processPackages(layoutBuilder, packagesDir, encoding);
        }
        return layoutBuilder.build();
    }

    private static void processPackages(FeaturePackDescription.Builder fpBuilder, Path packagesDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackDescriber.assertDirectory(packagesDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(packagesDir);){
            for (Path path : stream) {
                fpBuilder.addPackage(FeaturePackDescriber.processPackage(path, encoding));
            }
        }
        catch (IOException e) {
            FeaturePackDescriber.failedToReadDirectory(packagesDir, e);
        }
    }

    private static PackageSpec processPackage(Path pkgDir, String encoding) throws ProvisioningDescriptionException {
        PackageSpec packageSpec;
        block10: {
            FeaturePackDescriber.assertDirectory(pkgDir);
            Path pkgXml = pkgDir.resolve("package.xml");
            if (!Files.exists(pkgXml, new LinkOption[0])) {
                throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(pkgXml));
            }
            BufferedReader in = Files.newBufferedReader(pkgXml, Charset.forName(encoding));
            try {
                packageSpec = PackageXmlParser.getInstance().parse(in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProvisioningDescriptionException(Errors.openFile(pkgXml), e);
                }
                catch (XMLStreamException e) {
                    throw new ProvisioningDescriptionException(Errors.parseXml(pkgXml), e);
                }
            }
            ((Reader)in).close();
        }
        return packageSpec;
    }

    private static void assertDirectory(Path dir) throws ProvisioningDescriptionException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.notADir(dir));
        }
    }

    private static void failedToReadDirectory(Path p, IOException e) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException(Errors.readDirectory(p), e);
    }
}

